﻿using RFrameGenerate.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using Wechat.Model;
using RFramework.SQLQuery;
using weixinopen;
using Wechat;
using RFramework.SQLServer;
using RFramework.SQLQuery.SQLExpands;
using RFrameGenerate.Common;
using RFrameGenerate.Model.PageModel;

namespace RFrameGenerate.BLL
{
    public class AgentTradingProfitManage
    {

        #region 获取代理订单利润明细-分页数据
        /// <summary>
        /// 获取代理订单利润明细-分页数据 
        /// </summary>
        /// <param name="gridModel"></param>
        /// <param name="name"></param>
        /// <returns></returns>
        public static List<T_BAS_TradingProfitWithLite> GetPageList(GridModel gridModel, Guid? groupGuip, string userid, string orderNo, DateTime? beginTime, DateTime? endTime)
        {
            using (var query = Factory.CreateT_BAS_TradingProfitWithLite())
            {
                endTime = endTime != null ? endTime.Value.AddDays(1) : endTime;
                List<T_BAS_TradingProfitWithLite> list = new List<T_BAS_TradingProfitWithLite>();
                if (MerchantManage.IsTop())
                {
                    var guids = AgentAuditManage.GetAllSubordinateAgentByMerGuid(CurrentManage.MerchantGuid);
                    if (guids == null || guids.Count == 0)
                    {
                        return list;
                    }
                    list = query.GetPageList(gridModel, c => c.MerchantGuid.SqlIn(guids.ToArray()) && c.FlagshipGroupGuid == groupGuip && c.OrderNo.SqlLike(orderNo) && c.Userid.SqlLike(userid) && c.TradeDate >= beginTime && c.TradeDate <= endTime, true, c => c.TradeDate, DAL.Enums.OrderMethods.DESC, RFramework.SQLServer.Enums.LockType.Default, false);
                }
                else
                {
                    list = query.GetPageList(gridModel, c => c.MerchantGuid == CurrentManage.MerchantGuid && c.FlagshipGroupGuid == groupGuip && c.OrderNo.SqlLike(orderNo) && c.Userid.SqlLike(userid) && c.TradeDate >= beginTime && c.TradeDate <= endTime, true, c => c.TradeDate, DAL.Enums.OrderMethods.DESC, RFramework.SQLServer.Enums.LockType.Default, false);
                }

                return list;
            }
        }
        #endregion



    }

}
