﻿using RFrameGenerate.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using Wechat.Model;
using RFramework.SQLQuery;
using weixinopen;
using Wechat;
using RFramework.SQLServer;
using RFramework.SQLQuery.SQLExpands;
using RFrameGenerate.Common;
using RFrameGenerate.Model.PageModel;
using System.Text.RegularExpressions;

namespace RFrameGenerate.BLL
{
    public class AgentWithdrawManage
    {

        #region 获取代理申请提现-分页数据
        /// <summary>
        /// 获取代理申请提现-分页数据 
        /// </summary>
        /// <param name="gridModel"></param>
        /// <param name="name"></param>
        /// <returns></returns>
        public static List<T_BAS_FactorageWithdrawal> GetPageList(GridModel gridModel, int? TradingType, string TradingCode, DateTime? beginTime, DateTime? endTime, DateTime? beginTimeSe, DateTime? endTimeSe)
        {
            using (var query = Factory.CreateT_BAS_FactorageWithdrawal())
            {
                endTime = endTime != null ? endTime.Value.AddDays(1) : endTime;
                endTimeSe = endTimeSe != null ? endTimeSe.Value.AddDays(1) : endTimeSe;
                var list = query.GetPageList(gridModel, c => c.MerchantGuid == Common.CurrentManage.MerchantGuid && c.TradingType == TradingType && c.TradingCode.SqlLike(TradingCode) && c.ApplyTime >= beginTime && c.ApplyTime <= endTime && c.DealWithTime >= beginTimeSe && c.DealWithTime <= endTimeSe, true, c => c.ApplyTime, DAL.Enums.OrderMethods.DESC, RFramework.SQLServer.Enums.LockType.Default);
                return list;
            }
        }
        #endregion


        #region 提现申请
        public static object AddAgentWithdraw(T_BAS_FactorageWithdrawal entity)
        {
            //if (entity.AccountType != FactorageWithdrawalConst.AccountType.ElementAt(0).Key && new Regex("").IsMatch(entity.AccountCode))
            //{
            //    return new Result(false);
            //}
            if (AgentAccountManage.IsCountFsBalance)
            {
                return new Result(false, "系统繁忙，请稍后重试");
            }

            var available = 0m;
            var freeze = 0m;
            AgentCommissionManage.GetAvailableAndFreeze(Common.CurrentManage.MerchantGuid, ref available, ref freeze);
            if (entity.TradingAmount > available)
            {
                return new Result(false, "提现金额不能超过可用余额");
            }
            using (var tran = new SqlRTransaction())
            {
                try
                {
                    tran.BeginTransaction();
                    var query = Factory.CreateT_BAS_FactorageWithdrawal(tran);
                    var queryMer = Factory.CreateT_BAS_Merchants(tran);

                    entity.FactorageWithdrawalGuid = Guid.NewGuid();
                    entity.TradingCode = DateTime.Now.ToString("yyyyMMddHHmmss") + string.Format("{0:D2}", FactorageWithdrawalConst.TradingType.审核中);
                    entity.TradingType = FactorageWithdrawalConst.TradingType.审核中;
                    entity.ApplyTime = DateTime.Now;
                    entity.MerchantGuid = Common.CurrentManage.MerchantGuid;

                    query.Add(entity);

                    var query_FactorageAccount = Factory.CreateT_BAS_FactorageAccount(tran);
                    query_FactorageAccount.Add(new T_BAS_FactorageAccount()
                    {
                        FactorageAccountGuid = Guid.NewGuid(),
                        MerchantGuid = Common.CurrentManage.MerchantGuid,
                        TradingCode = DateTime.Now.ToString("yyyyMMddHHmmss") + string.Format("{0:D2}", AgentCommissionConst.TradingType.申请提现),
                        AvailableBalance = (available - entity.TradingAmount),
                        TradingType = AgentCommissionConst.TradingType.申请提现,
                        FactorageSubjectGuid = Common.CurrentManage.MerchantGuid,
                        TradingAmount = entity.TradingAmount,
                        TradingDate = DateTime.Now
                    });

                    var fs = available - entity.TradingAmount;
                    var cf = freeze + entity.TradingAmount;
                    queryMer.Update(c => new object[] { 
                            c.FsBalance==fs,
                            c.ComFreeze==cf
                        }, c => c.MerchantGuid == Common.CurrentManage.MerchantGuid, isFilterMerchant: false);

                    if (AgentAccountManage.IsCountFsBalance)
                    {
                        return new Result(false, "系统繁忙，请稍后重试");
                    }

                    tran.Commit();
                    return new Result(true);

                }
                catch (Exception ex)
                {
                    tran.Rollback();
                    return new Result(false, ex.Message);
                }
            }
        }
        #endregion
    }




}
