﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using RFrameGenerate.Model;
using RFramework.SQLQuery;
using RFrameGenerate.DAL.Interface;

namespace RFrameGenerate.BLL
{
    public class AgentsFlagshipManage
    {
        public static T_BAS_AgentsFlagship GetEntity(Guid merchantGuid)
        {
            using (var query = Factory.CreateT_BAS_AgentsFlagship())
            {
                return query.GetFirstData(m => m.MerchantGuid == merchantGuid && m.FatherMerchantGuid.SqlIsNull(), false, null, DAL.Enums.OrderMethods.Default, RFramework.SQLServer.Enums.LockType.Default, false);
            }
        }

        public static T_BAS_AgentsFlagship GetEntityByMerchantGuid(Guid guid)
        {
            using (var query = Factory.CreateT_BAS_AgentsFlagship())
            {
                return query.GetFirstData(m => m.MerchantGuid == guid, false, null, DAL.Enums.OrderMethods.Default, RFramework.SQLServer.Enums.LockType.Default, false);
            }
        }

        public static List<T_BAS_AgentsFlagship> GetListByFlagshipPackGuid(Guid guid)
        {
            using (var query = Factory.CreateT_BAS_AgentsFlagship())
            {
                return query.GetList(m => m.FlagshipPackGuid == guid);
            }
        }

        public static bool IsExistByFlagshipPackGuid(Guid guid)
        {
            using (var query = Factory.CreateT_BAS_AgentsFlagship())
            {
                return query.IsExist(m => m.FlagshipPackGuid == guid);
            }
        }

        public static int GetCountByFlagshipPackGuid(Guid guid)
        {
            using (var query = Factory.CreateT_BAS_AgentsFlagship())
            {
                return query.GetCount(m => m.FlagshipPackGuid == guid);
            }
        }

        public static List<T_BAS_AgentsFlagship> GetSubMerchantList()
        {
            var resultlist = new List<T_BAS_AgentsFlagship>();

            using (var query = Factory.CreateT_BAS_AgentsFlagship())
            {
                GetSubList(RFrameGenerate.Common.CurrentManage.MerchantGuid, resultlist, query);
            }

            return resultlist;
        }

        public static T_BAS_AgentsFlagship GetSupMerchant(Guid merchantGuid)
        {
            var result = new T_BAS_AgentsFlagship();

            using (var query = Factory.CreateT_BAS_AgentsFlagship())
            {
                GetSup(merchantGuid, ref result, query);
            }

            return result;
        }

        private static void GetSubList(Guid guid, List<T_BAS_AgentsFlagship> sublist, IQuery<T_BAS_AgentsFlagship> query)
        {
            var list = query.GetList(m => m.FatherMerchantGuid == guid, false, null, DAL.Enums.OrderMethods.Default, RFramework.SQLServer.Enums.LockType.Default, false);

            if (list == null || list.Count <= 0) return;

            sublist.AddRange(list);

            foreach (var item in list)
            {
                GetSubList(item.MerchantGuid.Value, sublist, query);
            }
        }

        private static void GetSup(Guid guid, ref T_BAS_AgentsFlagship result, IQuery<T_BAS_AgentsFlagship> query)
        {
            var model = query.GetFirstData(m => m.MerchantGuid == guid, false, null, DAL.Enums.OrderMethods.Default, RFramework.SQLServer.Enums.LockType.Default, false);

            result = model;

            if (model == null || model.FatherMerchantGuid == null) return;

            GetSup(result.FatherMerchantGuid.Value, ref result, query);
        }


       


    }
}
