﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Net;
using System.Text;
using RFrameGenerate.Common;
using RFrameGenerate.DAL.Enums;
using RFrameGenerate.Model;
using RFramework.SQLQuery;
using RFramework.SQLServer;

namespace RFrameGenerate.BLL
{
    public class ApplyDistributionRecordsManage
    {
        #region List<T_BAS_ApplyDistributionRecords> GetApplyPageList
        /// <summary>
        /// get apply page list 
        /// </summary>
        /// <param name="gridModel"></param>
        /// <param name="name"></param>
        /// <returns></returns>
        public static List<T_ST_MemberAndApply> GetApplyPageList(GridModel gridModel, string name)
        {
            using (var query = Factory.CreateT_ST_MemberAndApply())
            {
                return query.GetPageList(gridModel, c => c.DistributionName.SqlLike(name), true, b => b.ApplyDateTime, OrderMethods.DESC);
            }
        }
        #endregion

        #region Result UpdateApplyState

        /// <summary>
        /// (checkpass)update apply state
        /// </summary>
        /// <param name="applyDistributionRecordsGuid"></param>
        /// <param name="stateCode"></param>
        /// <returns></returns>
        public static Result UpdateApplyState(Guid applyDistributionRecordsGuid, int stateCode)
        {
            using (var query = Factory.CreateT_BAS_ApplyDistributionRecords())
            {
                query.Update(c => new object[]
                {
                    c.State==stateCode,
                    c.ApplyDateTime==DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")
                }, a => a.ApplyDistributionRecordsGuid == applyDistributionRecordsGuid);
            }
            return new Result(true);
        }

        public static Result UpdateApplyStateByMember(Guid member, T_BAS_ApplyDistributionRecords entity, int stateCode)
        {
            using (var query = Factory.CreateT_BAS_ApplyDistributionRecords())
            {
                query.Update(c => new object[]
                {
                    c.State==stateCode,

                    c.Telphone == entity.Telphone,
                    c.DistributionName==entity.DistributionName,
                    c.ApplyDateTime==DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")
                }, a => a.MemberGuid == member);
            }
            return new Result(true);
        }
        #endregion
        //前台申请成功分销商
        public static Result AddBecomeDistribution(T_BAS_ApplyDistributionRecords entity, int state)
        {
            if (string.IsNullOrEmpty(CookieManage.GetCookie(SessionKeys.ShareDistribution)))
            {
                entity.ParentMemberGuid = null;
            }
            else
            {
                entity.ParentMemberGuid = Guid.Parse(CookieManage.GetCookie(SessionKeys.ShareDistribution));
            }

            using (var tran = new SqlRTransaction())
            {
                tran.BeginTransaction();
                entity.ApplyDistributionRecordsGuid = Guid.NewGuid();
                entity.State = state;
                entity.ApplyDateTime = DateTime.Now.ToString();

                entity.SuperiorName = DistributionManage.GetShareName();
                var query = Factory.CreateT_BAS_ApplyDistributionRecords(tran);

                if (query.IsExist(a => a.MemberGuid == entity.MemberGuid) == true)
                    return new Result(false, "您已申请!");

                query.Add(entity);
                tran.Commit();
            }
            return new Result(true);
        }
        /// <summary>
        /// 后台会员成功分销商
        /// </summary>
        /// <param name="entity"></param>
        /// <param name="state"></param>
        /// <returns></returns>
        public static Result AddBecomeDistribution2(T_BAS_ApplyDistributionRecords entity, int state)
        {
            using (var tran = new SqlRTransaction())
            {
                var query = Factory.CreateT_BAS_ApplyDistributionRecords(tran);
                entity.State = state;
                if (query.IsExist(a => a.MemberGuid == entity.MemberGuid) == true)
                    return new Result(false, "已申请!");
                query.Add(entity);

            }
            return new Result(true);
        }
        public static Result AddReseller(T_BAS_ApplyDistributionRecords entity)
        {
            using (var query = Factory.CreateT_BAS_ApplyDistributionRecords())
            {
                query.Add(entity);
            }
            return new Result(true);
        }

        public static int GetApplyState()
        {
            using (var query = Factory.CreateT_BAS_ApplyDistributionRecords())
            {
                var apply = query.GetFirstData(c => c.MemberGuid == RFrameGenerate.Common.CurrentUser.GetCurrUserGuid());
                if (apply != null)
                {
                    return apply.State.Value;
                }
                else
                {
                    return RFrameGenerate.BLL.DictionaryConst.Apply.None;
                }
            }
        }

        //public static int DisCount()
        //{
        //    using (var query = Factory.CreateT_BAS_ApplyDistributionRecords())
        //    {
        //        return query.GetCount(c => c.MemberGuid == RFrameGenerate.Common.CurrentUser.GetCurrUserGuid());
        //    }
        //}

        public static Guid GetMemberGuid(Guid applyGuid)
        {
            using (var query = Factory.CreateT_BAS_ApplyDistributionRecords())
            {
                return query.GetFirstData(c => c.ApplyDistributionRecordsGuid == applyGuid).MemberGuid.Value;

            }
        }

        public static T_BAS_ApplyDistributionRecords GetApplyRecord(Guid applyGuid)
        {
            using (var query = Factory.CreateT_BAS_ApplyDistributionRecords())
            {
                return query.GetFirstData(c => c.ApplyDistributionRecordsGuid == applyGuid);

            }
        }

        public static int GetIsApplyState(Guid memeberGuid)
        {
            using (var query = Factory.CreateT_BAS_ApplyDistributionRecords())
            {
                var model = query.GetFirstData(a => a.MemberGuid == memeberGuid);
                if (model == null)
                    return RFrameGenerate.BLL.DictionaryConst.Apply.None;
                return model.State.Value;
            }
        }

    }
}
