﻿using RFrameGenerate.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using RFramework.SQLQuery;
using RFramework.SQLServer;

namespace RFrameGenerate.BLL
{
    public class ApplyWeiXinHaiRecordManage
    {
        public static Result ApplyMer(string userid, string password, string store, int type, int year)
        {
            if (string.IsNullOrEmpty(userid) == true)
                return new Result(false, "userid为空");
            if (string.IsNullOrEmpty(password) == true)
                return new Result(false, "password");
            if (string.IsNullOrEmpty(store) == true)
                return new Result(false, "store");
            if (year <= 0)
                return new Result(false, "year出错");

            if (type != DictionaryConst.Versionb.Syb && type != DictionaryConst.Versionb.Flagship)
                return new Result(false, "type值不正确[1.创业版,2.旗舰版]");

            if (type == DictionaryConst.Versionb.Flagship)
                return new Result(false, "旗舰版还未开放");

            using (var tran = new SqlRTransaction())
            {
                var query = Factory.CreateT_BAS_ApplyWeiXinHaiRecords(tran);
                var queryMer = Factory.CreateT_BAS_Merchants(tran);

                if (queryMer.IsExist(a => a.UserID == userid, false, false) != true)//商家
                {
                    if (query.IsExist(a => a.UserID == userid && a.ApplyState == DictionaryConst.AgentApplyState.Audit, false, false) != true)//未审核
                    {
                        query.Add(new T_BAS_ApplyWeiXinHaiRecords()
                        {
                            AgentGuid = Guid.Parse(RFrameGenerate.BLL.SystemParameters.ParameterConst.WeiXinHaiAgentGuid),
                            UserID = userid,
                            ApplyWeiXinHaiRecordsGuid = Guid.NewGuid(),
                            OpenType = type,
                            Password = RFrameGenerate.Common.Utils.Md5(password),
                            StoreTitle = store,
                            Year = year,
                            ApplyState = DictionaryConst.AgentApplyState.Audit,
                            ApplyDate = DateTime.Now
                        });
                        return new Result(true);
                    }
                }
                return new Result(false, userid + "已存在");
            }
        }

        public static List<T_BAS_ApplyWeiXinHaiRecords> GetPageList(GridModel gridModel, string userid)
        {
            using (var query = Factory.CreateT_BAS_ApplyWeiXinHaiRecords())
            {
                //&& a.UserID.SqlLike(userid)
                var aa = query.GetPageList(gridModel, a => a.AgentGuid == RFrameGenerate.Common.CurrentUser.GetCurrUserGuid(), true, a => a.ApplyDate, DAL.Enums.OrderMethods.DESC, RFramework.SQLServer.Enums.LockType.Default, false);
                return aa;
            }
        }

        public static Result Audit(Guid applyGuid, int state)
        {

            using (var tran = new SqlRTransaction())
            {
                tran.BeginTransaction();
                var query = Factory.CreateT_BAS_ApplyWeiXinHaiRecords(tran);
                query.Update(a => new object[] { a.ApplyState == state }, b => b.ApplyWeiXinHaiRecordsGuid == applyGuid, false);
                if (state == DictionaryConst.AgentApplyState.AuditPass)
                {
                    var apply = query.GetFirstData(a => a.ApplyWeiXinHaiRecordsGuid == applyGuid, false, a => a.ApplyDate, DAL.Enums.OrderMethods.DESC, RFramework.SQLServer.Enums.LockType.Default, false);
                    var queryMer = Factory.CreateT_BAS_Merchants(tran);
                    var domain = RFrameGenerate.Common.CurrentManage.Domain;
                    domain = domain.Replace("http://", apply.UserID + ".");
                    Guid merGuid = Guid.NewGuid();
                    queryMer.Add(new T_BAS_Merchants()
                    {
                        AgentGuid = Guid.Parse(RFrameGenerate.BLL.SystemParameters.ParameterConst.WeiXinHaiAgentGuid),
                        UserID = apply.UserID,
                        StoreTitle = apply.StoreTitle,
                        Password = apply.Password,
                        IsEnable = true,
                        UserType = apply.OpenType,
                        StoreUrl = domain,
                        MerchantGuid = merGuid,
                        StoreState = true,
                        CloseReason = "",
                        CreateDate = DateTime.Now,
                        ExpireDate = DateTime.Now.AddYears(apply.Year.Value),
                        TotalDistributionOrders = 0,
                        TotalDistributor = 0,
                        HomePageProductNum = 4,
                        MentionedAmount = 0,
                        DistributionOrdersAmount = 0,
                        CumulativeDistributionAmount = 0,
                        IsCustomerServices = false,
                    });

                    List<T_SYS_Parameter> plist = new List<T_SYS_Parameter>();
                    var parameterName = "extendedReceipt,refundService_paid,distributionchart,secondCommission,firstCommission,thirdCommission,withdrawalNumberLimits,refundService_validity,refundService_delivery,refundService_completed,amountLimit,autoExpirationTime,extNumber,payments,withdrawalAmountLimits,commissionSettlementTime,distributorRelations,topNumber,auditApproach,minAmount,openRefundService,automaticWrite,distributionVisible";
                    var parameterValue = "3,2,1,15,20,10,10,7,3,5,20,0,1,微信钱包,10,6,分销商购买获得一级佣金 ,20,0,1,1,7,3";
                    var pn = parameterName.Split(',');
                    var pv = parameterValue.Split(',');
                    var length = pn.Length;

                    for (int i = 0; i < length; i++)
                    {
                        T_SYS_Parameter parameterObj = new T_SYS_Parameter()
                        {
                            ParameterGuid = Guid.NewGuid(),
                            MerchantGuid = merGuid,
                            ParameterName = pn[i],
                            ParameterValue = pv[i]
                        };
                        plist.Add(parameterObj);
                    }
                    var result = ParameterManage.AddExtSettingParameters(plist);
                    if (result.State == false)
                        return new Result(false, "保存失败");
                }
                tran.Commit();
                return new Result(true);
            }
        }
    }
}
