﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using RFramework.SQLServer;
using RFrameGenerate.Model;
using RFrameGenerate.DAL;
using RFrameGenerate.Common;

namespace RFrameGenerate.BLL
{
    public class AutoReplyRule
    {
        public class ConstRuleName
        {
            /// <summary>
            /// 自动回复参数1名称
            /// </summary>
            public const string AutoReply1 = "AutoReply1";
            /// <summary>
            /// 自动回复参数2名称
            /// </summary>
            public const string AutoReply2 = "AutoReply2";
            /// <summary>
            /// 自动回复参数3名称
            /// </summary>
            public const string AutoReply3 = "AutoReply3";
            /// <summary>
            /// 自动回复参数4名称
            /// </summary>
            public const string AutoReply4 = "AutoReply4";
        }

        public static List<string> Rules;
        static AutoReplyRule()
        {
            Rules = new List<string>();
            Rules.Add("F[Join]");//第几个关注会员
            Rules.Add("F[DIDName]");//分销商
            Rules.Add("F[StoreName]");//店铺
            Rules.Add("F[NickName]");//第几个关注会员
            Rules.Add("S[DT]");//当前时间
            Rules.Add("C[Txt1]");
            Rules.Add("C[Txt2]");
            Rules.Add("C[Txt3]");
            Rules.Add("C[Txt4]");
        }

        public static string RuleParse(string ruleTxt, Guid merchGuid, string openid)
        {
            CurrentUser.SetMerchantGuid(merchGuid);
            if (ruleTxt.Contains("[") == true && ruleTxt.Contains("]") == true)
            {
                try
                {
                    using (var tran = new SqlRTransaction())
                    {
                        foreach (var v in Rules)
                        {
                            if (ruleTxt.Contains(v) == true)
                            {
                                switch (v)
                                {
                                    case "F[Join]":
                                        {
                                            var count = Factory.CreateT_BAS_Member(tran).GetCount(a => a.MerchantGuid == merchGuid, false, false);
                                            ruleTxt = ruleTxt.Replace("F[Join]", count.ToString());
                                            break;
                                        }
                                    case "F[DIDName]":
                                        {
                                            var member = Factory.CreateT_BAS_Member(tran).GetFirstData(a => a.MerchantGuid == merchGuid && a.MemberOpenID == openid, false, null, DAL.Enums.OrderMethods.Default, RFramework.SQLServer.Enums.LockType.Default, false);
                                            if (member != null && member.DID != null)
                                            {
                                                var did = Factory.CreateT_BAS_DistributionProp(tran).GetFirstData(a => a.DistributionPropGuid == member.DID, false, null, DAL.Enums.OrderMethods.Default, RFramework.SQLServer.Enums.LockType.Default, false);
                                                if (did != null)
                                                    ruleTxt = ruleTxt.Replace("F[DIDName]", did.DistributionName);
                                                else
                                                    ruleTxt = ruleTxt.Replace("F[DIDName]", "总部 ");
                                            }
                                            else
                                            {
                                                ruleTxt = ruleTxt.Replace("F[DIDName]", "总部");
                                            }
                                            break;
                                        }
                                    case "F[StoreName]":
                                        {
                                            string name = DistributionManage.GetAttentionShareTitle(openid);
                                            ruleTxt = ruleTxt.Replace("F[StoreName]", name);
                                            break;
                                        }
                                    case "F[NickName]":
                                        {
                                            var memer = Factory.CreateT_BAS_Member(tran).GetFirstData(a => a.MerchantGuid == merchGuid && a.MemberOpenID == openid, false, null, DAL.Enums.OrderMethods.Default, RFramework.SQLServer.Enums.LockType.Default, false);
                                            ruleTxt = ruleTxt.Replace("F[NickName]", memer.MemberNickName);
                                            break;
                                        }
                                    case "S[DT]":
                                        {
                                            ruleTxt = ruleTxt.Replace("S[DT]", DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss"));
                                            break;
                                        }
                                    case "C[Txt1]":
                                        {
                                            var param = Factory.CreateT_SYS_Parameter(tran).GetFirstData(a => a.ParameterName == ConstRuleName.AutoReply1 && a.MerchantGuid == merchGuid);
                                            if (param != null)
                                            {
                                                ruleTxt = ruleTxt.Replace("C[Txt1]", param.ParameterValue);
                                            }
                                            break;
                                        }
                                    case "C[Txt2]":
                                        {
                                            var param = Factory.CreateT_SYS_Parameter(tran).GetFirstData(a => a.ParameterName == ConstRuleName.AutoReply2 && a.MerchantGuid == merchGuid);
                                            if (param != null)
                                            {
                                                ruleTxt = ruleTxt.Replace("C[Txt2]", param.ParameterValue);
                                            }
                                            break;
                                        }
                                    case "C[Txt3]":
                                        {
                                            var param = Factory.CreateT_SYS_Parameter(tran).GetFirstData(a => a.ParameterName == ConstRuleName.AutoReply3 && a.MerchantGuid == merchGuid);
                                            if (param != null)
                                            {
                                                ruleTxt = ruleTxt.Replace("C[Txt3]", param.ParameterValue);
                                            }
                                            break;
                                        }
                                    case "C[Txt4]":
                                        {
                                            var param = Factory.CreateT_SYS_Parameter(tran).GetFirstData(a => a.ParameterName == ConstRuleName.AutoReply4 && a.MerchantGuid == merchGuid);
                                            if (param != null)
                                            {
                                                ruleTxt = ruleTxt.Replace("C[Txt4]", param.ParameterValue);
                                            }
                                            break;
                                        }
                                }
                            }
                        }
                    }
                }
                catch (Exception ex)
                {
                    Wechat.LogManage.Log("规则处理失败:" + ex.Message);
                }
            }
            return ruleTxt;
        }
    }
}
