﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using RFramework.SQLQuery;
using RFramework.SQLQuery.SQLExpands;
using RFramework.SQLServer.Enums;
using RFrameGenerate.Model;
using System.Linq.Expressions;

namespace RFrameGenerate.BLL.Category
{
    public class CategoryManage
    {
        public static List<T> GetCategories<T>(string categoryCode, Func<Model.T_JD_ProductCategory, T> selectorfield)
        {
            using (var sql = new SqlModel<Model.T_JD_ProductCategory>())
            {
                return sql.SqlSelect(selectorfield)
                          .SqlWhere(m => m.Status == 0 && m.ParentNode == categoryCode)
                          .SqlOrderBy(m => m.Sort)
                          .ToList();
            }
        }

        public static List<T> GetCategories<T>(string[] categoryCodes, Func<Model.T_JD_ProductCategory, T> selectorfield)
        {
            using (var sql = new SqlModel<Model.T_JD_ProductCategory>())
            {
                return sql.SqlSelect(selectorfield)
                          .SqlWhere(m => m.Status == 0 && m.CategoryCode.SqlIn(categoryCodes) && m.ParentNode == "0")
                          .SqlOrderBy(m => m.Sort)
                          .ToList();
            }
        }

        public static T GetCategory<T>(string code, Func<Model.T_JD_ProductCategory, T> selectorfield)
        {
            if (string.IsNullOrEmpty(code)) return default(T);

            using (var sql = new SqlModel<Model.T_JD_ProductCategory>())
            {
                return sql.SqlSelect(selectorfield)
                          .SqlWhere(m => m.CategoryCode == code)
                          .FirstOrDefault();
            }
        }

        public static Result UpdateCategory(T_JD_ProductCategory category)
        {
            var checkState = CheckCategory(category);

            if (!checkState.State) return new Result(false, checkState.Msg);

            using (var sql = new SqlModel<Model.T_JD_ProductCategory>())
            {
                var model = sql.SqlSelect()
                               .SqlWhere(m => m.ProductCategoryGuid == category.ProductCategoryGuid)
                               .FirstOrDefault();

                if (model == null) return new Result(false, "不存在类目！");

                var state = sql.SqlUpdate(m => new object[] { 
                    m.CategoryName == category.CategoryName, 
                    m.CategoryNameSpell == category.CategoryNameSpell,      
                    m.Status == category.Status, 
                    m.Sort == category.Sort },
                    v => v.ProductCategoryGuid == category.ProductCategoryGuid);

                if (!state) return new Result(false, "更新失败!");

                return new Result(true);
            }
        }

        public static List<T_JD_ProductCategory> CategoryTrees(string code)
        {
            List<T_JD_ProductCategory> list = new List<T_JD_ProductCategory>();
            using (var sql = new SqlModel<Model.T_JD_ProductCategory>())
            {
                list = CategoryTrees(code, 1, list, sql);
            }
            return list;
        }

        public static bool IsVirtual(string code)
        {
            if (string.IsNullOrEmpty(code)) return false;

            var category = GetCategory(code, m => new { m.IsVirtual });

            if (category == null) return false;

            if (category.IsVirtual == null) return false;

            return category.IsVirtual.Value;
        }

        private static List<T_JD_ProductCategory> CategoryTrees(string code, int level, List<T_JD_ProductCategory> list, SqlModel<Model.T_JD_ProductCategory> sql)
        {
            if (level >= 5) return list;

            var category = sql.SqlSelect().SqlWhere(m => m.CategoryCode == code).FirstOrDefault();

            if (category == null) return list;

            list.Add(category);

            if (category.ParentNode == "0") return list;

            return CategoryTrees(category.ParentNode, ++level, list, sql);
        }

        private static Result CheckCategory(T_JD_ProductCategory category)
        {
            if (category == null) return new Result(false, "保存对象不能为空！");

            if (category.ProductCategoryGuid == Guid.Empty) return new Result(false, "对象ID不能为空！");

            if (string.IsNullOrEmpty(category.CategoryName)) return new Result(false, "类目名称不能为空！");

            if (string.IsNullOrEmpty(category.CategoryNameSpell)) return new Result(false, "类目拼音不能为空！");

            if (category.Status == null) return new Result(false, "启用状态不能为空！");

            if (category.Sort == null) return new Result(false, "排序不能为空！");

            return new Result(true);
        }

    }
}
