﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using OfficeOpenXml.ConditionalFormatting;
using RFrameGenerate.DAL.SQLServer;
using RFrameGenerate.Model;
using RFramework.SQLServer;

namespace RFrameGenerate.BLL
{
    public class CommentManage
    {
        public static Result SaveEvaluate(List<Evaluates> list, Guid orderGuid, bool isAnon)
        {
            try
            {
                using (var tran = new SqlRTransaction())
                {
                    var query = Factory.CreateT_BAS_Comments(tran);
                    var queryOrder = Factory.CreateT_BAS_Orders(tran);
                    var query_orderDetails = Factory.CreateT_BAS_OrderDetails(tran);
                    tran.BeginTransaction();
                    foreach (var v in list)
                    {
                        query.Add(new T_BAS_Comments() { CommentGuid = Guid.NewGuid(), Content = v.context, DateTime = DateTime.Now, IsShow = true, MemberGuid = RFrameGenerate.Common.CurrentUser.GetCurrUserGuid(), ProductGuid = v.product, Score = v.evaluate, });
                    }
                    queryOrder.Update(a => new object[] 
                    { 
                        a.OrderState == DictionaryConst.OrderState.Completed,
                        a.OrderInnerState == DictionaryConst.OrderInnerState.Completed ,
                        a.IsComment==true,
                    }, b => b.OrderGuid == orderGuid);
                    var listDetail = query_orderDetails.GetList(a => a.OrderGuid == orderGuid);
                    if (listDetail != null && listDetail.Count > 0)
                    {
                        foreach (var item in listDetail)
                        {
                            item.State = DictionaryConst.OrderDetailState.Null;
                            item.EntityState = EntityStates.ToBeUpdated;
                        }
                        query_orderDetails.UpdateList(listDetail);
                    }
                    tran.Commit();
                }

                return new Result(true);
            }
            catch (Exception ex)
            {
                return new Result(false, ex.Message);
            }
        }

        public static Result SaveEvaluate(List<T_BAS_Comments> list, List<T_BAS_CommentsImg> listImg, Guid orderGuid)
        {
            try
            {
                using (var tran = new SqlRTransaction())
                {
                    if (list == null || list.Count == 0) return new Result(false, "没有数据！");
                    bool flag = true;
                    foreach (var item in list)
                    {
                        if (item.Score == null || item.Score == 0)
                        {
                            flag = false;
                            break;
                        }
                    }
                    if (!flag) return new Result(false, "评分不能为空！");

                    var query = Factory.CreateT_BAS_Comments(tran);
                    var query_img = Factory.CreateT_BAS_CommentsImg(tran);
                    var query_order = Factory.CreateT_BAS_Orders(tran);
                    var query_orderDetails = Factory.CreateT_BAS_OrderDetails(tran);
                    tran.BeginTransaction();
                    try
                    {
                        query.AddList(list);
                        if (listImg != null && listImg.Count > 0)
                        {
                            query_img.AddList(listImg);
                        }
                        query_order.Update(a => new object[] 
                        { 
                            a.OrderState == DictionaryConst.OrderState.Completed,
                            a.OrderInnerState == DictionaryConst.OrderInnerState.Completed ,
                            a.IsComment==true
                        }, b => b.OrderGuid == orderGuid);

                        var listDetail = query_orderDetails.GetList(a => a.OrderGuid == orderGuid);
                        if (listDetail != null && listDetail.Count > 0)
                        {
                            foreach (var item in listDetail)
                            {
                                item.State = DictionaryConst.OrderDetailState.Null;
                                item.EntityState = EntityStates.ToBeUpdated;
                            }
                            query_orderDetails.UpdateList(listDetail);
                        }
                        tran.Commit();
                    }
                    catch (Exception err)
                    {
                        tran.Rollback();
                        return new Result(false, err.Message);
                    }
                }
                return new Result(true);
            }
            catch (Exception ex)
            {
                return new Result(false, ex.Message);
            }
        }

        public static List<T_BAS_Evaluations> GetCommentsByProduct(Guid productGuid)
        {
            List<T_BAS_Evaluations> listEvaluations = new List<T_BAS_Evaluations>();
            using (var tran = new SqlRTransaction())
            {
                var query = Factory.CreateT_BAS_Comments(tran);
                var query_member = Factory.CreateT_BAS_Member(tran);
                var list = query.GetList(a => a.ProductGuid == productGuid);
                if (list == null || list.Count == 0) return null;
                foreach (var model in list)
                {
                    T_BAS_Evaluations entity = new T_BAS_Evaluations();
                    var model_member = query_member.GetFirstData(a => a.MemberGuid == model.MemberGuid);
                    if (model_member != null)
                    {
                        entity.CommentGuid = model.CommentGuid;
                        entity.Content = model.Content;
                        entity.MemberGuid = model.MemberGuid;
                        entity.ProductCategoryGuid = model.ProductCategoryGuid;
                        entity.ProductGuid = model.ProductGuid;
                        entity.Score = model.Score;
                        entity.DateTime = model.DateTime.Value.ToString("yyyy-MM-dd HH:mm");
                        entity.IsShow = model.IsShow;
                        if (entity.IsShow == true)
                        {
                            entity.MemberName = model_member.MemberNickName;
                        }
                        else
                        {
                            if (string.IsNullOrEmpty(model_member.MemberNickName) != true)
                                entity.MemberName = model_member.MemberNickName.Substring(0, 1) + "***" + model_member.MemberNickName.Substring(model_member.MemberNickName.Length - 1, 1);
                        }
                        listEvaluations.Add(entity);
                    }
                }
                return listEvaluations;
            }
        }

        public static CommentTypeCount GetCommentType(List<T_BAS_Evaluations> list)
        {
            CommentTypeCount model = null;
            if (list == null || list.Count == 0)
            {
                model = new CommentTypeCount(0, 0, 0, 0);

            }
            else
            {
                model = new CommentTypeCount();
                model.AllCount = list.Count;
                model.PositiveCount = list.Where(a => a.Score.Value == 4 || a.Score.Value == 5).ToList().Count;
                model.ModerateCount = list.Where(a => a.Score.Value == 3).ToList().Count;
                model.NegativeCount = list.Where(a => a.Score.Value == 1 || a.Score.Value == 2).ToList().Count;
            }
            return model;
        }

        public class CommentTypeCount
        {
            public int AllCount { get; set; }
            public int PositiveCount { get; set; }
            public int ModerateCount { get; set; }
            public int NegativeCount { get; set; }

            public CommentTypeCount() { }
            public CommentTypeCount(int allCount, int positivecount, int moderatecount, int negativecount)
            {
                this.AllCount = allCount;
                this.PositiveCount = positivecount;
                this.ModerateCount = moderatecount;
                this.NegativeCount = negativecount;
            }
        }
    }
}
