﻿using System;
using System.Collections.Generic;
using System.Configuration;
using System.Linq;
using System.Text;
using System.Web;
using System.Xml;

namespace RFrameGenerate.BLL
{
    /// <summary>
    /// web配置类
    /// </summary>
    public sealed class WebConfig
    {
        static XmlDocument doc = new XmlDocument();
        /// <summary>
        /// 读取配置文件(所有节点全部小写)
        /// </summary>
        /// <param name="xpath"></param>
        /// <returns></returns>
        public static string ReadConfig(string xpath)
        {
            string path;
            if (HttpContext.Current != null)
            {
                path = HttpContext.Current.Server.MapPath("~/CustomConfig.config");
            }
            else
            {
                path = AppDomain.CurrentDomain.BaseDirectory + "CustomConfig.config";
            }
            doc.Load(path);

            XmlNode element = doc.SelectSingleNode(xpath.ToString());
            if (element == null)
                throw new Exception("找不到配置节点:" + xpath);
            return element.InnerText;

        }

        #region 节点定义

        /// <summary>
        /// 编号规责
        /// </summary>
        public enum AutoCodeFormat
        {
            /// <summary>
            /// 角色编号规责
            /// </summary>
            [Remark("角色", "customconfig/format/rolecode")]
            RoleCode = 0,
            /// <summary>
            /// 会员编号规责
            /// </summary>
            [Remark("会员编号", "customconfig/format/membercode")]
            MemberCode = 0,
        }

        #endregion
    }
}
