﻿using RFrameGenerate.Common;
using RFrameGenerate.DAL.Enums;
using RFrameGenerate.Model;
using RFramework.SQLServer;
using RFramework.SQLServer.Enums;
using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Text;

namespace RFrameGenerate.BLL
{
    public class CrowdLuckyNumberManage
    {
        public const int begin = 10000000;
        public static Result AddLuckNumber(Guid crowdPeriodGuid, int number, Guid MerchantGuid)
        {

            int[] sequence = new int[number];

            for (int i = 0; i < sequence.Length; i++)
            {
                sequence[i] = begin + i + 1;
            }
            Random random = new Random();
            int end = number - 1;

            using (var sqlRTransaction = new SqlRTransaction())
            {
                DataTable dataListAdd = SqlHelper.GetTables("T_CR_CrowdLuckyNumber", sqlRTransaction);

                for (int i = 1; i <= number; i++)
                {
                    int num = random.Next(0, end + 1);

                    DataRow dr = dataListAdd.NewRow();
                    dr["CrowdLuckyNumberGuid"] = Guid.NewGuid();
                    dr["ProductCrowdPeriodGuid"] = crowdPeriodGuid;
                    dr["ID"] = i;
                    dr["LuckyNumber"] = sequence[num];
                    dr["SCreateDate"] = DateTime.Now;
                    dr["SCreateUserName"] = CurrentManage.UserName;
                    dr["SMerchantGuid"] = MerchantGuid;
                    dr["MerchantGuid"] = MerchantGuid;
                    dataListAdd.Rows.Add(dr);

                    sequence[num] = sequence[end];
                    end--;
                }
                SqlHelper.BatchAddData(new DataTable[] { dataListAdd }, sqlRTransaction);
            }
            return new Result(true);
        }

        public static T_CR_CrowdLuckyNumber GetLuckNumber(Guid crowdPeriodGuid)
        {
            using (var query = Factory.CreateT_CR_CrowdLuckyNumber())
            {
                var model = query.GetFirstData(m => m.ProductCrowdPeriodGuid == crowdPeriodGuid, false, v => v.ID, OrderMethods.ASC, LockType.Default, false);

                return model;
            }
        }

        public static List<T_CR_CrowdLuckyNumber> GetLuckNumberList(Guid crowdPeriodGuid, int number)
        {
            using (var query = Factory.CreateT_CR_CrowdLuckyNumber())
            {
                var list = query.GetTopData(number.ToString(), m => m.ProductCrowdPeriodGuid == crowdPeriodGuid, false, v => v.ID, OrderMethods.ASC, LockType.Default, false);

                return list;
            }
        }

        public static Result DeleteLuckNumber(Guid luckyNumberGuid)
        {
            using (var query = Factory.CreateT_CR_CrowdLuckyNumber())
            {
                query.Delete(m => m.CrowdLuckyNumberGuid == luckyNumberGuid, false);
            }
            return new Result(true);
        }

        public static Result DeleteLuckNumber(List<T_CR_CrowdLuckyNumber> list)
        {
            using (var query = Factory.CreateT_CR_CrowdLuckyNumber())
            {
                //list.ForEach(a => { query.Delete(b => b.CrowdLuckyNumberGuid == a.CrowdLuckyNumberGuid,false); });
                query.DeleteList(list, false);
            }
            return new Result(true);
        }


        public static int GetLuckNumberCount(Guid crowdPeriodGuid)
        {
            using (var query = Factory.CreateT_CR_CrowdLuckyNumber())
            {
                return query.GetCount(a => a.ProductCrowdPeriodGuid == crowdPeriodGuid, false, false);
            }
        }

    }
}
