﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using RFrameGenerate.BLL;
using RFrameGenerate.DAL;
using RFrameGenerate.Model;
using RFramework.SQLQuery;
using RFramework.SQLServer;
using RFrameGenerate.DAL.Enums;
using RFrameGenerate.Common;
using RFrameGenerate.DAL.Interface;
using RFramework.SQLServer.Enums;
using RFramework.SQLQuery.SQLExpands;
using System.Linq.Expressions;

namespace RFrameGenerate.BLL
{
    public class CrowdParticipateManage
    {
        public static Result UpdateStateComplete(Guid crowdPartiGuid)
        {
            using (var query = Factory.CreateT_CR_CrowdParticipate())
            {
                query.Update(a => new object[] { a.CrowdState == DictionaryConst.CrowdState.Complete }, b => b.CrowdParticipateGuid == crowdPartiGuid);
                return new Result(true);
            }
        }
        public static List<T_ST_CrowdParticipateBuyListView> GetCrowdParticipateRecordPageList(GridModel gridModel, int state)//0全部,1进行中,2已揭晓
        {
            List<T_ST_CrowdParticipateBuyListView> list = new List<T_ST_CrowdParticipateBuyListView>();
            List<T_ST_CrowdParticipateBuyListView> listnew = new List<T_ST_CrowdParticipateBuyListView>();
            using (var query = Factory.CreateT_ST_CrowdParticipateBuyListView())
            {
                if (state == 1)
                    list = query.GetPageList(gridModel, a => a.CrowdState > DictionaryConst.CrowdState.DaiFu && a.MemberGuid == RFrameGenerate.Common.CurrentUser.GetCurrUserGuid() && a.OpenDate.SqlIsNull(), false, v => v.OpenDate, OrderMethods.DESC);
                else if (state == 2)
                    list = query.GetPageList(gridModel, a => a.CrowdState > DictionaryConst.CrowdState.DaiFu && a.MemberGuid == RFrameGenerate.Common.CurrentUser.GetCurrUserGuid() && a.OpenDate.SqlIsNotNull(), false, v => v.OpenDate, OrderMethods.DESC);
                else
                    list = query.GetPageList(gridModel, a => a.CrowdState > DictionaryConst.CrowdState.DaiFu && a.MemberGuid == RFrameGenerate.Common.CurrentUser.GetCurrUserGuid(), false, v => v.OpenDate, OrderMethods.DESC);

                foreach (var v in list)
                {
                    var pari = listnew.Where(a => a.ProductCrowdPeriodGuid == v.ProductCrowdPeriodGuid).FirstOrDefault();
                    if (pari == null)
                    {
                        listnew.Add(v);
                    }
                    else
                    {
                        pari.JoinTime += v.JoinTime;
                    }
                }

                return listnew;
            }
        }
        public static List<T_ST_CrowdParticipateListView> GetCrowdParticipatePageList(GridModel gridModel, int state)
        {
            using (var query = Factory.CreateT_ST_CrowdParticipateListView())
            {
                return query.GetPageList(gridModel, a => a.MemberGuid == RFrameGenerate.Common.CurrentUser.GetCurrUserGuid() && a.CrowdState == state);
            }
        }

        public static List<T_ST_CrowdParticipateListView> GetCrowdParticipateAllPageList(GridModel gridModel, int? state)
        {
            using (var query = Factory.CreateT_ST_CrowdParticipateListView())
            {
                if (state == -10)
                    return query.GetPageList(gridModel, a => a.CrowdState == DictionaryConst.CrowdState.DaiFa || a.CrowdState == DictionaryConst.CrowdState.DaiShou || a.CrowdState == DictionaryConst.CrowdState.Complete, true, b => b.OpenDate, OrderMethods.DESC);
                else
                    return query.GetPageList(gridModel, a => a.CrowdState == state, true, b => b.OpenDate, OrderMethods.DESC);
            }
        }
        public static List<T_CR_CrowdParticipate> GetPageList(GridModel gridModel, Guid crowdPeriodGuid)
        {
            List<T_CR_CrowdParticipate> list = null;
            using (var query = Factory.CreateT_CR_CrowdParticipate())
            {
                list = query.GetPageList(gridModel, m => m.CrowdState > -2 && m.ProductCrowdPeriodGuid == crowdPeriodGuid && m.JoinTime > 0, false, v => v.CrowdDate, DAL.Enums.OrderMethods.DESC);
            }
            if (list == null || list.Count <= 0) return new List<T_CR_CrowdParticipate>();

            foreach (var item in list)
            {
                if (item.MemberGuid != null && item.MemberGuid.Value != Guid.Empty)
                {
                    item.Member = MemberManage.GetMemberByGuid(item.MemberGuid.Value); ;
                }

                if (item.Member == null) item.Member = new T_BAS_Member();
            }

            return list;
        }

        public static T_CR_CrowdParticipate GetFirstParticipate(Guid periodGuid)
        {
            using (var query = Factory.CreateT_CR_CrowdParticipate())
            {
                return query.GetFirstData(m => m.ProductCrowdPeriodGuid == periodGuid, false, v => v.CrowdDate, OrderMethods.ASC);
            }
        }

        public static Result Delivery(Guid CrowdWinningGuid, string expressNumber, Guid lc, string company, Guid crowdParticipateGuid)
        {
            try
            {
                using (var tran = new SqlRTransaction())
                {
                    var queryCrowdWinning = Factory.CreateT_CR_CrowdWinning(tran);
                    var win = queryCrowdWinning.GetFirstData(a => a.CrowdWinningGuid == CrowdWinningGuid);
                    if (win != null)
                    {
                        if (win.RecieverAddressGuid != null)
                        {
                            var queryLogist = Factory.CreateT_BAS_Logistics(tran);
                            if (win.LogisticrGuid == null)//还没有发货
                            {
                                var query_recieverAddress = Factory.CreateT_BAS_RecieverAddress(tran);
                                var ra = query_recieverAddress.GetDataByGuid(win.RecieverAddressGuid.Value);

                                var logist = new T_BAS_Logistics()
                                {
                                    LogisticrGuid = Guid.NewGuid(),
                                    DateTime = DateTime.Now,
                                    ExpressNumber = expressNumber,
                                    ExpressCompany = company,

                                    DeliveryMethod = company,
                                    DeliveryMethodGuid = lc,

                                    Consignee = ra.Reciever,
                                    Arear = ra.Area,
                                    Address = ra.Address,
                                    Telephone = ra.Telephone,
                                    Zip = ra.Zip,
                                };

                                tran.BeginTransaction();

                                queryLogist.Add(logist);

                                var querycp = Factory.CreateT_CR_CrowdParticipate(tran);
                                querycp.Update(a => new object[] { a.CrowdState == RFrameGenerate.BLL.DictionaryConst.CrowdState.DaiShou }, b => b.CrowdParticipateGuid == crowdParticipateGuid);

                                queryCrowdWinning.Update(a => new object[] { a.LogisticrGuid == logist.LogisticrGuid, a.DeliveryTime == DateTime.Now }, b => b.CrowdWinningGuid == CrowdWinningGuid);
                                tran.Commit();
                                return new Result(true);
                            }
                            else
                            {
                                queryLogist.Update(a => new object[] 
                                {
                                    a.ExpressNumber == expressNumber,
                                    a.ExpressCompany == company,
                                    a.DeliveryMethod == company,
                                    a.DeliveryMethodGuid == lc, },
                                    b => b.LogisticrGuid == win.LogisticrGuid);
                                return new Result(true);
                            }
                        }
                        else
                        {
                            return new Result(false, "中奖者还没有填写收货地址");
                        }
                    }
                    else
                    {
                        return new Result(false, "出错了");
                    }
                }
            }
            catch (Exception ex)
            {
                return new Result(false, ex.Message);
            }

        }

        public static Result SubmitOrder(List<CrowdProduct> list, out string orderNo, string ip)
        {
            orderNo = "";
            try
            {
                if (list == null)
                    return new Result(false, "商品已过期,请重新下单.");

                using (var tran = new SqlRTransaction())
                {
                    tran.BeginTransaction();
                    var queryproduct = Factory.CreateT_CR_ProductCrowd(tran);
                    var querypeiod = Factory.CreateT_CR_ProductCrowdPeriods(tran);

                    var queryCrowdPart = Factory.CreateT_CR_CrowdParticipate(tran);
                    List<T_CR_CrowdParticipate> addlist = new List<T_CR_CrowdParticipate>();
                    foreach (var v in list)
                    {
                        var lockmoel = CrowdPeriodLock.GetLock(v.ProductCrowdPeriodGuid);
                        lock (lockmoel)
                        {
                            var crowd = queryproduct.GetFirstData(a => a.ProductCrowdGuid == v.ProductCrowdGuid);
                            if (crowd == null)
                            {
                                list.Remove(v);
                                return new Result(false, "众筹商品不存在");
                            }
                            int maxtime = querypeiod.GetCount(a => a.ProductCrowdGuid == v.ProductCrowdGuid);
                            if (maxtime > crowd.MaxPeriod)
                            {
                                list.Remove(v);
                                return new Result(false, "本期已结束");
                            }

                            var peiod = querypeiod.GetFirstData(a => a.ProductCrowdPeriodGuid == v.ProductCrowdPeriodGuid);
                            if (peiod == null || peiod.RemainTime == 0)
                            {
                                list.Remove(v);
                                return new Result(false, "本期已结束");
                            }
                            if (v.MyBuyTime > peiod.RemainTime)
                            {
                                v.RemainTime = peiod.RemainTime.Value;
                                v.MyBuyTime = peiod.RemainTime.Value;
                                v.TotalTime = peiod.TotalTime.Value;
                                return new Result(false, v.ProductName + "本期的剩余人次不足");
                            }

                            string no = CodeManage.GetOrderNO();
                            orderNo += no + "-";
                            addlist.Add(new T_CR_CrowdParticipate()
                            {
                                IP = ip,
                                CrowdParticipateGuid = Guid.NewGuid(),
                                CrowdDate = DateTime.Now,
                                CrowdState = DictionaryConst.CrowdState.DaiFu,
                                JoinTime = v.MyBuyTime,
                                MemberGuid = RFrameGenerate.Common.CurrentUser.GetCurrUserGuid(),
                                OrderNo = no,
                                ProductCrowdPeriodGuid = v.ProductCrowdPeriodGuid,
                                MerchantGuid = CurrentManage.MerchantGuid,
                            });
                        }
                    }
                    queryCrowdPart.AddList(addlist);
                    tran.Commit();
                }
                return new Result(true);
            }
            catch (Exception ex)
            {
                return new Result(false, ex.Message);
            }
        }

        public static decimal GetBuyAmount(string orderNos)
        {
            decimal amount = 0;
            using (var query = Factory.CreateT_CR_CrowdParticipate())
            {
                var orders = orderNos.Split(new string[] { "-" }, StringSplitOptions.RemoveEmptyEntries);
                var list = query.GetList(a => a.CrowdState == DictionaryConst.CrowdState.DaiFu && a.OrderNo.SqlIn(orders), false, null, OrderMethods.Default, RFramework.SQLServer.Enums.LockType.Default, false);
                list.ForEach(a => { amount += a.JoinTime; });
                return amount;
            }
        }

        public static Result CheckBuy(string orderNos)
        {
            Result result = new Result(true);
            using (var tran = new SqlRTransaction())
            {
                var query = Factory.CreateT_CR_CrowdParticipate(tran);
                var queryPeriod = Factory.CreateT_CR_ProductCrowdPeriods(tran);
                var orders = orderNos.Split(new string[] { "-" }, StringSplitOptions.RemoveEmptyEntries);
                var list = query.GetList(a => a.CrowdState == DictionaryConst.CrowdState.DaiFu && a.OrderNo.SqlIn(orders), false, null, OrderMethods.Default, RFramework.SQLServer.Enums.LockType.Default, false);
                string msg = string.Empty;
                list.ForEach(b =>
                {
                    var period = queryPeriod.GetFirstData(a => a.ProductCrowdPeriodGuid == b.ProductCrowdPeriodGuid);
                    var lockmoel = CrowdPeriodLock.GetLock(period.ProductCrowdPeriodGuid);
                    lock (lockmoel)
                    {
                        if (b.JoinTime > period.RemainTime)
                        {
                            result.State = false;
                            result.Msg += string.Format("本期剩下次数不足,请重新下单.");
                            return;
                        }
                    }
                });
            }
            return result;
        }
        
        /// <summary>
        /// 支付完成后处理订单状态
        /// </summary>
        /// <param name="orderNO">订单编号</param>
        /// <param name="total">金额(单位分)</param>
        /// <returns></returns>
        public static Result PaySuccess(string orderNO, string total, string appid, string openid, string transaction_id)
        {
            try
            {
                //未记录失败情况
                decimal totalAmount = decimal.Parse(total) / 100;//实际支付
                if (totalAmount <= 0)
                    return new Result(false, "支付金额不能小于或等于0");

                var amount = CrowdParticipateManage.GetBuyAmount(orderNO);

                if (CurrentManage.Domain.Contains("jioukeji.com") != true)
                {
                    if (amount != totalAmount)
                        return new Result(false, "支付金额不等于微信回调的金额");
                }
                var orders = orderNO.Split(new string[] { "-" }, StringSplitOptions.RemoveEmptyEntries);

                foreach (var order in orders)
                {
                    using (var tran = new SqlRTransaction())
                    {
                        var query = Factory.CreateT_CR_CrowdParticipate(tran);
                        var queryDetail = Factory.CreateT_CR_CrowdParticipateDetails(tran);
                        var queryPeriod = Factory.CreateT_CR_ProductCrowdPeriods(tran);

                        var jointime = 0;
                        var BuyMsg = string.Empty;

                        var orderdb = query.GetFirstData(a => a.OrderNo == order, false, null, OrderMethods.Default, RFramework.SQLServer.Enums.LockType.Default, false);
                        if (orderdb.CrowdState != DictionaryConst.CrowdState.DaiFu)//付过款了
                            return new Result(true);

                        if (CurrentManage.MerchantGuid == Guid.Empty)
                        {//模拟登录
                            CurrentUser.SetMerchantGuid(orderdb.MerchantGuid.Value);
                            CurrentUser.SetSMerchantGuid(orderdb.MerchantGuid.Value);
                            CurrentUser.SetCurrUser("一元购", orderdb.MerchantGuid.Value);
                        }

                        var luckynum = string.Empty;
                        var lockmoel = CrowdPeriodLock.GetLock(orderdb.ProductCrowdPeriodGuid.Value);
                        lock (lockmoel)
                        {
                            tran.BeginTransaction();
                            orderdb = query.GetFirstData(a => a.OrderNo == order, false, null, OrderMethods.Default, RFramework.SQLServer.Enums.LockType.Default, false);
                            if (orderdb.CrowdState != DictionaryConst.CrowdState.DaiFu)//付过款了
                                return new Result(true);

                            var period = queryPeriod.GetFirstData(a => a.ProductCrowdPeriodGuid == orderdb.ProductCrowdPeriodGuid, false, null, OrderMethods.Default, RFramework.SQLServer.Enums.LockType.Default, false);
                            if (period.RemainTime > 0)
                            {
                                //分配幸运号
                                var count = CrowdLuckyNumberManage.GetLuckNumberCount(orderdb.ProductCrowdPeriodGuid.Value);
                                #region 购买的小于或等于库存的
                                if (orderdb.JoinTime <= count)
                                {
                                    BuyMsg = "购买成功,幸运号:";
                                    var listNumber = CrowdLuckyNumberManage.GetLuckNumberList(orderdb.ProductCrowdPeriodGuid.Value, orderdb.JoinTime);
                                    int i = 0;
                                    foreach (var v in listNumber)
                                    {
                                        queryDetail.Add(new T_CR_CrowdParticipateDetails()
                                        {
                                            CrowdParticipateDetailsGuid = Guid.NewGuid(),
                                            CrowdParticipateGuid = orderdb.CrowdParticipateGuid,
                                            LuckyNum = v.LuckyNumber.ToString(),
                                            ProductCrowdPeriodGuid = period.ProductCrowdPeriodGuid,
                                        });
                                        i++;
                                        if (i <= 2)
                                        {
                                            luckynum += v.LuckyNumber + ",";
                                            BuyMsg += +v.LuckyNumber + ",";
                                        }
                                    }
                                    //删除已用号码
                                    CrowdLuckyNumberManage.DeleteLuckNumber(listNumber);
                                    jointime = orderdb.JoinTime;
                                }
                                #endregion
                                #region 不够次数,应该把多于的次数转为金额转到会员表
                                else
                                {
                                    //差价
                                    decimal spread = orderdb.JoinTime - count;
                                    if (count > 0)//部分购买
                                    {
                                        BuyMsg = "购买成功,幸运号:";
                                        var listNumber = CrowdLuckyNumberManage.GetLuckNumberList(orderdb.ProductCrowdPeriodGuid.Value, count);
                                        int i = 0;
                                        foreach (var v in listNumber)
                                        {
                                            queryDetail.Add(new T_CR_CrowdParticipateDetails()
                                            {
                                                CrowdParticipateDetailsGuid = Guid.NewGuid(),
                                                CrowdParticipateGuid = orderdb.CrowdParticipateGuid,
                                                LuckyNum = v.LuckyNumber.ToString(),
                                                ProductCrowdPeriodGuid = period.ProductCrowdPeriodGuid,
                                            });

                                            i++;
                                            if (i <= 2)
                                            {
                                                luckynum += v.LuckyNumber + ",";
                                                BuyMsg += +v.LuckyNumber + ",";
                                            }
                                        }
                                        BuyMsg += spread + "元已转到余额";
                                        //删除已用号码
                                        CrowdLuckyNumberManage.DeleteLuckNumber(listNumber);
                                        jointime = count;
                                    }
                                    else//购买失败
                                    {
                                        BuyMsg = "购买失败," + orderdb.JoinTime + "元已转到可用余额[0]";
                                        jointime = 0;
                                    }
                                    //被差价到会员表可用余额
                                    UpdateMember(tran, orderdb, spread);
                                }
                                #endregion
                            }
                            else
                            {
                                BuyMsg = "购买失败," + orderdb.JoinTime + "元已转到可用余额[1]";
                                jointime = 0;
                                //差价到会员表可用余额
                                UpdateMember(tran, orderdb, orderdb.JoinTime);
                            }

                            //更新订单表
                            query.Update(a => new object[] { a.PayNO == transaction_id, a.CrowdState == DictionaryConst.CrowdState.YiFu, a.BuyMsg == BuyMsg, a.AllLuckyNum == luckynum, a.JoinTime == jointime }, b => b.OrderNo == order, false);

                            #region 更新期数表
                            var remaintime = period.RemainTime.Value - jointime;
                            if (remaintime < 0)
                                remaintime = 0;

                            var buytime = period.BuyTime.Value + jointime;
                            if (buytime > period.TotalTime.Value)
                                buytime = period.TotalTime.Value;


                            decimal numbera = 0;
                            if (remaintime == 0)
                            {
                                var listOrder = query.GetTopData("50", null, false, b => b.CrowdDate, OrderMethods.DESC, LockType.Default, false);
                                listOrder.ForEach(a =>
                                {
                                    numbera += long.Parse(a.CrowdDate.ToString("yyMMmmHHmmss"));
                                });
                            }

                            string periodnum = string.Empty;
                            int num = 0;
                            var queryLotter = Factory.CreateT_CR_LotteryResult(tran);
                            var lotter = queryLotter.GetFirstData(null, false, b => b.AwardsTime, OrderMethods.DESC, LockType.Default, false);
                            if (lotter != null)
                            {
                                periodnum = lotter.AwardsPeriod.Substring(0, 8);
                                num = int.Parse(lotter.AwardsPeriod.Substring(8));

                                if (num == 120)
                                {
                                    periodnum = DateTime.Now.ToString("yyyyMMdd") + "001";
                                }
                                else
                                {
                                    periodnum += string.Format("{0:D3}", (num + 1));
                                }
                            }
                            else
                            {
                                periodnum = DateTime.Now.ToString("yyyyMMdd") + "001";
                            }
                            queryPeriod.Update(a => new object[] { a.RemainTime == remaintime, a.BuyTime == buytime, a.NumberA == numbera, a.PeriodNum == periodnum }, b => b.ProductCrowdPeriodGuid == period.ProductCrowdPeriodGuid, false);


                            if (remaintime == 0)
                            {
                                //添加到奖中
                                LotteryManage.AddPeriodLotter(period.ProductCrowdPeriodGuid);

                                var querycrowd = Factory.CreateT_CR_ProductCrowd(tran);
                                var crowd = querycrowd.GetDataByGuid(period.ProductCrowdGuid.Value, false);
                                ProductCrowdManage.AddPeri(crowd, tran);
                                CrowdPeriodLock.SetLock(period.ProductCrowdGuid.Value, false);
                            }

                            #endregion
                            tran.Commit();
                        }
                    }
                }
                return new Result(true);
            }
            catch (Exception ex)
            {
                using (var tran = new SqlRTransaction())
                {
                    var query = Factory.CreateT_CR_CrowdParticipate(tran);
                    var orders = orderNO.Split(new string[] { "-" }, StringSplitOptions.RemoveEmptyEntries);
                    tran.BeginTransaction();
                    foreach (var order in orders)
                    {
                        var orderdb = query.GetFirstData(a => a.OrderNo == order, false, null, OrderMethods.Default, RFramework.SQLServer.Enums.LockType.Default, false);

                        UpdateMember(tran, orderdb, orderdb.JoinTime);
                    }
                    tran.Commit();
                }
                return new Result(true);
            }
        }
        /// <summary>
        /// 差价到会员表可用余额
        /// </summary>
        static void UpdateMember(SqlRTransaction tran, T_CR_CrowdParticipate orderdb, decimal spread)
        {
            //被差价到会员表可用余额
            var queryMember = Factory.CreateT_BAS_Member(tran);
            var memeber = queryMember.GetDataByGuid(orderdb.MemberGuid.Value, false);

            decimal amount = memeber.Amount + spread;
            decimal balance = memeber.Balance + spread;
            queryMember.Update(a => new object[] { a.Amount == amount, a.Balance == balance }, b => b.MemberGuid == memeber.MemberGuid, false);

            Wechat.LogManage.Log("一元购支付后逻辑处理失败,余额(" + spread + ")转至可用余额");
        }

        static void LuckyNumy(T_CR_CrowdParticipate orderdb, IQuery<T_CR_CrowdParticipateDetails> queryOrder, SqlRTransaction tran)
        {

        }

        public static PT_BAS_PayWayByOrderNo GetPayWayByOrderNO(string orderNOs)
        {
            using (var query = Factory.CreateProcedure())
            {
                var orders = orderNOs.Split(new string[] { "-" }, StringSplitOptions.RemoveEmptyEntries);
                return query.GetPayWayByCrowdOrderNO(orders[0]);
            }
        }
        public static Result UpdatePayWay(string orderNos)
        {
            try
            {
                using (var tran = new SqlRTransaction())
                {
                    var query = Factory.CreateT_CR_CrowdParticipate(tran);
                    var queryMerchantPay = Factory.CreateT_BAS_MerchantsPayWay(tran);
                    var payway = queryMerchantPay.GetFirstData(a => a.MerchantGuid == RFrameGenerate.Common.CurrentManage.MerchantGuid);
                    if (payway == null)
                        return new Result(false, "支付失败,商家未配置微信支付,请联系商家!");

                    var orders = orderNos.Split(new string[] { "-" }, StringSplitOptions.RemoveEmptyEntries);
                    foreach (var o in orders)
                    {
                        query.Update(a => new object[] { a.MerchantPayWayGuid == payway.MerchantPayWayGuid }, b => b.OrderNo == o);
                    }
                }
                return new Result(true);
            }
            catch (Exception ex)
            {
                return new Result(false, ex.Message);
            }
        }

        public static string GetOpenID(string orderNos)
        {
            using (var tran = new SqlRTransaction())
            {
                var query = Factory.CreateT_CR_CrowdParticipate(tran);
                var orders = orderNos.Split(new string[] { "-" }, StringSplitOptions.RemoveEmptyEntries);
                string no = orders.Length > 0 ? orders[0] : string.Empty;
                var order = query.GetFirstData(a => a.CrowdState == DictionaryConst.CrowdState.DaiFu && a.OrderNo == no);
                if (orders != null)
                {
                    var queryMer = Factory.CreateT_BAS_Member(tran);
                    var member = queryMer.GetFirstData(a => a.MemberGuid == order.MemberGuid);
                    if (member != null)
                        return member.MemberOpenID;
                }
                return string.Empty;
            }
        }

        public static List<T> GetMyLuckyNums<T>(Guid productCrowdPeriodGuid, Expression<Func<T_CR_CrowdParticipate, T_CR_CrowdParticipateDetails, T>> selectorfield)
        {
            using (var sql = new SqlModel<T_CR_CrowdParticipate, T_CR_CrowdParticipateDetails>())
            {
                return sql.SqlSelect(selectorfield)
                          .SqlJionInner((a, b) => b)
                          .SqlOn((a, b) => a.CrowdParticipateGuid == b.CrowdParticipateGuid)
                          .SqlWhere((a, b) => a.MemberGuid == CurrentUser.GetCurrUserGuid() && a.ProductCrowdPeriodGuid == productCrowdPeriodGuid)
                          .ToList();
            }
        }
    }
}
