﻿using RFrameGenerate.DAL.Enums;
using RFrameGenerate.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace RFrameGenerate.BLL
{
    public class CrowdWinningManage
    {
        public static T_ST_CrowdParticipateListView GetWinningEntity(Guid winningGuid)
        {
            using (var query = Factory.CreateT_ST_CrowdParticipateListView())
            {
                return query.GetFirstData(m=>m.CrowdWinningGuid == winningGuid);
            }
        }

        public static T_CR_CrowdWinning GetEntity(Guid winningGuid)
        {
            using (var query = Factory.CreateT_CR_CrowdWinning())
            {
                return query.GetFirstData(m=>m.CrowdWinningGuid == winningGuid);
            }
        }


        public static string GetLotteryName(Guid perid)
        {
            using (var tran = new RFramework.SQLServer.SqlRTransaction())
            {
                var query = Factory.CreateT_CR_CrowdWinning(tran);
                var model = query.GetFirstData(a => a.ProductCrowdPeriodGuid == perid,false,null,OrderMethods.Default);
                if (model != null)
                {
                    var queryMem = Factory.CreateT_BAS_Member(tran);
                    var mem = queryMem.GetFirstData(a => a.MemberGuid == model.MemberGuid);
                    return mem.MemberNickName;
                }
                else
                {
                    return "获取中...";
                }
            }
        }
    }
}
