﻿using RFrameGenerate.DAL.Enums;
using RFrameGenerate.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using RFramework.SQLQuery;

namespace RFrameGenerate.BLL
{
    public class ProductCrowdPeriodsManage
    {
        public static List<T_CR_ProductCrowdPeriods> GetHotProducts()
        {
            using (var query = Factory.CreateT_CR_ProductCrowdPeriods())
            {
                return query.GetTopData("4", a => a.MerchantGuid==RFrameGenerate.Common.CurrentManage.MerchantGuid && a.RemainTime > 0, false, b => b.CrowdPeriods, OrderMethods.DESC);
            }
        }


        public static List<T_CR_ProductCrowdPeriods> GetTop3Lottery()
        {
            using (var query = Factory.CreateT_CR_ProductCrowdPeriods())
            {
                var list = query.GetTopData("3", a => a.RemainTime == 0 && a.OpenDate.SqlIsNull());
                if (list.Count == 2)
                {
                    list.Add(new T_CR_ProductCrowdPeriods() { ProductCrowdPeriodGuid = Guid.Empty });
                }
                else if (list.Count == 1)
                {
                    list.Add(new T_CR_ProductCrowdPeriods() { ProductCrowdPeriodGuid = Guid.Empty });
                    list.Add(new T_CR_ProductCrowdPeriods() { ProductCrowdPeriodGuid = Guid.Empty });
                }
                else if (list.Count == 0)
                {
                    list.Add(new T_CR_ProductCrowdPeriods() { ProductCrowdPeriodGuid = Guid.Empty });
                    list.Add(new T_CR_ProductCrowdPeriods() { ProductCrowdPeriodGuid = Guid.Empty });
                    list.Add(new T_CR_ProductCrowdPeriods() { ProductCrowdPeriodGuid = Guid.Empty });
                }
                return list;
            }
        }

        public static List<T_CR_ProductCrowdPeriods> GetPageList(GridModel gridModel)
        {
            if (gridModel == null) gridModel = new GridModel();

            if (gridModel.page == 0) gridModel.page = 1;

            if (gridModel.rows == 0) gridModel.rows = 6;

            using (var query = Factory.CreateT_CR_ProductCrowdPeriods())
            {
                return query.GetPageList(gridModel, a => a.MerchantGuid==RFrameGenerate.Common.CurrentManage.MerchantGuid && a.RemainTime > 0, false, m => m.JoinDate, OrderMethods.DESC);
            }
        }

        public static T_CR_ProductCrowdPeriods GetEntity(Guid crowdPeriodsGuid)
        {
            using (var query = Factory.CreateT_CR_ProductCrowdPeriods())
            {
                return query.GetDataByGuid(crowdPeriodsGuid, false);
            }
        }

        public static T_CR_ProductCrowdPeriods GetEntityByCrowdGuid(Guid crowdGuid)
        {
            using (var query = Factory.CreateT_CR_ProductCrowdPeriods())
            {
                return query.GetFirstData(m => m.ProductCrowdGuid == crowdGuid && m.RemainTime > 0, false, null, OrderMethods.DESC);
            }
        }
    }
}
