﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using RFrameGenerate.Model;
using RFrameGenerate.Common;
using RFramework.SQLServer;

namespace RFrameGenerate.BLL
{
    public class CustomerServiceManage
    {
        public static T_BAS_CustomerServices GetCustomerService(Guid? customerServiceGuid)
        {
            if (customerServiceGuid == null) return new T_BAS_CustomerServices();
            using (var query = Factory.CreateT_BAS_CustomerServices())
            {
                return query.GetFirstData(a => a.CustomerServicesGuid == customerServiceGuid);
            }
        }
        //开通客户并启用客户功能
        public static Result Apply(bool enable)
        {
            try
            {
                using (var tran = new SqlRTransaction())
                {
                    var query = Factory.CreateT_BAS_CustomerServices(tran);
                    var queryMer = Factory.CreateT_BAS_Merchants(tran);
                    var mer = queryMer.GetFirstData(a => a.MerchantGuid == RFrameGenerate.Common.CurrentManage.MerchantGuid);

                    if (mer.CustomerServicesGuid == null)
                    {
                        T_BAS_CustomerServices cs = new T_BAS_CustomerServices()
                        {
                            CustomerServicesGuid = Guid.NewGuid(),
                            compAddr = mer.Address.ToString(),
                            company = mer.StoreTitle,
                            linkman = mer.Contact,
                            mobile = mer.Telephone,
                            password = "123456",
                            email = mer.EMail,
                            phone = mer.CustomerTelephone,
                            username = mer.UserID,
                            industryCategory = "互联网",
                        };
                        cs.keynumber = cs.CustomerServicesGuid.ToString();

                        KuaiShangRequest request = cs.ToEntity<KuaiShangRequest>();
                        var response = request.Request();
                        cs.keytype = request.keytype;
                        cs.success = response.success;
                        cs.msg = response.msg + response.param;
                        cs.code = response.code;
                        cs.defaultusername = response.username;
                        cs.compId = response.compId;
                        cs.weburl = request.weburl;
                        tran.BeginTransaction();
                        query.Add(cs);
                        queryMer.Update(a => new object[] { a.IsCustomerServices == response.success, a.CustomerServicesGuid == cs.CustomerServicesGuid }, b => b.MerchantGuid == CurrentManage.MerchantGuid);
                        tran.Commit();

                        if (response.success == true)
                            return new Result(true, response.msg);
                        else
                        {
                            Wechat.LogManage.Log("开通快商通失败:" + response.param);
                            return new Result(false, response.msg);
                        }

                    }
                    else
                    {
                        var cs = query.GetFirstData(a => a.CustomerServicesGuid == mer.CustomerServicesGuid);
                        if (cs.success == false)
                        {
                            T_BAS_CustomerServices cs1 = new T_BAS_CustomerServices()
                            {
                                CustomerServicesGuid = Guid.NewGuid(),
                                keynumber = CurrentManage.MerchantGuid.ToString(),
                                compAddr = mer.Address.ToString(),
                                company = mer.StoreTitle,
                                linkman = mer.Contact,
                                mobile = mer.Telephone,
                                password = "123456",
                                email = mer.EMail,
                                phone = mer.CustomerTelephone,
                                username = mer.UserID,
                                industryCategory = "互联网",
                            };
                            cs1.keynumber = cs1.CustomerServicesGuid.ToString();

                            KuaiShangRequest request = cs1.ToEntity<KuaiShangRequest>();
                            var response = request.Request();
                            cs1.keytype = request.keytype;
                            cs1.success = response.success;
                            cs1.msg = response.msg + response.param;
                            cs1.code = response.code;
                            cs1.defaultusername = response.username;
                            cs1.compId = response.compId;
                            cs1.weburl = request.weburl;

                            tran.BeginTransaction();
                            query.Delete(a => a.CustomerServicesGuid == mer.CustomerServicesGuid);
                            query.Add(cs1);
                            queryMer.Update(a => new object[] { a.IsCustomerServices == response.success, a.CustomerServicesGuid == cs1.CustomerServicesGuid }, b => b.MerchantGuid == CurrentManage.MerchantGuid);
                            tran.Commit();

                            if (response.success == true)
                            {
                                return new Result(true, response.msg);
                            }
                            else
                            {
                                Wechat.LogManage.Log("开通快商通失败:" + response.param);
                                return new Result(false, response.msg);
                            }
                        }
                        else
                        {
                            queryMer.Update(a => new object[] { a.IsCustomerServices == enable }, b => b.MerchantGuid == CurrentManage.MerchantGuid);
                            return new Result(true);
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                return new Result(false, ex.Message);
            }
        }
    }
}
