﻿using RFrameGenerate.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using RFramework.SQLQuery;

namespace RFrameGenerate.BLL.DIVShop
{
    public class AttributeDataManage
    {
        #region 数据读取

        public static List<T_WP_AttributeData> GetAttributes(List<T_WP_WinportMain> list)
        {
            if (list == null || list.Count <= 0) return new List<T_WP_AttributeData>(0);

            var pageGuid = list.First().WinportPageGuid;

            var array = list.Select(m => m.WinportMainGuid).ToArray();

            return GetAttributes(pageGuid, array);
        }

        public static List<T_WP_AttributeData> GetAttributes(Guid pageGuid, Guid[] components)
        {
            var list = PageCacheManage.GetCacheAttributes(pageGuid);

            if (list != null && list.Count > 0) return list;

            using (var query = Factory.CreateT_WP_AttributeData())
            {
                list =  query.GetList(m => m.WinportMainGuid.SqlIn(components));
            }
            PageCacheManage.SetCacheAttributes(pageGuid, list);

            return list;
        }

        #endregion
    }
}
