﻿using RFrameGenerate.Common;
using RFrameGenerate.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;
using System.Web.Caching;

namespace RFrameGenerate.BLL.DIVShop
{
    public class PageCacheManage
    {
        /// <summary>
        /// 获取缓存页面
        /// </summary>        
        internal static T_WP_WinportPage GetCachePage()
        {
            return Get<T_WP_WinportPage>(CurrentPageKey());
        }

        /// <summary>
        /// 设置缓存页面
        /// </summary>    
        internal static void SetCachePage(T_WP_WinportPage page)
        {
            Insert(CurrentPageKey(), page, 3);
        }

        /// <summary>
        /// 获取缓存组件
        /// </summary>
        internal static List<T_WP_WinportMain> GetCacheComponents(Guid pageGuid)
        {
            return Get<List<T_WP_WinportMain>>(CurrentComponents(pageGuid));
        }

        /// <summary>
        /// 设置缓存组件
        /// </summary>    
        internal static void SetCacheComponents(Guid pageGuid, List<T_WP_WinportMain> components)
        {
            Insert(CurrentComponents(pageGuid), components, 3);
        }

        /// <summary>
        /// 获取缓存参数属性
        /// </summary>
        internal static List<T_WP_AttributeData> GetCacheAttributes(Guid pageGuid)
        {
            return Get<List<T_WP_AttributeData>>(CurrentAttributes(pageGuid));
        }

        /// <summary>
        /// 设置缓存参数属性
        /// </summary>    
        internal static void SetCacheAttributes(Guid pageGuid, List<T_WP_AttributeData> attributes)
        {
            Insert(CurrentAttributes(pageGuid), attributes, 3);
        }

        /// <summary>
        /// 清除缓存
        /// </summary>
        internal static void RemoveCache(Guid pageGuid)
        {
            HttpContext.Current.Cache.Remove(CurrentPageKey());

            HttpContext.Current.Cache.Remove(CurrentComponents(pageGuid));

            HttpContext.Current.Cache.Remove(CurrentAttributes(pageGuid));
        }

        #region 私有辅助函数

        /// <summary>
        /// 当前页面key
        /// </summary>
        private static string CurrentPageKey()
        {
            return string.Format("current_page_{0}", CurrentManage.MerchantGuid);
        }
        /// <summary>
        /// 当前组件key
        /// </summary>
        private static string CurrentComponents(Guid pageGuid)
        {
            return string.Format("current_components_{0}", pageGuid);
        }
        /// <summary>
        /// 当前属性参数key
        /// </summary>
        private static string CurrentAttributes(Guid pageGuid)
        {
            return string.Format("current_attributes_{0}", pageGuid);
        }

         /// <summary>
        /// 获取缓存对象
        /// </summary>
        private static T Get<T>(string key)
        {
            if (string.IsNullOrEmpty(key))
            {
                return default(T);
            }
            var obj = HttpContext.Current.Cache.Get(key);

            return obj == null ? default(T) : (T)obj;
        }

        /// <summary>
        /// 插入缓存
        /// </summary>
        private static void Insert(string key, object value, int expires)
        {
            if (value == null) return;

            HttpContext.Current.Cache.Insert(key, value, null, Cache.NoAbsoluteExpiration, new TimeSpan(0, expires, 0));
        }

        #endregion
    }
}
