﻿using RFrameGenerate.Common;
using RFrameGenerate.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;

namespace RFrameGenerate.BLL.DIVShop
{
    public class WinportPageManage
    {
        #region 数据读取

        public static List<T_WP_WinportPage> GetPageList(GridModel gridModel)
        {
            using (var query = Factory.CreateT_WP_WinportPage())
            {
                return query.GetPageList(gridModel);
            }
        }

        public static T_WP_WinportPage GetPage(Guid pageGuid)
        {
            using (var query = Factory.CreateT_WP_WinportPage())
            {
                return query.GetFirstData(m => m.MerchantGuid == CurrentManage.MerchantGuid && m.WinportPageGuid == pageGuid);
            }
        }

        #endregion

        #region 逻辑处理

        /// <summary>
        /// 启用页面
        /// </summary>        
        public static Result EnablePage(Guid pageGuid)
        {
            if (pageGuid == Guid.Empty) return new Result(false, "启用页面不能为空！");

            using (var query = Factory.CreateT_WP_WinportPage())
            {
                query.Update(m => new object[] 
                {
                    m.State == 0,
                    m.LastAlertTime == DateTime.Now
                },
                v => v.State == 1 && v.MerchantGuid == CurrentManage.MerchantGuid);

                query.Update(m => new object[] 
                {
                    m.State == 1,
                    m.LastAlertTime == DateTime.Now
                },
                  v => v.MerchantGuid == CurrentManage.MerchantGuid && v.WinportPageGuid == pageGuid);
            }
            PageCacheManage.RemoveCache(pageGuid);
            return new Result(true);
        }

        /// <summary>
        /// 关闭页面
        /// </summary>
        public static Result DisablePage(Guid pageGuid)
        {
            if (pageGuid == Guid.Empty) return new Result(false, "启用页面不能为空！");

            using (var query = Factory.CreateT_WP_WinportPage())
            {
                query.Update(m => new object[] 
                {
                    m.State == 0,
                    m.LastAlertTime == DateTime.Now
                },
                  v => v.MerchantGuid == CurrentManage.MerchantGuid && v.WinportPageGuid == pageGuid);
            }
            PageCacheManage.RemoveCache(pageGuid);

            return new Result(true);
        }

        /// <summary>
        /// 获取当前页面
        /// </summary>
        public static T_WP_WinportPage CurrentPage()
        {
            var page = PageCacheManage.GetCachePage();

            if (page != null && page.WinportPageGuid == Guid.Empty) return null;

            if (page != null && page.WinportPageGuid != Guid.Empty) return page;
           
            using (var query = Factory.CreateT_WP_WinportPage())
            {
                page = query.GetFirstData(m => m.State == 1 && m.MerchantGuid == CurrentManage.MerchantGuid);
            }
            if (page == null) page = new T_WP_WinportPage();

            PageCacheManage.SetCachePage(page);

            return page;
        }

        #endregion
    }
}
