﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Collections;
using RFrameGenerate.Model;
using RFrameGenerate.DAL;
using RFrameGenerate.DAL.Interface;
using RFrameGenerate.DAL.SQLServer;
using RFramework.SQLServer;
using RFramework.SQLQuery;
using RFramework;
using RFrameGenerate.Common;

namespace RFrameGenerate.BLL
{
    public class TestBLL
    {
        class StudentsA : Students
        {
            public string Desc { get; set; }
        }

        class StudentsB : EntityBase<StudentsB>
        {
            public Guid StudentGuid { get; set; }
            public string Name { get; set; }
            public int? Age { get; set; }

            protected override StudentsB CurrentEntity()
            {
                return this;
            }
        }
        public TestBLL()
        {
            return;
            var test = Factory.CreateStudents();
            var list1 = test.GetList(a => a.Name.SqlFunc("name='value1'"));


            CurrentUser.SetCurrUser("周先群", Guid.NewGuid());
            var v = Factory.CreateCourses();

            /*----------------------------------------------------------------------- 系统参数
            //系统参数
            string parameterName = ParameterMagage.ParameterName;
            
            //参数
            ParameterMagage parameter = ParameterMagage.Current;
            //获取参数,结果为string
            string para = parameter.GetParameter<string>(ParameterName.TestParameterName);
            //修改参数
            parameter.UpdateParameter(ParameterName.TestParameterName, 66);//值为泛型
            parameter.Save();
            //获取参数,结果为int
            int para2 = parameter.GetParameter<int>(ParameterName.TestParameterName);*/



            /*----------------------------------------------------------------------- 复制功能*/          
            //复制功能
            Students student0 = new Students()
            {
                StudentGuid = Guid.NewGuid(),
                Name = "我是数据库里的数据,age=24",
                Address = "广州市天河区",
                Age = 24,
            };
            StudentsB studentB = new StudentsB()
            {
                StudentGuid = Guid.NewGuid(),
                Name = "我是网页上的数据age=10",
                Age = 10,
            };
            //Students 类型转为StudentsA类型
            StudentsA studentA = student0.EntityConvert<StudentsA>();

            //一个实体中的数据更新到另一个实体中
            studentB = student0.UpdateToEntity(studentB);

            //一个实体中的数据更新到另一个实体中
            student0 = studentB.UpdateToEntity(student0);

            //对象复制
            Students student2 = student0.Clone() as Students;
            student2.Name = "不要问我是谁";

            /*-----------------------------------------------------------------------批量操作数据*/
            //批量操作数据
            List<Students> listData = new List<Students>();
            for (int i = 1; i <= 100; i++)
            {
                listData.Add(new Students()
                {
                    StudentGuid = Guid.NewGuid(),
                    Name = "周先群" + i.ToString(),
                    Address = "广州市天河区建中路" + i.ToString(),
                    Age = 24,
                    EntityState = EntityStates.ToBeAdd
                });
            }

            using (IQuery<Students> query = Factory.CreateStudents())
            {
                //lambda操作
                query.GetList(a => a.Name.SqlIn("zhouliuyi", "zhouxianqun"));
                
                //批量添加
                query.UpdateList(listData);

                //批量删除
                listData.ForEach(a => a.EntityState = EntityStates.ToBeDelete);
                query.UpdateList(listData);
            }
            /*-----------------------------------------------------------------------无事务的dal*/

            //无事务
            using (IQuery<Students> query = Factory.CreateStudents())
            {
                Students student1 = new Students()
                {
                    StudentGuid = Guid.NewGuid(),
                    Name = "周先群",
                    Address = "广州市天河区",
                    Age = 24,
                }; 
                //添加数据
                query.Add(student1);
                //更新数据
                student1.Address = "广州市天河区建中路5号海天楼";
                query.Update(student1);
                //判断是否存在
                bool exit = query.IsExist(student1.StudentGuid);
                //根据条件获取数据的总数
                int count = query.GetCount(a => a.StudentGuid == student1.StudentGuid);
                count = query.GetCount();
                //根据条件获取第一条数据
                var firstdata = query.GetFirstData(a => a.StudentGuid == student1.StudentGuid);
                //根据guid获取数据
                var data = query.GetDataByGuid(student1.StudentGuid);
                //获取所有数据
                var list = query.GetList();
                list = query.GetList(a => a.StudentGuid == student1.StudentGuid);

                //获取分页数据
                int pageCount, recordCount;
                var pagedate = query.GetPageList(1, 5, out pageCount, out recordCount,"");
                pagedate = query.GetPageList(1, 5, out pageCount, out recordCount, a => a.StudentGuid == student1.StudentGuid);
                //删除数据
                query.Delete(student1.StudentGuid);
                exit = query.IsExist(student1.StudentGuid);
            }
            /*-----------------------------------------------------------------------有事务的事务操作*/
            //事务
            using (SqlRTransaction tran = new SqlRTransaction())
            {
                IQuery<Students> queryStudents = Factory.CreateStudents(tran);
                IQuery<Courses> queryCourses = Factory.CreateCourses(tran);
                Students student = new Students()
                {
                    StudentGuid = Guid.NewGuid(),
                    Name = "周先群",
                    Address = "广州市天河区",
                    Age = 24,
                };
                Courses courses = new Courses()
                {
                    CoursesGuid = Guid.NewGuid(),
                    Subject = "数据",
                    Grade = 100
                };

                //? 开始事务
                tran.BeginTransaction();

                //添加数据
                queryStudents.Add(student);
                //更新数据
                student.Address = "广州市天河区建中路5号海天楼";
                queryStudents.Update(student);
                //删除数据
                //queryStudents.Delete(student.StudentGuid);


                //添加数据
                queryCourses.Add(courses);
                //更新数据
                courses.Grade = 99;
                queryCourses.Update(courses);


                //删除数据
                //queryCourses.Delete(courses.CoursesGuid);

                //? 提交事务
                tran.Commit();
            }
            /*-----------------------------------------------------------------------*/
            //自定义存储过程,
            //1.在\Trunk\Database\CustomizeProcedure.sql 添加相应的存储过程
            //2.使用步骤RFrameGenerate.DAL->DataBase->SQLServer->Procedure->IProcedure 添加相应的方法,
            //
            using (var iqeruy = Factory.CreateProcedure())
            {
                var re = iqeruy.GetPDemoList();

                var re1 = iqeruy.GetPDemoList(a => a.ParameterValue == "61");

                

            }
        }
    }
}
