﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace RFrameGenerate.BLL
{
    public class DictionaryConst
    {
        public class UserState
        {
            /// <summary>
            ///  用户状态：正常
            /// </summary>
            public const int Normal = 0;
            /// <summary>
            /// 用户状态：暂停
            /// </summary>
            public const int Pause = 1;
        }
        public class Sex
        {
            /// <summary>
            /// 男
            /// </summary>
            public const string Man = "1";
            /// <summary>
            /// 女
            /// </summary>
            public const string WoMan = "0";
        }
        public class PermissionType
        {
            /// <summary>
            /// 页面权限
            /// </summary>
            public const int Page = 1;
            /// <summary>
            /// 操作权限
            /// </summary>
            public const int Operate = 2;
        }
        public class UpLoadPath
        {
            /// <summary>
            /// 商品管理
            /// </summary>
            public const string ProductsImagePath = "/upload/products";

            public const string MaterialImagePath = "/upload/material";

            public const string DeliveryPath = "/upload/delivery";
            /// <summary>
            /// 店铺Logo
            /// </summary>
            public const string StoreLogoPath = "/upload/storelogo";
            /// <summary>
            /// 评价图片
            /// </summary>
            public const string CommentsImg = "/upload/commentsimg";
            /// <summary>
            /// 分销商扫描二维码
            /// </summary>
            public const string DistributionQR = "/upload/distributionqr";
            /// <summary>
            /// 分销商扫描二维码
            /// </summary>
            public const string DistributionQRParam = "/upload/wechatqrparam";
            /// <summary>
            /// 临时目录
            /// </summary>
            public const string TempPath = "/upload/temp";
            /// <summary>
            /// 分享晒单
            /// </summary>
            public const string ShareImgPath = "/upload/shareorder";
            /// <summary>
            /// DIY装修图片路径
            /// </summary>
            public const string DivShopImagePath = "/upload/divshop/";
            /// <summary>
            /// DIY装修视频路径 
            /// </summary>
            public const string DIYShopVideoPath = "/upload/divvideo/";
            /// <summary>
            /// 会员等级图标
            /// </summary>
            public const string MemberLevelPath = "/upload/memberlevel/";
            /// <summary>
            /// 自定义分销页面
            /// </summary>
            public const string DIYDistribution = "/upload/divdistribution/";
        }
        public class DeliveryTemplate
        {
            /// <summary>
            /// 发货模板
            /// </summary>
            public const string DeliveryTemplatePath = "/template/批量发货.xlsx";
        }
        /// <summary>
        /// 扣库存方式(发布前使用中文变量)
        /// </summary>
        public class InventoryWay
        {
            /// <summary>
            /// 拍下减库存
            /// </summary>
            public const int LessStockBySingle = 1;
            /// <summary>
            /// 付款减库存
            /// </summary>
            public const int LessStockByPay = 2;
        }
        /// <summary>
        /// 订单状态
        /// </summary>
        public class OrderState
        {
            public OrderState() { }
            public OrderState(int value, string name)
            {
                this.Value = value;
                this.Name = name;
            }
            public int Value { get; set; }
            public string Name { get; set; }

            /// <summary>
            /// 待付款
            /// </summary>
            public const int Unpaid = 1;
            /// <summary>
            /// 待发货
            /// </summary>
            public const int WaitDelivery = 2;
            /// <summary>
            /// 待收货
            /// </summary>
            public const int WaitReceipt = 3;

            /// <summary>
            /// 组团失败
            /// </summary>
            public const int GroupByFailure = 4;


            /// <summary>
            /// 已完成
            /// </summary>
            public const int Completed = 5;
            /// <summary>
            /// 退款中
            /// </summary>
            public const int Refunding = 6;
            /// <summary>
            /// 已退款
            /// </summary>
            public const int Refunded = 7;
            /// <summary>
            /// 已关闭
            /// </summary>
            public const int BeCancel = 8;

            public static string GetText(int state)
            {
                switch (state)
                {
                    case Unpaid: return "待付款";
                    case WaitDelivery: return "待发货";
                    case WaitReceipt: return "待收货";
                    case Completed: return "已完成";
                    case Refunding: return "退款中";
                    case Refunded: return "已退款";
                    case BeCancel: return "已关闭";
                    default: return "订单状态有误";
                }
            }

            public static List<OrderState> GetList()
            {
                return new List<OrderState>(){
                    new OrderState(1,"待付款"),
                    new OrderState(2,"待发货"),
                    new OrderState(3,"待收货"),
                    new OrderState(5,"已完成"),
                    new OrderState(6,"退款中"),
                    new OrderState(7,"已退款"),
                    new OrderState(8,"已关闭")
                };
            }
        }
        /// <summary>
        /// 订单状态
        /// </summary>
        public class OrderInnerState
        {
            /// <summary>
            /// 待付款
            /// </summary>
            public const int Unpaid = 1;
            /// <summary>
            /// 待发货
            /// </summary>
            public const int WaitDelivery = 2;
            /// <summary>
            /// 待收货
            /// </summary>
            public const int WaitReceipt = 3;

            /// <summary>
            /// 已完成
            /// </summary>
            public const int Completed = 5;
            /// <summary>
            /// 已关闭
            /// </summary>
            public const int BeCancel = 8;

        }
        /// <summary>
        /// 订单明细状态
        /// </summary>
        public class OrderDetailState
        {
            /// <summary>
            /// 无(默认状态)
            /// </summary>
            public const int Null = 0;
            /// <summary>
            /// 退款中
            /// </summary>
            public const int Refunding = 1;
            /// <summary>
            /// 已退款
            /// </summary>
            public const int Refunded = 2;
        }
        /// <summary>
        /// 退款申请状态
        /// </summary>
        public class RefundState
        {
            /// <summary>
            /// 处理中(默认状态)
            /// </summary>
            public const int Handling = 0;
            /// <summary>
            /// 已处理
            /// </summary>
            public const int Solved = 1;
            /// <summary>
            /// 已拒绝
            /// </summary>
            public const int Rejected = 2;
            /// <summary>
            /// 取消退款
            /// </summary>
            public const int CancelRefund = 3;
            /// <summary>
            /// 等待买家发货
            /// </summary>
            public const int WaitDelivery = 4;
            /// <summary>
            /// 买家已发货
            /// </summary>
            public const int Shipped = 5;
            /// <summary>
            /// 退款中
            /// </summary>
            public const int Refunding = 6;
        }
        /// <summary>
        /// 退款途径
        /// </summary>
        public class RefundWay
        {
            /// <summary>
            /// 退款至会员余额
            /// </summary>
            public const string MerberBalance = "会员余额";
            /// <summary>
            /// 退款至微信账号
            /// </summary>
            public const string WeChatAccount = "微信账号";
        }
        /// <summary>
        /// 申请状态
        /// </summary>
        public class Apply
        {
            /// <summary>
            /// 未申请
            /// </summary>
            public const int None = -1;
            /// <summary>
            /// 通过
            /// </summary>
            public const int Pass = 0;
            /// <summary>
            /// 拒绝
            /// </summary>
            public const int False = 1;
            /// <summary>
            /// 待审核
            /// </summary>
            public const int Waiting = 2;
            /// <summary>
            /// 获取申请状态
            /// </summary>
            /// <param name="state"></param>
            /// <returns></returns>
            public static string GetText(int state)
            {
                switch (state)
                {
                    case Pass:
                        return "通过";
                    case False:
                        return "拒绝";
                    case Waiting:
                        return "待审核";
                    default: return "未申请";
                }
            }
        }

        /// <summary>
        /// 分销排行榜
        /// </summary>
        public class DistributorCharts
        {
            /// <summary>
            /// 开启
            /// </summary>
            public const int True = 0;
            /// <summary>
            /// 关闭
            /// </summary>
            public const int False = 1;
        }

        /// <summary>
        /// 分销订单显示下级分销商信息
        /// </summary>
        public class DistributionVisible
        {
            /// <summary>
            /// 不显示
            /// </summary>
            public const int AllDisable = 0;

            /// <summary>
            /// 显示分销商名和电话
            /// </summary>
            public const int AllEnable = 1;

            /// <summary>
            /// 只显示分销商名
            /// </summary>
            public const int NameEnable = 2;

        }

        /// <summary>
        /// 店铺状态
        /// </summary>
        public class ShopState
        {
            /// <summary>
            /// 开启
            /// </summary>
            public const int Open = 0;
            /// <summary>
            /// 关闭
            /// </summary>
            public const int Close = 1;
        }

        ///// <summary>
        ///// 审核方式
        ///// </summary>
        //public class Approach
        //{
        //    /// <summary>
        //    /// 系统(自动有条件)
        //    /// </summary>
        //    public const int SystemConditional = -1;
        //    /// <summary>
        //    /// 系统(自动无条件)
        //    /// </summary>
        //    public const int SystemUnconditional = 0;
        //    /// <summary>
        //    /// 总部（手动）
        //    /// </summary>
        //    public const int Manually = 1;
        //    /// <summary>
        //    /// 无需审核(无条件)
        //    /// </summary>
        //    public const int WithoutmConditional = 2;
        //    /// <summary>
        //    /// 无需审核(有条件)
        //    /// </summary>
        //    public const int WithoutUnconditional = 3;
        //}

        /// <summary>
        /// 审核方式(New)
        /// </summary>
        public class ApproachNew
        {
            /// <summary>
            /// 系统审核
            /// </summary>
            public const int System = 0;
            /// <summary>
            /// 人工审核
            /// </summary>
            public const int Manually = 1;
            /// <summary>
            /// 无需审核
            /// </summary>
            public const int Withoutm = 2;
        }

        /// <summary>
        /// 佣金提现状态
        /// </summary>
        public class WithdriwalCom
        {
            /// <summary>
            /// 待处理
            /// </summary>
            public const int Handling = 0;
            /// <summary>
            /// 提现到会员余额
            /// </summary>
            public const int WithdrawalsSuccess = 1;
            /// <summary>
            /// 已取消
            /// </summary>
            public const int Cancelled = -1;
            /// <summary>
            /// 获取佣金提现状态
            /// </summary>
            /// <param name="state"></param>
            /// <returns></returns>
            public static string GetText(int state)
            {
                switch (state)
                {
                    case Handling:
                        return "待处理";
                    case WithdrawalsSuccess:
                        return "提现到会员余额";
                    default:
                        return "已取消";
                }
            }
        }
        /// <summary>
        /// 提现状态
        /// </summary>
        public class Withdraws
        {
            /// <summary>
            /// 处理中
            /// </summary>
            public const int Handling = 0;
            /// <summary>
            /// 已提现
            /// </summary>
            public const int WithdrawalsSuccess = 1;
            /// <summary>
            /// 提现失败
            /// </summary>
            public const int WithdrawalsFailure = -1;
            /// <summary>
            /// 获取提现状态
            /// </summary>
            /// <param name="state"></param>
            /// <returns></returns>
            public static string GetText(int state)
            {
                switch (state)
                {
                    case Handling:
                        return "处理中";
                    case WithdrawalsSuccess:
                        return "已提现";
                    default:
                        return "提现失败";
                }
            }
        }

        public class DistributionLevel
        {
            // <summary>
            /// 一级分销商
            /// </summary>
            public const int FirstLevel = 1;
            /// <summary>
            /// 二级分销商
            /// </summary>
            public const int SecondLevel = 2;
            /// <summary>
            /// 三级分销商
            /// </summary>
            public const int ThirdLevel = 3;
        }
        public class ParameterDescription
        {
            /// <summary>
            /// 过期时间说明
            /// </summary>
            public const string AutoExpirationTimeDescription = "使用说明：买家下单后，超过过期时间而未付款，订单自动变为过usertype期。过期订单，不能继续交易。";
            /// <summary>
            /// 确认发货时间说明
            /// </summary>
            public const string AutomaticWriteDescription = "使用说明：商家确认订单发货后，系统自动开始倒计时，达到指定的时间后，用户而未确认收货，系统会自动将订单标示为已收货。";
            /// <summary>
            /// 延长收货时间说明
            /// </summary>
            public const string ExtendedReceiptDescription = "使用说明：该功能仅当自动收货确认功能启用时有效。在系统自动收货时间到期前，用户可以申请延长自动确认时间。";
        }
        /// <summary>
        /// 支付方式
        /// </summary>
        public class PayWays
        {
            /// <summary>
            /// 微信支付
            /// </summary>
            public class WeiXin
            {
                public const string AppID = "AppID";
                public const string AppSecret = "AppSecret";
                public const string MChid = "MChid";
                public const string Key = "Key";
                public const string Cer = "Cer";
            }
        }
        /// <summary>
        /// 商品排序
        /// </summary>
        public class ProductTab
        {
            /// <summary>
            /// 新品
            /// </summary>
            public const string NewProduct = "新品";
            /// <summary>
            /// 价格
            /// </summary>
            public const string Price = "价格";
            /// <summary>
            /// 销量
            /// </summary>
            public const string SalesVolume = "销量";

        }

        public class TemplateMessage
        {
            /// <summary>
            /// 订单提交成功
            /// </summary>
            public const string 订单提交成功 = "1";
            /// <summary>
            /// 购买成功通知
            /// </summary>
            public const string 购买成功通知 = "2";
            /// <summary>
            /// 订单发货通知
            /// </summary>
            public const string 订单发货通知 = "3";
            /// <summary>
            /// 退款申请通知
            /// </summary>
            public const string 退款申请通知 = "4";
            /// <summary>
            /// 退款通知
            /// </summary>
            public const string 退款通知 = "5";
            /// <summary>
            /// 新订单通知
            /// </summary>
            public const string 新订单通知 = "6";
            /// <summary>
            /// 新代理加入通知
            /// </summary>
            public const string 新代理加入通知 = "7";
            /// <summary>
            /// 佣金提醒
            /// </summary>
            public const string 佣金提醒 = "8";
            /// <summary>
            /// 提现审核结果通知
            /// </summary>
            public const string 提现审核结果通知 = "9";
            /// <summary>
            /// 优惠券到期通知
            /// </summary>
            public const string 分销商申请成功提醒 = "10";
            /// <summary>
            /// 订单改价通知
            /// </summary>
            public const string 订单改价通知 = "11";
            /// <summary>
            /// 优惠券通知
            /// </summary>
            public const string 优惠券通知 = "12";
            /// <summary>
            /// 邀请关注成功通知
            /// </summary>
            public const string 邀请关注成功通知 = "13";
        }

        public class WeiXinAutoReply
        {
            public class MaterialType
            {
                /// <summary>
                /// 图文
                /// </summary>
                public const string Txt = "1";
                /// <summary>
                /// 文本
                /// </summary>
                public const string Text = "2";
                /// <summary>
                /// 图片
                /// </summary>
                public const string Image = "3";
                /// <summary>
                /// 音频
                /// </summary>
                public const string Voice = "4";
                /// <summary>
                /// 视频
                /// </summary>
                public const string Video = "5";
                /// <summary>
                /// 根据素材类别获取类型码
                /// </summary>
                /// <param name="state"></param>
                /// <returns></returns>
                public static string GetMaterialType(string state)
                {
                    switch (state)
                    {
                        case "图文":
                            return "1";
                        case "文本":
                            return "2";
                        case "图片":
                            return "3";
                        case "音频":
                            return "4";
                        default:
                            return "5";
                    }
                }
                /// <summary>
                /// 根据类型码获取素材类别
                /// </summary>
                /// <param name="state"></param>
                /// <returns></returns>
                public static string GetMaterialByState(string state)
                {
                    switch (state)
                    {
                        case "1":
                            return "图文";
                        case "2":
                            return "文本";
                        case "3":
                            return "图片";
                        case "4":
                            return "音频";
                        default:
                            return "视频";
                    }
                }
            }
            /// <summary>
            /// 内置关键字
            /// </summary>
            public class ReplyKeyword
            {
                /// <summary>
                /// 关注回复关键字
                /// </summary>
                public const string Subscribe = "subscribe_system_reply";
                ///// <summary>
                ///// 无匹配回复关键字
                ///// </summary>
                //public const string NoneMatch = "nonematch_system_reply";
                /// <summary>
                /// 默认回复关键字
                /// </summary>
                public const string Default = "default_system_reply";
            }
        }
        /// <summary>
        /// 代理类型
        /// </summary>
        public class AgentsType
        {
            /// <summary>
            /// 总部/总代理
            /// </summary>
            public const int HeadOffice = 1;
            /// <summary>
            /// 代理
            /// </summary>
            public const int Agent = 2;
        }


        public class PayType
        {
            /// <summary>
            /// 退费（5天内）
            /// </summary>
            public const int Refund = 0;

            /// <summary>
            /// 首次开通
            /// </summary>
            public const int FirstOpened = 1;
            /// <summary>
            /// 续费
            /// </summary>
            public const int Renew = 2;
            /// <summary>
            /// 升级
            /// </summary>
            public const int Upgrade = 3;

            /// <summary>
            /// 充值
            /// </summary>
            public const int Recharge = 4;

            public static string GetText(int state)
            {
                switch (state)
                {
                    case 0:
                        return "退费";
                    case 1:
                        return "首次开通";
                    case 2:
                        return "续费";
                    case 3:
                        return "升级";
                    case 4:
                        return "充值";
                    default:
                        return "";
                }
            }

        }
        /// <summary>
        /// 登录类型
        /// </summary>
        public class LoginType
        {
            /// <summary>
            /// 总部/总代理
            /// </summary>
            public const int HeadOffice = 1;
            /// <summary>
            /// 代理
            /// </summary>
            public const int Agent = 2;
            /// <summary>
            /// 商家
            /// </summary>
            public const int Merchant = 3;
            /// <summary>
            /// 员工
            /// </summary>
            public const int Employee = 4;
            /// <summary>
            /// 微信端
            /// </summary>
            public const int WeiXin = 5;


        }
        /// <summary>
        /// 系统版本
        /// </summary>
        public class Versionb
        {
            /// <summary>
            /// 空
            /// </summary>
            public const int unkown = 0;
            /// <summary>
            /// 直营版
            /// </summary>
            public const int Syb = 1;
            /// <summary>
            /// 总部版
            /// </summary>
            public const int Flagship = 2;
            /// <summary>
            /// 旗舰版下级代理
            /// </summary>
            public const int AgentFlagShip = 3;
            /// <summary>
            /// 试用版（5天）
            /// </summary>
            public const int TempTestSys = 4;
            /// <summary>
            /// 基础版
            /// </summary>
            public const int Basic = 5;


            public static string GetText(int state)
            {
                switch (state)
                {
                    case 1:
                        return "直营版";
                    case 2:
                        return "总部版";
                    case 3:
                        return "旗舰版下级代理";
                    case 4:
                        return "试用版（5天）";
                    case 5:
                        return "基础版";
                    default:
                        return "";
                }
            }

            public static int GetValue(string version)
            {
                switch (version)
                {
                    case "创业版":
                        return 1;
                    case "旗舰版":
                        return 2;
                    case "旗舰版下级代理":
                        return 3;
                    case "测试版":
                        return 4;
                    default:
                        return 0;
                }
            }
        }
        ///// <summary>
        ///// 申请成功商家状态
        ///// </summary>
        //public class ApplyState
        //{
        //    /// <summary>
        //    /// 失败
        //    /// </summary>
        //    public const int Fail = -1;
        //    /// <summary>
        //    /// 未处理
        //    /// </summary>
        //    public const int None = 0;
        //    /// <summary>
        //    /// 成功
        //    /// </summary>
        //    public const int Succeed = 1;

        //}

        /// <summary>
        /// 申请成功商家状态
        /// </summary>
        public class AgentApplyState
        {
            
            /// <summary>
            /// 审核未通过
            /// </summary>
            public const int AuditNotPass = 3;
            /// <summary>
            /// 审核通过
            /// </summary>
            public const int AuditPass = 2;
            /// <summary>
            /// 审核中
            /// </summary>
            public const int Audit = 1;

            public static string GetAgentApplyState(int state)
            { 
                switch(state)
                {
                    case 3:
                        return "审核未通过";
                    case 2:
                        return "审核通过";
                    case 1:
                        return "审核中";
                    default:
                        return "";
                }
            }
        }

        //public class TradingType
        //{ 
        //    /// <summary>
        //    /// 发展代理商获得佣金
        //    /// </summary>
        //    public const int DevelopmentCommission = 1;
        //    /// <summary>
        //    /// 商品佣金
        //    /// </summary>
        //    public const int ProductsCommission = 2;
        //    /// <summary>
        //    /// 申请提现
        //    /// </summary>
        //    public const int PresentApplication = 3;
        //    /// <summary>
        //    /// 用户充值
        //    /// </summary>
        //    public const int UserRecharge = 4;

        //}

        /// <summary>
        /// 图片分享类型
        /// </summary>
        public class ImageDistributionType
        {
            /// <summary>
            /// 默认
            /// </summary>
            public const int Default = 0;
            /// <summary>
            /// 图片
            /// </summary>
            public const int Image = 1;
        }
        /// <summary>
        /// 店铺分享类型
        /// </summary>
        public class StoreShareType
        {
            /// <summary>
            /// 店铺
            /// </summary>
            public const int Store = 0;
            /// <summary>
            /// 公众号带参数二维吗
            /// </summary>
            public const int Code = 1;
        }
        /// <summary>
        /// 分销关系锁定关系
        /// </summary>
        public class DistributionLockRelation
        {
            /// <summary>
            /// 第一个分销
            /// </summary>
            public const int First = 1;
            /// <summary>
            /// 最后一个分销
            /// </summary>
            public const int Last = 9;
        }
        /// <summary>
        /// 会员绑定商家关系
        /// </summary>
        public class MemberMerchant
        {
            /// <summary>
            /// 第一个商家
            /// </summary>
            public const string First = "First";
            /// <summary>
            /// 最后一个商家
            /// </summary>
            public const string Last = "Last";
        }
        public class DistributionStoreInfo
        {
            /// <summary>
            /// 启用
            /// </summary>
            public const int Enable = 1;
            /// <summary>
            /// 关闭
            /// </summary>
            public const int Disable = 0;
        }
        /// 强制使用公众号二维码分销
        /// </summary>
        public class EnableShareFriends
        {
            /// <summary>
            /// 启用
            /// </summary>
            public const int Enable = 1;
            /// <summary>
            /// 关闭
            /// </summary>
            public const int Disable = 0;
        }

        #region 营销活动字典
        /// <summary>
        /// 活动状态设置
        /// </summary>
        public class ActivityState
        {
            /// <summary>
            /// 未知状态
            /// </summary>
            public const int Unknown = 0;
            /// <summary>
            /// 正常
            /// </summary>
            public const int Normal = 1;
            /// <summary>
            /// 关闭
            /// </summary>
            public const int Closed = 2;
            /// <summary>
            /// 未开始
            /// </summary>
            public const int NotBeginning = 3;
            /// <summary>
            /// 展示中
            /// </summary>
            public const int Show = 4;
            /// <summary>
            /// 已结束
            /// </summary>
            public const int End = 5;

            /// <summary>
            /// 获取状态名称
            /// </summary>
            public static string GetStateName(int state)
            {
                switch (state)
                {
                    case 1: return "正常";
                    case 2: return "关闭";
                    case 3: return "未开始";
                    case 4: return "展示中";
                    case 5: return "已结束";
                    default: return "未知状态";
                }
            }
        }
        /// <summary>
        /// 活动类型
        /// </summary>
        public class ActivityType
        {
            /// <summary>
            /// 店铺优惠券
            /// </summary>
            public const int StoreCoupons = 1;
        }

        /// <summary>
        /// 优惠券类型
        /// </summary>
        public class CouponsState
        {
            /// <summary>
            /// 未使用
            /// </summary>
            public const int NotUsed = 1;
            /// <summary>
            /// 已使用 
            /// </summary>
            public const int Used = 2;
            /// <summary>
            /// 已失效 
            /// </summary>
            public const int Invalid = 3;
        }

        public class PrivilegeType
        {
            public const int Coupons = 1;
            public const int Integral = 2;
            public const int Discount = 3;
        }
        #endregion


        public class CrowdState
        {
            /// <summary>
            /// 待付款
            /// </summary>
            public const int DaiFu = -2;
            public const int YiFu = -1;

            public const int DaiFa = 0;
            public const int DaiShou = 1;
            public const int Complete = 2;
        }

        #region 充值状态

        public class RechargeState
        {
            /// <summary>
            /// 未支付
            /// </summary>
            public const int Unpaid = 0;
            /// <summary>
            /// 支付成功
            /// </summary>
            public const int Paided = 1;

            public string GetText(int state)
            {
                switch (state)
                {
                    case RechargeState.Unpaid:
                        return "未支付";
                    case RechargeState.Paided:
                        return "支付成功";
                    default:
                        return "未知状态";
                }
            }
        }

        public class RechargeInnerState
        {
            //0：未付款  1：已付款  2：正在付款 3：处理逻辑成功 4：处理逻辑失败 5：验证失败
            /// <summary>
            /// 未付款
            /// </summary>
            public const int Unpaid = 0;
            /// <summary>
            /// 已付款
            /// </summary>
            public const int Paided = 1;
            /// <summary>
            /// 正在付款
            /// </summary>
            public const int Paying = 2;
            /// <summary>
            /// 处理逻辑成功
            /// </summary>
            public const int Success = 3;
            /// <summary>
            /// 处理逻辑失败
            /// </summary>
            public const int Faile = 4;
            /// <summary>
            /// 验证失败
            /// </summary>
            public const int VerityFaile = 5;
        }

        public class RechargeType
        {
            /// <summary>
            /// 充值
            /// </summary>
            public const int Recharge = 1;
            /// <summary>
            /// 购物
            /// </summary>
            public const int Consume = 2;
            /// <summary>
            /// 退款
            /// </summary>
            public const int Refund = 3;

            public string GetText(int type)
            {
                switch (type)
                {
                    case RechargeType.Recharge:
                        return "充值";
                    case RechargeType.Consume:
                        return "购物";
                    case RechargeType.Refund:
                        return "退款";
                    default:
                        return "未知状态";
                }
            }
        }


        #endregion
    }
}