﻿using RFrameGenerate.BLL.SystemParameters;
using RFrameGenerate.DAL;
using RFrameGenerate.DAL.Interface;
using RFrameGenerate.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace RFrameGenerate.BLL
{
    /// <summary>
    /// 参数管理类
    /// </summary>
    public sealed class DictionaryMagage
    {
        #region get
        /// <summary>
        /// 根据字典名获取字典
        /// </summary>
        /// <param name="dictionaryName"></param>
        /// <returns></returns>
        public List<T_SYS_Dictionary> GetDictionary(string dictionaryName)
        {
            using (IQuery<T_SYS_Dictionary> query = Factory.CreateT_SYS_Dictionary())
            {
                return query.GetList(a => a.DictionaryName == dictionaryName);
            }
        }
        /// <summary>
        /// 根据字典名获取字典
        /// </summary>
        /// <param name="dictionaryName">字典名</param>
        /// <returns></returns>
        public List<T_SYS_Dictionary> GetDictionaryList(string dictionaryName)
        {
            using (IQuery<T_SYS_Dictionary> query = Factory.CreateT_SYS_Dictionary())
            {
                return query.GetList(a => a.DictionaryName == dictionaryName);
            }
        }
        /// <summary>
        /// 根据父字典获取字节点
        /// </summary>
        /// <param name="parentDictionaryName"></param>
        /// <param name="parentValue"></param>
        /// <returns></returns>
        public List<T_SYS_Dictionary> GetDictionaryList(string parentDictionaryName, string parentValue)
        {
            using (IQuery<T_SYS_Dictionary> query = Factory.CreateT_SYS_Dictionary())
            {
                return query.GetList(a => a.ParentDictionaryName == parentDictionaryName && a.ParentDictionaryValue == parentValue);
            }
        }
        #endregion

        #region Add
        /// <summary>
        /// 添加字典
        /// </summary>
        /// <param name="dictionaroyValueStruct"></param>
        public void AddDictionary(T_SYS_Dictionary dictionaroyValueStruct)
        {
            T_SYS_Dictionary dictionary = new T_SYS_Dictionary()
            {
                DictionaryGuid = Guid.NewGuid()
            };
            dictionary = dictionaroyValueStruct.UpdateToEntity(dictionary);
            using (IQuery<T_SYS_Dictionary> query = Factory.CreateT_SYS_Dictionary())
            {
                query.Add(dictionary);
            }
        }
        /// <summary>
        /// 添加字典
        /// </summary>
        /// <param name="list">要添加的字典</param>
        public void AddDictionary(List<T_SYS_Dictionary> list)
        {
            list.ForEach(a => a.EntityState = EntityStates.ToBeAdd);
            foreach (var v in list)
            {
                v.EntityState = EntityStates.ToBeAdd;
            }
            using (IQuery<T_SYS_Dictionary> query = Factory.CreateT_SYS_Dictionary())
            {
                query.UpdateList(list);
            }
        }
        #endregion

        #region update
        /// <summary>
        /// 更新字典
        /// </summary>
        /// <param name="dictionaroyValueStruct"></param>
        public void UpdateDictionary(T_SYS_Dictionary dictionaroyValueStruct)
        {
            using (IQuery<T_SYS_Dictionary> query = Factory.CreateT_SYS_Dictionary())
            {
                query.Update(dictionaroyValueStruct);
            }
        }
        /// <summary>
        /// 更新字典
        /// </summary>
        /// <param name="list">要更新的字典</param>
        public void UpdateDictionary(List<T_SYS_Dictionary> list)
        {
            list.ForEach(a => a.EntityState = EntityStates.ToBeUpdated);
            using (IQuery<T_SYS_Dictionary> query = Factory.CreateT_SYS_Dictionary())
            {
                query.UpdateList(list);
            }
        }
        /// <summary>
        /// 更新字典
        /// </summary>
        /// <param name="list">要更新的字典</param>
        public void UpdateDictionaryList(List<T_SYS_Dictionary> list)
        {
            using (IQuery<T_SYS_Dictionary> query = Factory.CreateT_SYS_Dictionary())
            {
                query.UpdateList(list);
            }
        }
        #endregion

        #region delete
        /// <summary>
        /// 删除字典
        /// </summary>
        /// <param name="dictionaroyValueStruct"></param>
        public void DeleteDictionary(Guid dictionaryGuid)
        {
            using (IQuery<T_SYS_Dictionary> query = Factory.CreateT_SYS_Dictionary())
            {
                query.Delete(dictionaryGuid);
            }
        }
        #endregion
    }
}
