﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using RFrameGenerate.Model;
using RFramework.SQLQuery;
using RFramework.SQLQuery.SQLExpands;
using System.Linq.Expressions;
using RFrameGenerate.Common;
using RFrameGenerate.Model.PageModel;

namespace RFrameGenerate.BLL
{
    public class DistributionPropManage
    {
        public static List<PT_Statistics_Distribute_Contribution> GetList(Guid merchantGuid)
        {
            using (var query = Factory.CreateProcedure())
            {
                return query.GetDistributeContribution(merchantGuid);
            }
        }

        public static List<R> GetList<R>(Guid[] ids, Expression<Func<T_BAS_DistributionProp, T_BAS_Member, R>> selectFields)
        {
            using (var sql = new SqlModel<T_BAS_DistributionProp, T_BAS_Member>())
            {
                return sql.SqlSelect(selectFields)
                          .SqlJionInner((a, b) => b).SqlOn((a, b) => a.MemberGuid == b.MemberGuid)
                          .SqlWhere((a, b) => a.DistributionPropGuid.SqlIn(ids) && a.SMerchantGuid == CurrentManage.MerchantGuid && b.MerchantGuid == CurrentManage.MerchantGuid)
                          .ToList();
            }
        }

        public static Result SaveSetting(bool isActive, int topNum, bool designated)
        {
            if (topNum <= 0) topNum = 5;

            RFrameGenerate.BLL.ParameterManage.UpdateParam(RFrameGenerate.BLL.ParameterName.DistributeContribute.Active, isActive ? "1" : "0");
            RFrameGenerate.BLL.ParameterManage.UpdateParam(RFrameGenerate.BLL.ParameterName.DistributeContribute.TopNum, topNum.ToString());
            RFrameGenerate.BLL.ParameterManage.UpdateParam(RFrameGenerate.BLL.ParameterName.DistributeContribute.Designated, designated ? "1" : "0");

            if (designated) return new Result(true);

            using (var sql = new SqlModel<T_BAS_DistributionProp>())
            {
                sql.SqlUpdate(m => new object[] { m.IsVistContribute == false }, v => v.IsVistContribute == true && v.SMerchantGuid == Common.CurrentManage.MerchantGuid);
            }

            return new Result(true);
        }

        public static bool UseDistributionContribute()
        {
            var value = RFrameGenerate.BLL.ParameterManage.GetParamValue(RFrameGenerate.BLL.ParameterName.DistributeContribute.Active);

            if (string.IsNullOrEmpty(value)) return false;

            return value == "1";
        }

        public static bool IsShowDistributionContribute()
        {
            if (!UseDistributionContribute()) return false;

            var value = RFrameGenerate.BLL.ParameterManage.GetParamValue(RFrameGenerate.BLL.ParameterName.DistributeContribute.Designated);

            if (string.IsNullOrEmpty(value) || value == "0") return true;

            var mydidmodel = DistributionManage.GetDistributionProp(RFrameGenerate.Common.CurrentUser.GetCurrUserGuid());

            if (mydidmodel == null) return false;

            return mydidmodel.IsVistContribute == true;
        }

        public static PageList<R> GetPageList<R>(Func<T_BAS_DistributionProp, R> selectFields, GridModel gridModel, string name)
        {
            Expression<Func<T_BAS_DistributionProp, bool>> condition = m => m.SMerchantGuid == Common.CurrentManage.MerchantGuid;

            if (!string.IsNullOrEmpty(name))
            {
                condition = condition.AndAlso(m => m.DistributionName.SqlLike(name));
            }
            using (var sql = new SqlModel<T_BAS_DistributionProp>())
            {
                return sql.SqlPage(selectFields, gridModel.page, gridModel.rows)
                          .SqlOrderDescBy(m => m.DistributionAmount)
                          .SqlWhere(condition, IsFilterNull: true)
                          .ToPageList();
            }
        }

        public static Result SetShowContribute(Guid id, bool flag)
        {
            using (var sql = new SqlModel<T_BAS_DistributionProp>())
            {
                var result = sql.SqlUpdate(m => new object[] { m.IsVistContribute == flag }, v => v.DistributionPropGuid == id);

                if (result) return new Result(true);

                else return new Result(false, "更新失败！");
            }
        }
    }
}
