﻿using RFrameGenerate.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace RFrameGenerate.BLL
{
    public class DistributionTypeManage
    {
        public static List<Model.T_BAS_DistributionType> GetPageList(GridModel gridModel)
        {
            using (var query = Factory.CreateT_BAS_DistributionType())
            {
                return query.GetPageList(gridModel, orderExpression: v => v.Value, orderMethod: DAL.Enums.OrderMethods.DESC);
            }
        }

        public static Result Save(Model.T_BAS_DistributionType type)
        {
            if (type == null) return new Result(false, "对象属性不能为空！");

            if (string.IsNullOrEmpty(type.Name)) return new Result(false, "分销分类名称不能为空！");

            if (type.Value <= 0.0m) return new Result(false, "分销分类值不能小于等于0");

            using (var query = Factory.CreateT_BAS_DistributionType())
            {
                if (type.DistributionTypeGuid == Guid.Empty)
                {
                    type.DistributionTypeGuid = Guid.NewGuid();
                    type.CreateTime = DateTime.Now;
                    type.MerchantGuid = Common.CurrentManage.MerchantGuid;
                    query.Add(type);
                }
                else if (query.IsExist(m => m.DistributionTypeGuid == type.DistributionTypeGuid))
                {
                    query.Update(m => new object[] { m.Name == type.Name, m.Value == type.Value }, v => v.DistributionTypeGuid == type.DistributionTypeGuid);
                }
                else
                {
                    type.DistributionTypeGuid = Guid.NewGuid();
                    type.CreateTime = DateTime.Now;
                    type.MerchantGuid = Common.CurrentManage.MerchantGuid;

                    query.Add(type);
                }
                return new Result(true);
            }
        }

        public static Result Delete(Guid id)
        {
            if (id == Guid.Empty) return new Result(false, "ID不能为空！");

            using (var query = Factory.CreateT_BAS_DistributionType())
            {
                if (!query.IsExist(m => m.DistributionTypeGuid == id)) return new Result(false, "不存在分类！");

                query.Delete(m => m.DistributionTypeGuid == id);
            }
            return new Result(true);
        }
    }
}
