﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using RFrameGenerate.Common;
using RFrameGenerate.Model;
using RFramework.SQLQuery;
using RFramework.SQLServer;

namespace RFrameGenerate.BLL
{
    public class FavoritesManage
    {
        public static List<PT_BAS_FavoritesSelect> GetFavoriteList()
        {
            using (var query = Factory.CreateProcedure())
            {
                return query.GetFavoriteList(RFrameGenerate.Common.CurrentUser.GetCurrUserGuid());
            }
        }
        public static List<T_BAS_Favorites> GetFavoriteList(Guid productsGuid)
        {
            var memberGuid = RFrameGenerate.Common.CurrentUser.GetCurrUserGuid();
            using(var query=Factory.CreateT_BAS_Favorites())
            {
                return query.GetList(c => c.ProductGuid == productsGuid && c.MemberGuid == memberGuid);
            }
        }

        public static Result DeleteFavorite(string favoriteGuids)
        {
            try
            {
                if (string.IsNullOrEmpty(favoriteGuids) == true)
                    return new Result(false, "请选择要删除的商品");
                string[] guis = favoriteGuids.Split(new string[] { "," }, StringSplitOptions.RemoveEmptyEntries);
                using (var tran = new SqlRTransaction())
                {
                    var query = Factory.CreateT_BAS_Favorites(tran);
                    tran.BeginTransaction();
                    foreach (var g in guis)
                        query.Delete(Guid.Parse(g));
                    tran.Commit();
                }

                return new Result(true);
            }
            catch (Exception ex)
            {
                return new Result(false, ex.Message);
            }
        }
        public static Result RemoveFavor(string favoriteGuids, int stateCode = 0)
        {
            try
            {
                if (string.IsNullOrEmpty(favoriteGuids) == true)
                    return new Result(false, "请选择移至到收藏夹的商品");
                string[] guis = favoriteGuids.Split(new string[] { "," }, StringSplitOptions.RemoveEmptyEntries);
                using (var tran = new SqlRTransaction())
                {
                    var query = Factory.CreateT_BAS_Favorites(tran);
                    tran.BeginTransaction();
                    foreach (var g in guis)
                    {
                        var arr = g.Split(new string[] { "_" }, StringSplitOptions.RemoveEmptyEntries);
                        if (stateCode == 0)//添加
                        {
                            
                            switch (arr.Length)
                            { 
                                case 1:
                                    if (query.IsExist(a => a.ProductGuid == Guid.Parse(g) && a.MemberGuid == CurrentUser.GetCurrUserGuid()) != true)
                                    {
                                        query.Add(new T_BAS_Favorites()
                                        {
                                            FavoriteGuid = Guid.NewGuid(),
                                            MemberGuid = CurrentUser.GetCurrUserGuid(),
                                            ProductGuid = Guid.Parse(g)
                                        });
                                    }
                                    break;
                                case 2:
                                    if (query.IsExist(a => a.ProductGuid == Guid.Parse(arr[0]) &&a.GroupGuid==Guid.Parse(arr[1])&& a.MemberGuid == CurrentUser.GetCurrUserGuid()) != true)
                                    {
                                        query.Add(new T_BAS_Favorites()
                                        {
                                            FavoriteGuid = Guid.NewGuid(),
                                            MemberGuid = CurrentUser.GetCurrUserGuid(),
                                            ProductGuid = Guid.Parse(arr[0]),
                                            GroupGuid=Guid.Parse(arr[1])
                                        });
                                    }
                                    break;
                            }
                        }
                        else
                        {
                            switch (arr.Length)
                            { 
                                case 1:
                                    var favo = query.GetFirstData(a => a.MemberGuid == RFrameGenerate.Common.CurrentUser.GetCurrUserGuid() && a.ProductGuid == Guid.Parse(arr[0]));
                                    if (favo==null)//添加
                                    {
                                        query.Add(new T_BAS_Favorites()
                                        {
                                            FavoriteGuid = Guid.NewGuid(),
                                            MemberGuid = CurrentUser.GetCurrUserGuid(),
                                            ProductGuid = Guid.Parse(g)
                                        });
                                    }
                                    else//删除
                                    {
                                        query.Delete(a => a.FavoriteGuid == favo.FavoriteGuid);
                                    }
                                    break;
                                case 2:
                                    var fav=query.GetFirstData(a=>a.MemberGuid==RFrameGenerate.Common.CurrentUser.GetCurrUserGuid()&&a.ProductGuid == Guid.Parse(arr[0])&&a.GroupGuid==Guid.Parse(arr[1]));
                                    if (fav == null)//添加
                                    {
                                        query.Add(new T_BAS_Favorites()
                                        {
                                            FavoriteGuid = Guid.NewGuid(),
                                            MemberGuid = CurrentUser.GetCurrUserGuid(),
                                            ProductGuid = Guid.Parse(g),
                                            GroupGuid=Guid.Parse(arr[1])
                                        });
                                    }
                                    else//删除
                                    {
                                        query.Delete(a => a.FavoriteGuid == fav.FavoriteGuid);
                                    }
                                    break;
                            }
                            
                        }
                    }
                    tran.Commit();
                }

                return new Result(true);
            }
            catch (Exception ex)
            {
                return new Result(false, ex.Message);
            }
        }
    }
}
