﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using RFrameGenerate.Model;
using RFramework.SQLQuery;
using System.Linq.Expressions;
using RFramework.SQLServer;

namespace RFrameGenerate.BLL
{
    public class FlagshipPackManage
    {
        public static T_BAS_FlagshipPack GetEntityByGuid(Guid guid)
        {
            using (var query = Factory.CreateT_BAS_FlagshipPack())
            {
                return query.GetDataByGuid(guid, false);
            }
        }

        public static List<T_BAS_FlagshipPack> GetPageList(GridModel gridModel, string name)
        {
            using (var query = Factory.CreateT_BAS_FlagshipPack())
            {
                return query.GetPageList(gridModel, m => m.FlagshipPackGuid.SqlIsNotNull() && m.PackName == name, true);
            }
        }

        public static List<T_BAS_FlagshipPack> GetList()
        {
            using (var tran = new SqlRTransaction())
            {
                var queryagent = Factory.CreateT_BAS_Agents(tran);
                var agent = queryagent.GetFirstData(a => a.AgentGuid == RFrameGenerate.Common.CurrentUser.GetCurrUserGuid());

                var query = Factory.CreateT_BAS_FlagshipPack(tran);
                var list = query.GetList(null,false,null,DAL.Enums.OrderMethods.Default,RFramework.SQLServer.Enums.LockType.Default,false);
                var resultlist = new List<T_BAS_FlagshipPack>();

                foreach (var item in list)
                {
                    var count = AgentsFlagshipManage.GetCountByFlagshipPackGuid(item.FlagshipPackGuid);

                    if (count < item.MerchantNum) resultlist.Add(item);
                }

                return resultlist;
            }
        }

        public static Result SaveChangeEntity(T_BAS_FlagshipPack entity)
        {
            using (var query = Factory.CreateT_BAS_FlagshipPack())
            {
                var model = query.GetDataByGuid(entity.FlagshipPackGuid);

                if (model == null)
                {
                    entity.FlagshipPackGuid = Guid.NewGuid();
                    query.Add(entity);
                }
                else
                {
                    query.Update(a => new object[]{
                        a.MerchantNum == entity.MerchantNum,
                        a.PackName==entity.PackName,
                        a.PackPrice==entity.PackPrice
                    }, a => a.FlagshipPackGuid == entity.FlagshipPackGuid);
                }

                return new Result(true);
            }
        }

        public static Result DeleteEntity(Guid guid)
        {
            using (var query = Factory.CreateT_BAS_FlagshipPack())
            {
                var flag = AgentsFlagshipManage.IsExistByFlagshipPackGuid(guid);

                if (flag) return new Result(false, "该套餐已经有用户开通，不能删除");

                query.Delete(guid);

                return new Result(true);
            }
        }
    }
}
