﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using RFrameGenerate.Model;

namespace RFrameGenerate.BLL
{
    public class FlagshipParaManage
    {
        public static T_BAS_FlagshipPara GetEntityByAgentsFlagshipGuid(Guid guid)
        {
            using (var query = Factory.CreateT_BAS_FlagshipPara())
            {
                return query.GetFirstData(m => m.AgentsFlagshipGuid == guid);
            }
        }

        public static Result SaveChangeEntity(T_BAS_FlagshipPara entity)
        {
            using (var query = Factory.CreateT_BAS_FlagshipPara())
            {
                var model = query.GetDataByGuid(entity.FlagshipParaGuid);

                if (model == null)
                {
                    entity.FlagshipParaGuid = Guid.NewGuid();
                    query.Add(entity);
                }
                else
                {
                    query.Update(a=>new object[]{
                        a.IsSoldOut == entity.IsSoldOut,
                        a.IsOpenAgents==entity.IsOpenAgents,
                        a.IsCustomCommission==entity.IsCustomCommission
                    },a=>a.FlagshipParaGuid==entity.FlagshipParaGuid);
                }
                return new Result(true);
            }
        }

        public static T_BAS_FlagshipPara GetEntityByMerchantGuid()
        {
            var ship = AgentsFlagshipManage.GetSupMerchant(RFrameGenerate.Common.CurrentManage.MerchantGuid);

            if (ship == null) return new T_BAS_FlagshipPara();

            using (var query = Factory.CreateT_BAS_FlagshipPara())
            {
                return query.GetFirstData(m => m.AgentsFlagshipGuid == ship.AgentsFlagshipGuid, false, null, DAL.Enums.OrderMethods.Default, RFramework.SQLServer.Enums.LockType.Default, false);
            }
        }
    }
}
