﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using RFramework.SQLQuery;
using RFramework.SQLServer;
using RFrameGenerate.DAL;
using RFrameGenerate.Model;
using RFramework.SQLQuery.SQLExpands;
using RFrameGenerate.Model.PageModel;

namespace RFrameGenerate.BLL
{
    public class HeadPay
    {
        /// <summary>
        /// 是否是可以支付,创业版,旗舰版总部,独立代理
        /// </summary>
        public static bool IsPay(string userid)
        {
            using (var tran = new SqlRTransaction())
            {
                var merch = MerchantManage.GetMerchantByUserID(userid);
                return IsPay(merch.MerchantGuid, tran);
            }
        }
        /// <summary>
        /// 是否是可以支付,创业版,旗舰版总部,独立代理
        /// </summary>
        public static bool IsPay(Guid merchGuid, SqlRTransaction tran = null)
        {
            if (tran == null)
                tran = new SqlRTransaction();
            try
            {
                var agentsFlagshipQuery = Factory.CreateT_BAS_AgentsFlagship(tran);
                var flagship = agentsFlagshipQuery.GetFirstData(a => a.MerchantGuid == merchGuid, isFilterMerchant: false);
                if (flagship != null)
                {
                    if (flagship.TopMerchantGuid == null)
                    {
                        return true;//旗舰版总部
                    }
                    else
                    {
                        var rule = AgentRulesManage.GetAgentRuleByMerchant(merchGuid);
                        if (rule.UserWeChatType == AgentRuleConst.UserWeChatType.总部)
                        {
                            return false;//加盟代理
                        }
                        else
                        {
                            return true;//独立代理
                        }
                    }
                }
                else
                {//创业版
                    return true;
                }
            }
            finally
            {
                tran.Dispose();
            }
        }

        //public static bool IsLeague(string userid)
        //{
        //    using (var tran = new SqlRTransaction())
        //    {
        //        var agentsFlagshipQuery = Factory.CreateT_BAS_AgentsFlagship(tran);
        //        var merch = MerchantManage.GetMerchantByUserID(userid);
        //        return IsLeague(merch.MerchantGuid, tran);
        //    }
        //}
        //public static bool IsLeague(Guid merchGuid, SqlRTransaction tran = null)
        //{
        //    if (tran == null)
        //        tran = new SqlRTransaction();
        //    try
        //    {
        //        var agentsFlagshipQuery = Factory.CreateT_BAS_AgentsFlagship(tran);
        //        if (agentsFlagshipQuery.IsExist(a => a.MerchantGuid == merchGuid, isFilterMerchant: false))
        //        {
        //            return true;
        //        }
        //        else
        //        {
        //            return false;
        //        }
        //    }
        //    finally
        //    {
        //        tran.Dispose();
        //    }
        //}

        /// <summary>
        /// 创业版,旗舰版总部,独立代理获取自己的appid,加盟代理获取总部的appid
        /// </summary>
        /// <param name="userid"></param>
        /// <returns></returns>
        public static string GetAppid(string userid, out bool isAutho)
        {
            using (var tran = new SqlRTransaction())
            {
                Guid merguid;//获取appid的商家主键
                var agentsFlagshipQuery = Factory.CreateT_BAS_AgentsFlagship(tran);
                var merch = MerchantManage.GetMerchantByUserID(userid);
                var agent = agentsFlagshipQuery.GetFirstData(a => a.MerchantGuid == merch.MerchantGuid, isFilterMerchant: false);
                if (agent != null)//旗舰版
                {
                    if (agent.TopMerchantGuid == null)//总部
                    {
                        merguid = agent.MerchantGuid.Value;
                        isAutho = true;
                    }
                    else
                    {
                        var rule = AgentRulesManage.GetAgentRuleByMerchant(merch.MerchantGuid);
                        if (rule.UserWeChatType == AgentRuleConst.UserWeChatType.总部)
                        {
                            merguid = agent.TopMerchantGuid.Value;//加盟代理
                            isAutho = false;
                        }
                        else
                        {
                            merguid = agent.MerchantGuid.Value; //独立代理
                            isAutho = true;
                        }
                    }

                    var sql = new SqlModel<T_BAS_Merchants, T_WX_WeChat>(tran);
                    var appid = sql
                        .SqlSelect((a, b) => new { b.appid })
                        .SqlJionInner((a, b) => b).SqlOn((a, b) => a.WeChatGuid == b.WeChatGuid)
                        .SqlWhere((a, b) => a.MerchantGuid == merguid)
                        .FirstOrDefault();
                    if (appid != null)
                        return appid.appid;
                    else
                        return string.Empty;
                }
                else//创业版
                {
                    isAutho = true;
                    var sql = Factory.CreateT_WX_WeChat(tran);
                    var wechat = sql.GetFirstData(a => a.WeChatGuid == merch.WeChatGuid, isFilterMerchant: false);
                    if (wechat != null)
                    {
                        return wechat.appid;
                    }
                    else
                    {
                        return string.Empty;
                    }
                }
            }
        }
        /// <summary>
        /// 获取对应支付的userid,创业版,旗舰版总部,独立代理获取自己的userid,加盟代理获取总部的userid
        /// </summary>
        /// <param name="userid"></param>
        /// <returns></returns>
        public static string GetPayUserID(string userid)
        {
            using (var tran = new SqlRTransaction())
            {
                var agentsFlagshipQuery = Factory.CreateT_BAS_AgentsFlagship(tran);
                var merch = MerchantManage.GetMerchantByUserID(userid);
                var agent = agentsFlagshipQuery.GetFirstData(a => a.MerchantGuid == merch.MerchantGuid, isFilterMerchant: false);
                if (agent != null)//旗舰版
                {
                    if (agent.TopMerchantGuid == null)
                    {
                        return userid;//总部
                    }
                    else
                    {
                        var rule = AgentRulesManage.GetAgentRuleByMerchant(merch.MerchantGuid);
                        if (rule.UserWeChatType == AgentRuleConst.UserWeChatType.总部)
                        {
                            //加盟代理
                            var queryMer = Factory.CreateT_BAS_Merchants(tran);
                            merch = queryMer.GetFirstData(a => a.MerchantGuid == agent.TopMerchantGuid, isFilterMerchant: false);
                            if (merch != null)
                                return merch.UserID;
                            else
                                return string.Empty;
                        }
                        else
                        {
                            return userid; //独立代理
                        }
                    }
                }
                else//创业版
                {
                    return userid;
                }
            }
        }


        public static Guid GetPayMerchantGuid(string userid)
        {
            using (var tran = new SqlRTransaction())
            {
                var agentsFlagshipQuery = Factory.CreateT_BAS_AgentsFlagship(tran);
                var merch = MerchantManage.GetMerchantByUserID(userid);
                var agent = agentsFlagshipQuery.GetFirstData(a => a.MerchantGuid == merch.MerchantGuid, isFilterMerchant: false);
                if (agent != null)//旗舰版
                {
                    if (agent.TopMerchantGuid == null)
                    {
                        return merch.MerchantGuid;//总部
                    }
                    else
                    {
                        var rule = AgentRulesManage.GetAgentRuleByMerchant(merch.MerchantGuid);
                        if (rule.UserWeChatType == AgentRuleConst.UserWeChatType.总部)
                        {
                            //加盟代理
                            return agent.TopMerchantGuid.Value;
                        }
                        else
                        {
                            return merch.MerchantGuid; //独立代理
                        }
                    }
                }
                else//创业版
                {
                    return merch.MerchantGuid;
                }
            }
        }


        public static Guid GetPayMerchantGuid(Guid merchGuid)
        {
            using (var tran = new SqlRTransaction())
            {
                var agentsFlagshipQuery = Factory.CreateT_BAS_AgentsFlagship(tran);
                var merch = MerchantManage.GetMerchant(merchGuid) ;
                var agent = agentsFlagshipQuery.GetFirstData(a => a.MerchantGuid == merch.MerchantGuid, isFilterMerchant: false);
                if (agent != null)//旗舰版
                {
                    if (agent.TopMerchantGuid == null)
                    {
                        return merch.MerchantGuid;//总部
                    }
                    else
                    {
                        var rule = AgentRulesManage.GetAgentRuleByMerchant(merch.MerchantGuid);
                        if (rule.UserWeChatType == AgentRuleConst.UserWeChatType.总部)
                        {
                            //加盟代理
                            return agent.TopMerchantGuid.Value;
                        }
                        else
                        {
                            return merch.MerchantGuid; //独立代理
                        }
                    }
                }
                else//创业版
                {
                    return merch.MerchantGuid;
                }
            }
        }

        public static bool IsTopMerchant(Guid merchGuid)
        {
            using (var tran = new SqlRTransaction())
            {
                var agentsFlagshipQuery = Factory.CreateT_BAS_AgentsFlagship(tran);
                var agent = agentsFlagshipQuery.GetFirstData(a => a.MerchantGuid == merchGuid, isFilterMerchant: false);
                if (agent == null)
                    return false;
                else
                {
                    if (agent.TopMerchantGuid == null)
                        return true;
                    else
                        return false;
                }
            }
        }

        public static void Login(string userid, string appid)
        {
            using (var tran = new SqlRTransaction())
            {
                var agentsFlagshipQuery = Factory.CreateT_BAS_AgentsFlagship(tran);
                var merch = MerchantManage.GetMerchantByUserID(userid);
                RFrameGenerate.Common.CurrentUser.SetMerchantUserID(userid);
                RFrameGenerate.Common.CurrentUser.SetMerchantGuid(merch.MerchantGuid);
                RFrameGenerate.Common.CurrentUser.SetSMerchantGuid(merch.MerchantGuid);
                RFrameGenerate.Common.CurrentUser.SetAppID(appid);
            }
        }

        /// <summary>
        /// 获取支付配置
        /// </summary>
        /// <returns></returns>
        public static PT_BAS_PayWayByOrderNo GetPayWayByOrderNO(string orderNo)
        {
            PT_BAS_PayWayByOrderNo result;
            using (var tran = new SqlRTransaction())
            {
                var order = Factory.CreateT_BAS_Orders(tran).GetFirstData(a => a.OrderNo == orderNo, isFilterMerchant: false);
                if (order == null)
                {
                    Wechat.LogManage.Log("支付出错,找不到支付订单.");
                    throw new Exception("支付出错,找不到支付订单.");
                }

                Guid merguid;
                var agentsFlagshipQuery = Factory.CreateT_BAS_AgentsFlagship(tran);
                var agent = agentsFlagshipQuery.GetFirstData(a => a.MerchantGuid == order.MerchantGuid, isFilterMerchant: false);
                if (agent != null)
                {
                    var rule = AgentRulesManage.GetAgentRuleByMerchant(order.MerchantGuid.Value);
                    if (rule.UserWeChatType == AgentRuleConst.UserWeChatType.总部)
                    {
                        merguid = agent.TopMerchantGuid.Value;//加盟代理
                    }
                    else
                    {
                        merguid = agent.MerchantGuid.Value; //独立代理
                    }
                }
                else
                {
                    merguid = order.MerchantGuid.Value;
                }

                var sql = new SqlModel<T_BAS_MerchantsPayWay, T_BAS_PayWays, T_BAS_Merchants>(tran);

                var pay = sql.SqlSelect((a, b, c) => new { a.IsEnable, a.Prop })
                    .SqlJionLeft((a, b, c) => b).SqlOn((a, b, c) => a.PayWayGuid == b.PayWayGuid)
                    .SqlJionLeft((a, b, c) => c).SqlOn((a, b, c) => a.MerchantGuid == c.MerchantGuid)
                    .SqlWhere((a, b, c) => a.MerchantGuid == merguid)
                    .FirstOrDefault();

                if (pay == null)
                    return null;

                ////var payQuery = Factory.CreateT_BAS_MerchantsPayWay(tran);
                ////var pay = payQuery.GetFirstData(a => a.MerchantGuid == merguid);
                result = new PT_BAS_PayWayByOrderNo()
                {
                    IsEnable = pay.IsEnable,
                    Prop = pay.Prop
                };
                return result;
            }
        }

        public static PT_BAS_PayWayByOrderNo GetPayWayByOrderNO_Crowd(string orderNOs)
        {
            var orders = orderNOs.Split(new string[] { "-" }, StringSplitOptions.RemoveEmptyEntries)[0];


            PT_BAS_PayWayByOrderNo result;
            using (var tran = new SqlRTransaction())
            {
                var order = Factory.CreateT_CR_CrowdParticipate(tran).GetFirstData(a => a.OrderNo == orders, isFilterMerchant: false);
                if (order == null)
                {
                    Wechat.LogManage.Log("支付出错,找不到支付订单.");
                    throw new Exception("支付出错,找不到支付订单.");
                }

                Guid merguid;
                var agentsFlagshipQuery = Factory.CreateT_BAS_AgentsFlagship(tran);
                var agent = agentsFlagshipQuery.GetFirstData(a => a.MerchantGuid == order.MerchantGuid, isFilterMerchant: false);
                if (agent != null)
                {
                    var rule = AgentRulesManage.GetAgentRuleByMerchant(order.MerchantGuid.Value);
                    if (rule.UserWeChatType == AgentRuleConst.UserWeChatType.总部)
                    {
                        merguid = agent.TopMerchantGuid.Value;//加盟代理
                    }
                    else
                    {
                        merguid = agent.MerchantGuid.Value; //独立代理
                    }
                }
                else
                {
                    merguid = order.MerchantGuid.Value;
                }

                var sql = new SqlModel<T_BAS_MerchantsPayWay, T_BAS_PayWays, T_BAS_Merchants>(tran);

                var pay = sql.SqlSelect((a, b, c) => new { a.IsEnable, a.Prop })
                    .SqlJionLeft((a, b, c) => b).SqlOn((a, b, c) => a.PayWayGuid == b.PayWayGuid)
                    .SqlJionLeft((a, b, c) => c).SqlOn((a, b, c) => a.MerchantGuid == c.MerchantGuid)
                    .SqlWhere((a, b, c) => a.MerchantGuid == merguid)
                    .FirstOrDefault();

                if (pay == null)
                    return null;

                ////var payQuery = Factory.CreateT_BAS_MerchantsPayWay(tran);
                ////var pay = payQuery.GetFirstData(a => a.MerchantGuid == merguid);
                result = new PT_BAS_PayWayByOrderNo()
                {
                    IsEnable = pay.IsEnable,
                    Prop = pay.Prop
                };
                return result;
            }
        }

        public static PT_BAS_PayWayByOrderNo GetPayWayByOrderNO_T_BAS_Recharge(string orders)
        {
            PT_BAS_PayWayByOrderNo result;
            using (var tran = new SqlRTransaction())
            {
                var order = Factory.CreateT_BAS_Recharge(tran).GetFirstData(a => a.OrderNo == orders, isFilterMerchant: false);
                if (order == null)
                {
                    Wechat.LogManage.Log("支付出错,找不到支付订单.");
                    throw new Exception("支付出错,找不到支付订单.");
                }

                Guid merguid;
                var agentsFlagshipQuery = Factory.CreateT_BAS_AgentsFlagship(tran);
                var agent = agentsFlagshipQuery.GetFirstData(a => a.MerchantGuid == order.MerchantGuid, isFilterMerchant: false);
                if (agent != null)
                {
                    var rule = AgentRulesManage.GetAgentRuleByMerchant(order.MerchantGuid.Value);
                    if (rule.UserWeChatType == AgentRuleConst.UserWeChatType.总部)
                    {
                        merguid = agent.TopMerchantGuid.Value;//加盟代理
                    }
                    else
                    {
                        merguid = agent.MerchantGuid.Value; //独立代理
                    }
                }
                else
                {
                    merguid = order.MerchantGuid.Value;
                }

                var sql = new SqlModel<T_BAS_MerchantsPayWay, T_BAS_PayWays, T_BAS_Merchants>(tran);

                var pay = sql.SqlSelect((a, b, c) => new { a.IsEnable, a.Prop })
                    .SqlJionLeft((a, b, c) => b).SqlOn((a, b, c) => a.PayWayGuid == b.PayWayGuid)
                    .SqlJionLeft((a, b, c) => c).SqlOn((a, b, c) => a.MerchantGuid == c.MerchantGuid)
                    .SqlWhere((a, b, c) => a.MerchantGuid == merguid)
                    .FirstOrDefault();

                if (pay == null)
                    return null;

                ////var payQuery = Factory.CreateT_BAS_MerchantsPayWay(tran);
                ////var pay = payQuery.GetFirstData(a => a.MerchantGuid == merguid);
                result = new PT_BAS_PayWayByOrderNo()
                {
                    IsEnable = pay.IsEnable,
                    Prop = pay.Prop
                };
                return result;
            }
        }

    }
}
