﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using RFrameGenerate.Model;

namespace RFrameGenerate.BLL
{
    public class KeywordsManage
    {
        /// <summary>
        /// get keywordlist by gridmodel
        /// </summary>
        /// <param name="gridModel"></param>
        /// <returns></returns>
        public static List<T_BAS_Keywords> GetKeyWordList(GridModel gridModel)
        {
            using (var query = Factory.CreateT_BAS_Keywords())
            {
                return query.GetPageList(gridModel, c => c.MerchantGuid == RFrameGenerate.Common.CurrentManage.MerchantGuid && c.Keyword !=RFrameGenerate.BLL.DictionaryConst.WeiXinAutoReply.ReplyKeyword.Subscribe && c.Keyword != RFrameGenerate.BLL.DictionaryConst.WeiXinAutoReply.ReplyKeyword.Default);
            }
        }
        /// <summary>
        /// get keywordlist by merchantguid
        /// </summary>
        /// <returns></returns>
        public static List<T_BAS_Keywords> GetKeyWordList()
        {
            using (var query = Factory.CreateT_BAS_Keywords())
            {
                return query.GetList(c => c.MerchantGuid == RFrameGenerate.Common.CurrentManage.MerchantGuid);
            }
        }

        /// <summary>
        /// get keywordlist by kedword
        /// </summary>
        /// <param name="gridModel"></param>
        /// <param name="keyword"></param>
        /// <returns></returns>
        public static List<T_BAS_Keywords> GetKeyWordList(GridModel gridModel,string keyword)
        {
            using (var query = Factory.CreateT_BAS_Keywords())
            {
                return query.GetList(c => c.MerchantGuid == RFrameGenerate.Common.CurrentManage.MerchantGuid && c.Keyword==keyword);
            }
        }

        public static Result AddAndUpdateKeyword(T_BAS_Keywords entity)
        {
            using (var query = Factory.CreateT_BAS_Keywords())
            {
                if (entity.KeywordGuid==Guid.Empty)
                {
                    entity.MerchantGuid = RFrameGenerate.Common.CurrentManage.MerchantGuid;
                    entity.KeywordGuid = Guid.NewGuid();
                    query.Add(entity);
                }
                else
                {
                    query.Update(c=>new object[]
                    {
                        c.Keyword==entity.Keyword,
                        c.MaterialGuid==entity.MaterialGuid
                    }, a=>a.KeywordGuid==entity.KeywordGuid);
                }
            }
            return new Result(true);
        }

        /// <summary>
        /// delete function
        /// </summary>
        /// <param name="keywordGuid"></param>
        /// <returns></returns>
        public static Result DeleteKeyword(Guid keywordGuid)
        {
            using (var query = Factory.CreateT_BAS_Keywords())
            {
                query.Delete(c => c.KeywordGuid == keywordGuid);
            }
            return new Result(true);
        }

        /// <summary>
        /// get materialsGuid by materialsguid
        /// eq get a count
        /// </summary>
        /// <param name="materialsGuid"></param>
        /// <returns></returns>
        public static int EqualByMaterialsGuid(Guid materialsGuid)
        {
            using (var query = Factory.CreateT_BAS_Keywords())
            {
                return query.GetCount(c => c.MaterialGuid == materialsGuid);
            }
        } 
       
        public static List<SelectKeywordMaterials> GetKeyList()
        {
            using (var query = Factory.CreateProcedure())
            {
                return query.GetSelectKeywordMaterials().Where(a=>a.Keyword!=DictionaryConst.WeiXinAutoReply.ReplyKeyword.Default&&a.Keyword!=DictionaryConst.WeiXinAutoReply.ReplyKeyword.Subscribe).ToList();
            }
        }

       
        public static List<SelectKeywordMaterials> GetKeyList(string keyword)
        {
            using (var query = Factory.CreateProcedure())
            {
                return query.GetSelectKeywordMaterials(keyword);
            }
        }

        
    }
}
