﻿using RFrameGenerate.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using RFramework.SQLServer;

namespace RFrameGenerate.BLL
{
    public class LoginRelationManage
    {
        public static T_BAS_LoginRelation GetLoginRelationByMer(Guid merGuid)
        {
            using (var query = Factory.CreateT_BAS_LoginRelation())
            {
                return query.GetFirstData(a => a.MerchantGuid == merGuid);
            }
        }

        public static Result LoginValid(string userid, string pwd, out T_BAS_LoginRelation lr)
        {
            using (var query = Factory.CreateT_BAS_LoginRelation())
            {
                var rela = query.GetFirstData(a => a.UserID2 == userid, false, null, DAL.Enums.OrderMethods.Default, RFramework.SQLServer.Enums.LockType.Default, false);

                if (rela != null)
                {
                    lr = rela;
                    if (rela.IsEnable != true)
                        return new Result(false, "已关闭云平台一键登录分销平台");   

                    if (pwd == RFramework.MD5Crypto.MD5(RFramework.RSACrypto.Decrypt(RFramework.RSACrypto.PrivateKey, rela.Password2)).ToLower())
                    {
                        return new Result(true);
                    }
                    else
                        return new Result(false, "密码错误");
                }
                else
                {
                    lr = null;
                    return new Result(false, "账号不存在或没有在分销系统绑定账号");
                }
            }
        }

        public static Result Save(Guid LoginRelationGuid, string userid, string password, bool isenable)
        {
            if (userid == null) userid = string.Empty;
            if (password == null) password = string.Empty;

            //需要验证密码
            using (var tran = new SqlRTransaction())
            {
                var queryMer = Factory.CreateT_BAS_Merchants(tran);
                var mer = queryMer.GetFirstData(a => a.MerchantGuid == RFrameGenerate.Common.CurrentManage.MerchantGuid);
                var query = Factory.CreateT_BAS_LoginRelation(tran);
                tran.BeginTransaction();
                password = RFramework.RSACrypto.Encode(RFramework.RSACrypto.PublicKey, password);
                var lr = query.GetFirstData(a => a.MerchantGuid == RFrameGenerate.Common.CurrentManage.MerchantGuid);
                if (lr != null)
                {
                    query.Update(a => new object[]
                    { 
                        a.UserID1==mer.UserID,
                        a.Password1==mer.Password,
                        a.UserID2 == userid ,
                        a.Password2 == password, 
                        a.IsEnable == isenable ,                        
                    }, b => b.MerchantGuid == RFrameGenerate.Common.CurrentManage.MerchantGuid);
                }
                else
                {
                    query.Add(new T_BAS_LoginRelation()
                    {
                        MerchantGuid = RFrameGenerate.Common.CurrentManage.MerchantGuid,
                        IsEnable = isenable,
                        LoginRelationGuid = Guid.NewGuid(),
                        RelationDate = DateTime.Now,
                        UserID1 = mer.UserID,
                        Password1 = mer.Password,
                        UserID2 = userid,
                        Password2 = password,
                    });
                }
                tran.Commit();
                return new Result(true);
            }
        }
    }
}
