﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using OfficeOpenXml.ConditionalFormatting;
using RFrameGenerate.DAL.SQLServer;
using RFrameGenerate.Model;
using RFramework.SQLServer;
using System.Linq.Expressions;

namespace RFrameGenerate.BLL
{
    public class LogisticManage
    {
        public static T_BAS_Logistics GetLogist(Guid? logistGuid)
        {
            if (logistGuid == null) return new T_BAS_Logistics();
            using (var query = Factory.CreateT_BAS_Logistics())
            {
                return query.GetFirstData(a => a.LogisticrGuid == logistGuid);
            }
        }

        /// <summary>
        /// 根据GUID获取物流信息
        /// </summary>
        /// <param name="guid"></param>
        /// <returns></returns>
        public static T_BAS_Logistics GetEntity(Guid guid)
        {
            using (var query = Factory.CreateT_BAS_Logistics())
            {
                return query.GetFirstData(t => t.LogisticrGuid == guid, isFilterMerchant:false);
            }
        }
        /// <summary>
        /// 保存物流表(待配送方式完成需修改)
        /// </summary>
        /// <param name="guid"></param>
        /// <param name="expressNumber"></param>
        /// <param name="expressCompanyGuid"></param>
        /// <param name="recieverAddress"></param>
        /// <returns></returns>
        public static Result SaveLogistics(Guid? guid, string expressNumber, Guid expressCompanyGuid, Guid recieverAddress, Guid orderGuid)
        {
            
            using (var tran=new SqlRTransaction())
            {
                try
                {
                    var query = Factory.CreateT_BAS_Logistics(tran);
                    var query_recieverAddress = Factory.CreateT_BAS_RecieverAddress(tran);
                    var query_order = Factory.CreateT_BAS_Orders(tran);
                    var logisticrGuid=Guid.NewGuid(); 
                    var entity = query_recieverAddress.GetDataByGuid(recieverAddress);  
                    T_BAS_LogisticsCompanys LogisticsCompanys = LogisticsCompanysManage.GetEntity(expressCompanyGuid);
                    
                    tran.BeginTransaction();
                    if (guid == null || guid==Guid.Empty)
                    {
                        
                        query.Add(new T_BAS_Logistics()
                        {
                            LogisticrGuid = logisticrGuid,
                            DeliveryMethodGuid = LogisticsCompanys.LogisticsCompanyGuid,
                            Consignee = entity==null?"":entity.Reciever,
                            ExpressNumber=expressNumber,
                            ExpressCompany = LogisticsCompanys.LogisticsCompanyName,
                            DeliveryMethod = LogisticsCompanys.LogisticsCompanyName,
                            ExpressDetail=null,
                            Arear = entity == null ? "" : entity.Area,
                            Address = entity == null ? "" : entity.Address,
                            Telephone = entity == null ? "" : entity.Telephone,
                            Zip = entity == null ? "" : entity.Zip,
                            DateTime=DateTime.Now
                        });
                        query_order.Update(a => new Object[]{
                            a.LogisticrGuid==logisticrGuid
                        }, a => a.OrderGuid == orderGuid);
                    }
                    else
                    {
                        var model = query.GetDataByGuid(guid.Value);
                        if (model == null)
                        {
                            query.Add(new T_BAS_Logistics()
                            {
                                LogisticrGuid = guid.Value,
                                DeliveryMethodGuid = LogisticsCompanys.LogisticsCompanyGuid,
                                Consignee = entity == null ? "" : entity.Reciever,
                                ExpressNumber = expressNumber,
                                ExpressCompany = LogisticsCompanys.LogisticsCompanyName,
                                DeliveryMethod = LogisticsCompanys.LogisticsCompanyName,
                                ExpressDetail = null,
                                Arear = entity == null ? "" : entity.Area,
                                Address = entity == null ? "" : entity.Address,
                                Telephone = entity == null ? "" : entity.Telephone,
                                Zip = entity == null ? "" : entity.Zip,
                                DateTime = DateTime.Now
                            });
                        }
                        else
                        {
                            query.Update(a => new Object[]{
                                a.ExpressNumber == expressNumber,
                                a.ExpressCompany == LogisticsCompanys.LogisticsCompanyName
                            }, a => a.LogisticrGuid == guid);
                        }
                    }
                    tran.Commit();
                    return new Result(true);
                }
                catch (Exception err)
                {
                    tran.Rollback();
                    return new Result(false, err.Message);
                }
            }
        }


        public static Result UpdateByOrderGuid(Guid? entityGuid, string logisticsCompanyName, string logisticsExpressNumber)
        {
            try
            {
                using (var query = Factory.CreateT_BAS_Logistics())
                {
                    var model = query.GetFirstData(a => a.LogisticrGuid == entityGuid);

                    model.ExpressNumber = logisticsExpressNumber;
                    model.ExpressCompany = logisticsCompanyName;

                    query.Update(model);

                    return new Result(true);
                }
            }
            catch (Exception err)
            {
                return new Result(false, err.Message);
            }
        }
    }
}
