﻿using RFrameGenerate.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using RFramework.SQLQuery;

namespace RFrameGenerate.BLL.Logistics
{
    public class PackageMailManage
    {
        #region 读取数据

        public static List<T_BAS_PackageMail> GetList(Guid templateGuid)
        {
            if (templateGuid == Guid.Empty) return new List<T_BAS_PackageMail>(0);

            using (var query = Factory.CreateT_BAS_PackageMail())
            {
                return query.GetList(m => m.TemplatesGuid == templateGuid);
            }
        }

        public static T_BAS_PackageMail GetPackageByAreaCode(Guid templateGuid, string areacode)
        {
            if (string.IsNullOrEmpty(areacode)) return null;

            if (templateGuid == Guid.Empty) return null;

            string code = TemplatesManage.GetAreaCodeKey(areacode);

            using (var query = Factory.CreateT_BAS_PackageMail())
            {
                return query.GetFirstData(m => m.SupportArea.SqlLike(code) && m.TemplatesGuid == templateGuid,isFilterMerchant:false);
            }
        }
        #endregion

        #region 逻辑处理

        public static bool IsPackageMail(T_BAS_Templates templates, decimal total, decimal totalPrice, string areaCode)
        {
            if (string.IsNullOrEmpty(areaCode)) return false;

            if (templates == null) return false;

            if (templates.IsPinkage == 2) return false;

            if (templates.IsPackageMail == null || !templates.IsPackageMail.Value) return false;

            var package = GetPackageByAreaCode(templates.TemplatesGuid, areaCode);

            if (package == null) return false;

            if (package.PackageMaiType == 1 && total >= package.PackageMaiValue) return true;

            if (package.PackageMaiType == 2 && totalPrice >= package.PackageMaiValue) return true;

            return false;
        }

        #endregion
    }
}
