﻿using RFrameGenerate.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using RFramework.SQLQuery;

namespace RFrameGenerate.BLL.Logistics
{
    public class ShippingMethodManage
    {
        #region 读取数据

        /// <summary>
        /// 获取运送方式列表
        /// </summary>
        public static List<T_BAS_ShippingMethod> GetListByTemplate(Guid templatesGuid)
        {
            if (templatesGuid == Guid.Empty) return new List<T_BAS_ShippingMethod>();

            using (var query = Factory.CreateT_BAS_ShippingMethod())
            {
                return query.GetList(m => m.TemplatesGuid == templatesGuid);
            }
        }
        #endregion

        #region 逻辑处理

        /// <summary>
        /// 获取对应运费方式
        /// </summary>
        public static T_BAS_ShippingMethod GetShippingMethod(Guid templatesGuid, string areaCode)
        {
            if (string.IsNullOrEmpty(areaCode)) return GetDefaultMethod(templatesGuid);

            var method = GetMethodByAreaCode(templatesGuid, areaCode);

            if (method != null) return method;

            return GetDefaultMethod(templatesGuid);
        }

        /// <summary>
        /// 计算指定方式运费
        /// </summary>
        public static PriceResult GetFreightByMethod(T_BAS_ShippingMethod method, int total)
        {
            if (method == null) return new PriceResult(false, "指定运送方式不能为空！");

            if (method.FirstArticleNum == null) return new PriceResult(false, "指定运送方式首次数量不能为空！");

            if (method.FirstArticlePrice == null) return new PriceResult(false, "指定运送方式首次运费不能为空");

            if (method.ContinueArticleNum == null) return new PriceResult(false, "指定运送方式续件数量不能为空！");

            if (method.ContinueArticlePrice == null) return new PriceResult(false, "指定运送方式续件价格不能为空！");

            if (total <= method.FirstArticleNum.Value) return new PriceResult(true, method.FirstArticlePrice.Value);

            int remainder = total - method.FirstArticleNum.Value;
            int next = remainder % method.ContinueArticleNum.Value == 0 ? remainder / method.ContinueArticleNum.Value : (remainder / method.ContinueArticleNum.Value) + 1;

            return new PriceResult(true, method.FirstArticlePrice.Value + next * method.ContinueArticlePrice.Value);
        }

        /// <summary>
        /// 获取默认运费方式
        /// </summary>
        private static T_BAS_ShippingMethod GetDefaultMethod(Guid templatesGuid)
        {
            using (var query = Factory.CreateT_BAS_ShippingMethod())
            {
                return query.GetFirstData(m => m.SupportArea.SqlIsNull() && m.TemplatesGuid == templatesGuid,isFilterMerchant:false);
            }
        }

        /// <summary>
        /// 获取指定区域运费方式
        /// </summary>
        private static T_BAS_ShippingMethod GetMethodByAreaCode(Guid templatesGuid, string areaCode)
        {
            string code = TemplatesManage.GetAreaCodeKey(areaCode);

            using (var query = Factory.CreateT_BAS_ShippingMethod())
            {
                return query.GetFirstData(m => m.SupportArea.SqlLike(code) && m.SupportArea.SqlIsNotNull() && m.TemplatesGuid == templatesGuid, isFilterMerchant: false);
            }
        }

        #endregion
    }
}
