﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using RFrameGenerate.Model;

namespace RFrameGenerate.BLL
{
    public class MaterialTxtManage
    {
        /// <summary>
        /// add and update txt materials (List<T/>)
        /// add:materialguid is null or empty 
        /// </summary>
        /// <param name="list"></param>
        /// <returns></returns>
        public static Result AddOrUpdateTxt(T_BAS_MaterialTxt list)
        {
            using (var query = Factory.CreateT_BAS_MaterialTxt())
            {
                query.Add(list);
            }
            return new Result(true);
        }


        /// <summary>
        /// delete function
        /// </summary>
        /// <param name="materialsGuid"></param>
        /// <returns></returns>
        public static Result DeleteTxtMaterials(Guid materialsGuid)
        {
            using (var query = Factory.CreateT_BAS_MaterialTxt())
            {
                query.Delete(c => c.MaterialGuid == materialsGuid);
            }
            return new Result(true);
        }

        /// <summary>
        /// delete function by materialstxtGuid
        /// </summary>
        /// <param name="materialsTxtGuid"></param>
        /// <returns></returns>
        public static Result DeleteTxtMaterialsByGuid(Guid materialsTxtGuid)
        {
            using (var query = Factory.CreateT_BAS_MaterialTxt())
            {
                query.Delete(c => c.MaterialTxtlGuid == materialsTxtGuid);
            }
            return new Result(true);
        }


        /// <summary>
        /// get sort count
        /// </summary>
        /// <param name="materialsGuid"></param>
        /// <returns></returns>
        public static List<T_BAS_MaterialTxt> GetSortList(Guid materialsGuid)
        {
            using (var query = Factory.CreateT_BAS_MaterialTxt())
            {
                return query.GetList(c => c.MaterialGuid == materialsGuid);
            }
        }


        public static Guid GetMaterialsGuidByTxtlGuid(Guid materialtxtlGuid)
        {
            using (var query = Factory.CreateT_BAS_MaterialTxt())
            {
                return query.GetFirstData(c => c.MaterialTxtlGuid == materialtxtlGuid).MaterialGuid;
            }
        }

        public static List<T_BAS_MaterialTxt> GetMaterialsTxtList(Guid materialGuid)
        {
            using (var query = Factory.CreateT_BAS_MaterialTxt())
            {
                return query.GetList(c => c.MaterialGuid == materialGuid);
            }
        }

        public static void UpdateSorf(Guid materialtxtlGuid, int sort)
        {
            using (var query = Factory.CreateT_BAS_MaterialTxt())
            {
                query.Update(c => new object[]
                {
                    c.Sort==sort
                }, s => s.MaterialTxtlGuid == materialtxtlGuid);
            }
        }

        public static void AddSimpleTxt(List<T_BAS_MaterialTxt> entity)
        {
            using (var query = Factory.CreateT_BAS_MaterialTxt())
            {
                query.AddList(entity);
            }
        }

        public static Result UpdateSimpleTxt(List<T_BAS_MaterialTxt> list)
        {
            using (var query = Factory.CreateT_BAS_MaterialTxt())
            {
                foreach (var l in list)
                {
                    var mar = l;
                    query.Update(c => new object[]
                    {
                        c.TXTCover == mar.TXTCover,
                        c.Name == mar.Name,
                        c.TXTAuthor == mar.TXTAuthor,
                        c.TXTUrl == mar.TXTUrl,
                        c.TXTDescribe == mar.TXTDescribe
                    }, a => a.MaterialTxtlGuid == mar.MaterialTxtlGuid);
                }
            }
            return new Result(true);
        }

        public static Result UpdatAllTxt(T_BAS_MaterialTxt list)
        {
            using (var query = Factory.CreateT_BAS_MaterialTxt())
            {
                query.Update(c => new object[]
                {
                    c.TXTCover == list.TXTCover,
                    c.Name == list.Name,
                    c.TXTAuthor == list.TXTAuthor,
                    c.TXTUrl == list.TXTUrl,
                    c.TXTDescribe == list.TXTDescribe
                }, a => a.MaterialTxtlGuid == list.MaterialTxtlGuid);
            }
            return new Result(true);
        }
    }
}
