﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using RFrameGenerate.Model;
using RFramework.SQLServer;

namespace RFrameGenerate.BLL
{
    public class MaterialsManage
    {
        #region List<T_BAS_Materials> GetMaterialList

        /// <summary>
        /// get materials list by gridmodel
        /// </summary>
        /// <param name="gridModel"></param>
        /// <param name="type"></param>
        /// <returns></returns>
        public static List<T_BAS_Materials> GetMaterialList(GridModel gridModel, string type)
        {
            using (var query = Factory.CreateT_BAS_Materials())
            {
                return query.GetPageList(gridModel, c => c.MerchantGuid == RFrameGenerate.Common.CurrentManage.MerchantGuid && c.MaterialType == type);
            }
        }

        /// <summary>
        /// get materials list by materialguid
        /// </summary>
        /// <param name="materialGuid"></param>
        /// <returns></returns>
        public static T_BAS_Materials GetMaterialList(Guid materialGuid)
        {
            using (var query = Factory.CreateT_BAS_Materials())
            {
                return query.GetFirstData(c => c.MaterialGuid == materialGuid);
            }
        }

        /// <summary>
        /// get all materials list 
        /// </summary>
        /// <param name="materialGuid"></param>
        /// <returns></returns>
        public static List<T_BAS_Materials> GetMaterialList()
        {
            using (var query = Factory.CreateT_BAS_Materials())
            {
                return query.GetList(c => c.MerchantGuid == RFrameGenerate.Common.CurrentManage.MerchantGuid);
            }
        }
        #endregion

        /// <summary>
        /// add and update materials
        /// add:materialguid is null or empty 
        /// </summary>
        /// <param name="entity"></param>
        /// <returns></returns>
        public static Result AddAndUpdateMaterials(T_BAS_Materials entity)
        {
            using (var query = Factory.CreateT_BAS_Materials())
            {
                if (entity.MaterialGuid == Guid.Empty)
                {
                    entity.MaterialGuid = Guid.NewGuid();
                    entity.MerchantGuid = RFrameGenerate.Common.CurrentManage.MerchantGuid;
                    entity.MaterialType = DictionaryConst.WeiXinAutoReply.MaterialType.GetMaterialType(entity.MaterialType);
                    query.Add(entity);
                }
                else if (entity.Content == null)
                {
                    query.Update(c => new object[]
                    {
                        c.Name==entity.Name
                    }, a => a.MaterialGuid == entity.MaterialGuid);
                }
                else
                {
                    query.Update(c => new object[]
                    {
                        c.Name==entity.Name,
                        c.Content==entity.Content
                    }, a => a.MaterialGuid == entity.MaterialGuid);
                }
            }
            return new Result(true);
        }

        public static Result AddAndUpdateTxtMaterials(T_BAS_Materials entity)
        {
            using (var query = Factory.CreateT_BAS_Materials())
            {
                if (entity.MaterialGuid == Guid.Empty)
                {
                    entity.MaterialGuid = Guid.NewGuid();
                    entity.MerchantGuid = RFrameGenerate.Common.CurrentManage.MerchantGuid;
                    entity.MaterialType = DictionaryConst.WeiXinAutoReply.MaterialType.GetMaterialType(entity.MaterialType);
                    query.Add(entity);
                }
                else if (!string.IsNullOrEmpty(entity.Content))
                {
                    query.Update(c => new object[]
                    {
                        c.Name == entity.Name,
                        c.Content == entity.Content
                    }, a => a.MaterialGuid == entity.MaterialGuid);
                }
                else
                {
                    query.Update(c=>new object[]
                    {
                        c.Name==entity.Name
                    },a=>a.MaterialGuid == entity.MaterialGuid );
                }
                

            }
            return new Result(true);
        }

        public static Result AddAndUpdateTxtMaterials(T_BAS_Materials entity, Guid materialGuid)
        {
            using (var query = Factory.CreateT_BAS_Materials())
            {
                if (entity.MaterialGuid == Guid.Empty)
                {
                    entity.MaterialGuid = materialGuid;
                    entity.MerchantGuid = RFrameGenerate.Common.CurrentManage.MerchantGuid;
                    entity.MaterialType = DictionaryConst.WeiXinAutoReply.MaterialType.GetMaterialType(entity.MaterialType);
                    query.Add(entity);
                }
               
            }
            return new Result(true);
        }

        

        /// <summary>
        /// delete function
        /// </summary>
        /// <param name="materialsGuid"></param>
        /// <returns></returns>
        public static Result DeleteMaterials(Guid materialsGuid)
        {
            using (var tran=new SqlRTransaction())
            {
                var querykeyword = Factory.CreateT_BAS_Keywords(tran);
                if(querykeyword.IsExist(a=>a.MaterialGuid==materialsGuid)==true)
                    return new Result(false,"关键字中使用了该素材,无法删除.");

                var query = Factory.CreateT_BAS_Materials(tran);
                query.Delete(c => c.MaterialGuid == materialsGuid);
            }
            return new Result(true);
        }
    }
}
