﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace RFrameGenerate.BLL.Member
{
    public class VipCouponManage
    {
        public static List<Model.T_VIP_VipCoupon> GetVIPCoupons(Guid? couponGuid)
        {
            if (couponGuid == null || couponGuid == Guid.Empty) return null;

            using (var query = Factory.CreateT_VIP_VipCoupon())
            {
                return query.GetList(m => m.MerchantGuid == Common.CurrentManage.MerchantGuid && m.CouponGuid == couponGuid);
            }
        }

        public static string GetVIPCouponsMemberLevels(Guid? couponGuid)
        {
            if (couponGuid == null || couponGuid == Guid.Empty) return string.Empty;

            var list = GetVIPCoupons(couponGuid);

            if (list == null || list.Count <= 0) return string.Empty;

            string guids = string.Empty;
            
            list.ForEach(m => {
                guids += (m.MemberLevelGuid + ",");
            });

            return guids;
        }

        public static List<Model.T_VIP_VipCoupon> GetVIPCouponsByMemberLevel(Guid memberLevel)
        {
            if (memberLevel == Guid.Empty) return new List<Model.T_VIP_VipCoupon>(0);

            using (var query = Factory.CreateT_VIP_VipCoupon())
            {
                return query.GetList(m=>m.MerchantGuid == Common.CurrentManage.MerchantGuid && m.MemberLevelGuid == memberLevel);
            }
        }

        public static bool IsUsingMemberLevel(Guid memberLevel)
        {
            using (var query = Factory.CreateT_VIP_VipCoupon())
            {
                return query.IsExist(m => m.MerchantGuid == Common.CurrentManage.MerchantGuid && m.MemberLevelGuid == memberLevel);
            }
        }
    }
}
