﻿using RFrameGenerate.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using Wechat.Model;
using RFramework.SQLQuery;
using weixinopen;
using Wechat;
using RFramework.SQLServer;
using RFramework.SQLQuery.SQLExpands;
using RFrameGenerate.Common;


namespace RFrameGenerate.BLL
{
    public class MemberManage
    {
        #region 系统函数请勿随意改,调用

        /// <summary>
        /// 根据openid获取绑定的会员
        /// </summary>
        /// <param name="openID"></param>
        /// <returns></returns>
        public static T_BAS_Member GetMemberByOpenID(string openID)
        {
            using (var query = Factory.CreateT_BAS_Member())
            {
                var member = query.GetFirstData(a => a.MemberOpenID == openID && a.MerchantGuid == RFrameGenerate.Common.CurrentManage.MerchantGuid);
                return member;
            }
        }

        public static T_BAS_Member GetMemberByOpenIDIsDist(string openID, Guid merGuid)
        {
            using (var query = Factory.CreateT_BAS_Member())
            {
                var member = query.GetFirstData(a => a.MemberOpenID == openID && a.IsDistributor == true && a.MerchantGuid == merGuid);
                return member;
            }
        }

        public static T_BAS_Member GetMemberByOpenID(string openID, Guid merchantGuid)
        {
            using (var query = Factory.CreateT_BAS_Member())
            {
                var member = query.GetFirstData(a => a.MemberOpenID == openID && a.MerchantGuid == merchantGuid, isFilterMerchant: false);
                return member;
            }
        }

        /// <summary>
        /// 根据openid获取绑定的会员
        /// </summary>
        /// <param name="openID"></param>
        /// <returns></returns>
        public static T_BAS_Member GetMemberByUnionID(string unionid)
        {
            using (var query = Factory.CreateT_BAS_Member())
            {
                var member = query.GetFirstData(a => a.UnionID == unionid);

                return member;
            }
        }

        /// <summary>
        /// 关注时添加用户,会自动获取用户信息
        /// 请勿随意改,调用
        /// </summary>
        /// <param name="openID"></param>
        public static T_BAS_Member UpdateMember(string openID, string oid)
        {
            try
            {
                T_BAS_Member member;
                using (var query = Factory.CreateT_BAS_Member())
                {
                    ReceiveUser user;
                    T_BAS_Merchants merch;
                    if (string.IsNullOrEmpty(oid) != true)
                    {
                        string appid = string.Empty;
                        merch = MerchantManage.GetMerchantByOriginalID(oid, out appid);
                        RFrameGenerate.Common.CurrentUser.SetMerchantGuid(merch.MerchantGuid);
                        RFrameGenerate.Common.CurrentUser.SetSMerchantGuid(merch.MerchantGuid);
                        if (merch == null)
                            merch = new T_BAS_Merchants();
                        try
                        {
                            user = WeiXinOpenRequest.GetUserInfo(openID, appid);
                        }
                        catch (Exception ex)
                        {
                            LogManage.Log("UpdateMember获取" + ex.Message + "," + ex.StackTrace);
                            user = new ReceiveUser() { };
                        }

                    }
                    else
                    {
                        merch = new T_BAS_Merchants();
                        user = new ReceiveUser();
                    }
                    member = query.GetFirstData(a => a.MerchantGuid == merch.MerchantGuid && a.MemberOpenID == openID);
                    if (member != null)
                    {
                        query.Update(a => new object[]
                        {
                            a.IsAccredited==true,
                            a.MemberNickName == user.nickname,
                            //a.UnionID == user.unionid,
                            a.HeadImgUrl == user.headimgurl,
                            //a.Sex == user.sex,
                            //a.City == user.city,
                            //a.Province == user.province,
                            //a.Country == user.country,
                            a.AccreditedTime == DateTimeHelper.UnixTimeToTime(user.subscribe_time),
                            a.MerchantGuid == merch.MerchantGuid,
                        },
                        b => b.MemberGuid == member.MemberGuid);



                    }
                    else
                    {
                        member = new T_BAS_Member()
                        {
                            MemberGuid = Guid.NewGuid(),
                            MemberOpenID = openID,
                            CreateDate = DateTime.Now,
                            IsAccredited = true,
                            MemberName = user.nickname,
                            MemberNickName = user.nickname,
                            UnionID = user.unionid,
                            HeadImgUrl = user.headimgurl,
                            //Sex = user.sex,
                            //City = user.city,
                            //Province = user.province,
                            Country = user.country,
                            MerchantGuid = merch.MerchantGuid,
                            Balance = 0,
                            AccreditedTime = DateTimeHelper.UnixTimeToTime(user.subscribe_time),
                            IsDistributor = false,
                            ExpenseTotal = 0,
                            ID = AutoCodeBLL.GetAutoMemeberCode(),
                        };
                        query.Add(member);
                    }
                    return member;
                }
            }
            catch
            {
                LogManage.Log("关注更新会员失败openID:" + openID);
                return null;
            }
        }

        public static void UpdateMemberIsAccredited(string openid, bool siaccredited)
        {
            using (var query = Factory.CreateT_BAS_Member())
            {
                query.Update(a => new object[] { a.IsAccredited == siaccredited }, b => b.MemberOpenID.SqlFunc(" MemberOpenID like '" + openid + "%'"));
            }
        }

        /// <summary>
        /// 关注时添加用户,会自动获取用户信息
        /// 请勿随意改,调用
        /// </summary>
        /// <param name="openID"></param>
        public static T_BAS_Member WeiXinHaiUpdateMember(string openID, string appid)
        {
            try
            {
                T_BAS_Member member;
                using (var query = Factory.CreateT_BAS_Member())
                {
                    ReceiveUser user;
                    T_BAS_Merchants merch;
                    if (string.IsNullOrEmpty(appid) != true)
                    {
                        merch = MerchantManage.GetMerchantByAppID(appid);
                        RFrameGenerate.Common.CurrentUser.SetMerchantGuid(merch.MerchantGuid);
                        RFrameGenerate.Common.CurrentUser.SetSMerchantGuid(merch.MerchantGuid);
                        if (merch == null)
                            merch = new T_BAS_Merchants();
                        try
                        {
                            user = WeiXinOpenRequest.GetUserInfo(openID, appid);
                        }
                        catch (Exception ex)
                        {
                            LogManage.Log("UpdateMember获取" + ex.Message + "," + ex.StackTrace);
                            user = new ReceiveUser() { };
                        }

                    }
                    else
                    {
                        merch = new T_BAS_Merchants();
                        user = new ReceiveUser();
                    }

                    member = query.GetFirstData(a => a.MemberOpenID == openID);
                    if (member != null)
                    {
                        query.Update(a => new object[]
                        {
                            a.IsAccredited==true,
                            a.MemberNickName == user.nickname,
                            //a.UnionID == user.unionid,
                            a.HeadImgUrl == user.headimgurl,
                            //a.Sex == user.sex,
                            //a.City == user.city,
                            //a.Province == user.province,
                            //a.Country == user.country,
                            a.AccreditedTime == DateTimeHelper.UnixTimeToTime(user.subscribe_time),
                            a.MerchantGuid == merch.MerchantGuid,
                        },
                        b => b.MemberOpenID == openID);
                    }
                    else
                    {
                        member = new T_BAS_Member()
                        {
                            MemberGuid = Guid.NewGuid(),
                            MemberOpenID = openID,
                            CreateDate = DateTime.Now,
                            IsAccredited = true,
                            MemberName = user.nickname,
                            MemberNickName = user.nickname,
                            UnionID = user.unionid,
                            HeadImgUrl = user.headimgurl,
                            Sex = user.sex,
                            City = user.city,
                            Province = user.province,
                            Country = user.country,
                            MerchantGuid = merch.MerchantGuid,
                            Balance = 0,
                            AccreditedTime = DateTimeHelper.UnixTimeToTime(user.subscribe_time),
                            IsDistributor = false,
                            ExpenseTotal = 0,
                            ID = AutoCodeBLL.GetAutoMemeberCode(),
                        };
                        query.Add(member);
                    }
                    return member;
                }
            }
            catch
            {
                return null;
            }
        }

        /// <summary>
        /// 关注时添加用户,会自动获取用户信息
        /// 请勿随意改,调用
        /// </summary>
        /// <param name="openID"></param>
        public static T_BAS_Member WebSNSUpdateMember(string openID, string access_token, string appid, string userid)
        {
            try
            {
                T_BAS_Member member;
                using (var query = Factory.CreateT_BAS_Member())
                {
                    ReceiveUser user;
                    //设置授权回调时登录的参数
                    //T_BAS_Merchants merch = MerchantManage.GetMerchantByAppID(appid);
                    T_BAS_Merchants merch = MerchantManage.GetMerchantByUserID(userid);
                    RFrameGenerate.Common.CurrentUser.SetMerchantGuid(merch.MerchantGuid);
                    RFrameGenerate.Common.CurrentUser.SetSMerchantGuid(merch.MerchantGuid);
                    RFrameGenerate.Common.CurrentUser.SetAppID(appid);
                    RFrameGenerate.Common.CurrentUser.SetMerchantUserID(merch.UserID);

                    if (merch == null)
                        merch = new T_BAS_Merchants();
                    try
                    {
                        user = WeiXinOpenRequest.GetSnsUserInfo(openID, access_token);
                    }
                    catch (Exception ex)
                    {
                        LogManage.Log("appid=" + appid + ",openID=" + openID + ",WebSNSUpdateMember代公众号拿粉丝信息:" + ex.Message + "," + ex.StackTrace);
                        user = new ReceiveUser() { };
                    }
                    member = query.GetFirstData(a => a.MerchantGuid == merch.MerchantGuid && a.MemberOpenID == openID);
                    if (member != null)
                    {
                        if (member.MemberNickName != user.nickname)
                        {
                            query.Update(a => new object[]
                                {
                                    a.MemberNickName == user.nickname,  
                                    a.UnionID == user.unionid,
                                    a.HeadImgUrl == user.headimgurl,
                                    a.Sex == user.sex,
                                    a.City == user.city,
                                    a.Province == user.province,
                                    a.Country == user.country,
                                },
                            b => b.MemberGuid == member.MemberGuid);
                        }
                    }
                    else
                    {
                        member = new T_BAS_Member()
                        {
                            MemberGuid = Guid.NewGuid(),
                            MemberOpenID = openID,
                            CreateDate = DateTime.Now,
                            MemberName = user.nickname,
                            MemberNickName = user.nickname,
                            UnionID = user.unionid,
                            HeadImgUrl = user.headimgurl,
                            Sex = user.sex,
                            City = user.city,
                            Province = user.province,
                            Country = user.country,
                            MerchantGuid = merch.MerchantGuid,
                            Balance = 0,
                            //AccreditedTime = DateTimeHelper.UnixTimeToTime(user.subscribe_time),
                            IsDistributor = false,
                            ExpenseTotal = 0,
                            IsAccredited = false,
                            ID = AutoCodeBLL.GetAutoMemeberCode(),
                        };
                        query.Add(member);
                    }
                    return member;
                }
            }
            catch (Exception ex)
            {
                LogManage.Log("授权或关注更新会员" + ex.Message);
                return null;
            }
        }


        /// <summary>
        /// 取消关注
        /// 请勿随意改,调用
        /// </summary>
        /// <param name="openID"></param>
        public static void Unsubscribe(string openID)
        {
            try
            {
                using (var query = Factory.CreateT_BAS_Member())
                {
                    query.Update(a => new object[]
                        {
                             a.IsAccredited==false,
                        },
                         b => b.MemberOpenID == openID);
                }
            }
            catch { }
        }

        #endregion

        public static List<T_BAS_Member> GetMemberPageList(GridModel gridModel, DateTime? dtFrom, DateTime? dtEnd, string MobilePhone, string MemberNickName)
        {

            using (var query = Factory.CreateT_BAS_Member())
            {
                if (dtFrom != null && dtEnd != null)
                    return query.GetPageList(gridModel, a => a.IsAccredited == true && a.CreateDate >= dtFrom.Value.Date && a.CreateDate <= dtEnd.Value.Date.AddDays(1).AddMilliseconds(-1) && a.MemberMobilePhone.SqlLike(MobilePhone) && a.MemberNickName.SqlLike(MemberNickName), true);
                else if (dtFrom != null && dtEnd == null)
                    return query.GetPageList(gridModel, a => a.IsAccredited == true && a.CreateDate >= dtFrom.Value.Date && a.MemberMobilePhone.SqlLike(MobilePhone) && a.MemberNickName.SqlLike(MemberNickName), true);
                else if (dtFrom == null && dtEnd != null)
                    return query.GetPageList(gridModel, a => a.IsAccredited == true && a.CreateDate <= dtEnd.Value.Date.AddDays(1).AddMilliseconds(-1) && a.MemberMobilePhone.SqlLike(MobilePhone) && a.MemberNickName.SqlLike(MemberNickName), true);
                else
                    return query.GetPageList(gridModel, a => a.IsAccredited == true && a.MemberMobilePhone.SqlLike(MobilePhone) && a.MemberNickName.SqlLike(MemberNickName), true);
            }
        }

        /// <summary>
        /// updata isdistributor
        /// </summary>
        /// <param name="memberGuid"></param>
        /// <returns></returns>
        public static Result UpdataIsDis(Guid memberGuid)
        {
            using (var query = Factory.CreateT_BAS_Member())
            {
                query.Update(c => new object[]
                {
                    c.IsDistributor == true,
                }, a => a.MemberGuid == memberGuid);
            }
            return new Result(true);
        }

        /// <summary>
        /// 根据guid获取会员
        /// </summary>
        /// <param name="memberGuid"></param>
        /// <returns></returns>
        public static T_BAS_Member GetMemberByGuid(Guid memberGuid)
        {
            using (var query = Factory.CreateT_BAS_Member())
            {
                return query.GetFirstData(a => a.MemberGuid == memberGuid, isFilterMerchant: false);
            }
        }

        /// <summary>
        /// 根据OrderGuid获取会员
        /// </summary>
        /// <param name="openID"></param>
        /// <returns></returns>
        public static T_BAS_Member GetMemberByOrderGuid(Guid orderGuid)
        {
            using (var tran = new SqlRTransaction())
            {
                var query = Factory.CreateT_BAS_Member(tran);
                var query_order = Factory.CreateT_BAS_Orders(tran);
                var model_order = query_order.GetFirstData(a => a.OrderGuid == orderGuid);
                return query.GetFirstData(a => a.MemberGuid == model_order.MemberGuid);
            }
        }

        public static List<T_BAS_Member> GetMemberByGuid()
        {
            using (var query = Factory.CreateT_BAS_Member())
            {
                return query.GetList(a => a.MerchantGuid == RFrameGenerate.Common.CurrentManage.MerchantGuid);
            }
        }
        /// <summary>
        /// 会员记录数
        /// </summary>
        /// <returns></returns>
        public static int GetCount(Guid distributionPropGuid)
        {
            //using (var query = Factory.CreateT_BAS_Member())
            //{
            //    return query.GetCount(a => a.MerchantGuid == merchantGuid && a.MemberGuid == memberGuid);
            //}

            using (var query = Factory.CreateProcedure())
            {
                return query.GetDistributionPropCount(distributionPropGuid);
            }
        }

        public static void EditSubmit(T_BAS_Member member)
        {
            using (var query = Factory.CreateT_BAS_Member())
            {
                if (member.MemberGuid != new Guid())
                {
                    //update
                    var membered = query.GetFirstData(s => s.MemberGuid == member.MemberGuid);
                    membered.MemberName = member.MemberName;
                    membered.MemberNickName = member.MemberNickName;
                    membered.MemberMobilePhone = member.MemberMobilePhone;
                    membered.CreateDate = membered.CreateDate;
                    query.Update(membered);
                }
                else
                {
                    //add
                    var membernew = new T_BAS_Member();
                    member.UpdateToEntity(membernew);
                    membernew.CreateDate = DateTime.Now;
                    query.Add(membernew);
                }
            }
        }
        /// <summary>
        /// 是否关注
        /// </summary>
        /// <param name="openID"></param>
        /// <returns></returns>
        public static bool IsFocus(string openID)
        {
            if (string.IsNullOrEmpty(openID))
                return false;
            return GetMemberByOpenID(openID) != null;
        }
        /// <summary>
        /// 同步微信关注者
        /// </summary>
        /// <returns></returns>
        public static Result WeiXinSync()
        {
            ThreadPool.QueueUserWorkItem(new WaitCallback((obj) =>
            {
                SendGetUser sendGetUser = new SendGetUser();
                var tran = new RFramework.SQLServer.SqlRTransaction();
                var queryMember = Factory.CreateT_BAS_Member(tran);
                //牺牲内存,提高性能
                var memberList = queryMember.GetList();
                //List<T_BAS_Member> memberAddList = new List<T_BAS_Member>();
                string next_openid = ParameterMagage.Current.GetParameter<string>(ParameterName.System_WeiXinUserSyncLastOpenID);
                string current_openid = string.Empty, total, count;
                string appid = RFrameGenerate.Common.CurrentManage.AppId;
                try
                {
                    //循环获取关注者列表
                    while (true)
                    {
                        //保存当前请求的openid
                        current_openid = next_openid;
                        var tempUser = WeiXinOpenRequest.GetUserList(out next_openid, out total, out count, appid, sendGetUser.ToJson());
                        //memberAddList.Clear();
                        //关注者列表本地处理
                        foreach (var wx in tempUser)
                        {
                            //判断数据库是否存在
                            if (memberList.Exists(a => a.MemberOpenID == wx.openid) != true)
                            {
                                ReceiveUser user = WeiXinOpenRequest.GetUserInfo(wx.openid, appid);
                                //memberAddList.Add(new T_BAS_Member()
                                queryMember.Add(new T_BAS_Member()
                                {
                                    MemberOpenID = wx.openid,
                                    UnionID = user.unionid,
                                    HeadImgUrl = user.headimgurl,
                                    Province = user.province,
                                    City = user.city,
                                    Country = user.country,
                                    Sex = user.sex,
                                    MemberNickName = user.nickname,
                                    MemberGuid = Guid.NewGuid(),
                                    CreateDate = DateTime.Now,
                                    IsAccredited = true,
                                    EntityState = EntityStates.ToBeAdd,

                                    MemberName = string.Empty,
                                    MemberMobilePhone = string.Empty,
                                });
                            }
                        }
                        //添加到数据库
                        //queryMember.AddList(memberAddList);

                        sendGetUser.next_openid = next_openid;
                        if (next_openid.Trim() == string.Empty)
                            break;
                    }

                }
                catch (Exception ex)
                {
                    LogManage.Log("[WeiXinSync同步关注列表失败]" + ex.Message);
                }
                finally
                {
                    ParameterMagage.Current.UpdateParameter(ParameterName.System_WeiXinUserSyncLastOpenID, current_openid);
                    ParameterMagage.Current.Save();
                    GC.Collect();
                    tran.Dispose();
                }
            }));

            return new Result(true);
        }

        #region 前台
        /// <summary>
        /// 只更新会员名,手机,性别,城市,省,生日,微信号
        /// </summary>
        /// <param name="member"></param>
        public static Result Update(T_BAS_Member member)
        {
            try
            {
                using (var query = Factory.CreateT_BAS_Member())
                {
                    query.Update(a => new object[]
                {
                    a.MemberName==member.MemberName,
                    a.MemberMobilePhone==member.MemberMobilePhone,
                    a.Sex==member.Sex,
                    a.City==member.City,
                    a.Province==member.Province,
                    a.Birthday==member.Birthday,
                    a.Area==member.Area,
                    a.WeChatName==member.WeChatName,
                }, b => b.MemberGuid == member.MemberGuid);
                }
                return new Result(true);
            }
            catch (Exception ex)
            {
                return new Result(false, ex.Message);
            }
        }
        /// <summary>
        /// 更新分销推荐人
        /// </summary>
        /// <param name="memberGuid"></param>
        /// <param name="DID">推荐人的did</param>
        /// <returns></returns>
        public static Result UpdateDID(string openID, Guid? DID)
        {
            if (DID == Guid.Empty)
            {
                DID = null;
                LogManage.Log("锁定关系时,DID为空,openid:" + openID);
            }
            try
            {
                using (var query = Factory.CreateT_BAS_Member())
                {
                    var mem = query.GetFirstData(a => a.MemberOpenID == openID);
                    if (mem != null && mem.IsDistributor != true)
                    {
                        var isRefrshDID = ParameterMagage.GetDistributionLockRelation() == DictionaryConst.DistributionLockRelation.Last;
                        if (isRefrshDID == true)
                        {
                            query.Update(a => new object[] { a.DID == DID }, b => b.MemberOpenID == openID);
                        }
                        else
                        {
                            if (mem.DID == null)
                            {
                                query.Update(a => new object[] { a.DID == DID }, b => b.MemberOpenID == openID);
                            }
                        }
                    }

                    return new Result(true);
                }
            }
            catch (Exception ex)
            {
                throw ex;
            }
        }
        /// <summary>
        /// 获取分销人的did
        /// </summary>
        /// <param name="openID"></param>
        /// <returns></returns>
        public static Guid? GetParentDID(string openID)
        {
            using (var query = Factory.CreateT_BAS_Member())
            {
                var mem = query.GetFirstData(a => a.MemberOpenID == openID);
                if (mem != null)
                    return mem.DID;
                else
                    return null;
            }
        }

        public static MemberInfo GetMemberInfo(string openid)
        {
            using (var query = Factory.CreateProcedure())
            {
                return query.GetMemberInfo(openid);
            }
        }

        /// <summary>
        /// 根据会员编号获取分销会员属性
        /// </summary>
        /// <param name="MemberGuid">MemberGuid</param>
        /// <returns></returns>
        public static CurrnetMemberInfo GetMemberRelation(string openid, string userID)
        {
            using (var query = Factory.CreateProcedure())
            {
                return query.GetMemberRelation(openid, userID);
            }
        }
        #endregion

        #region add by Panwp 营销活动

        public static PageList<R> GetMembers<R>(GridModel gridModel, string name, Func<T_BAS_Member, R> selectorfield)
        {
            using (var sql = new SqlModel<T_BAS_Member>())
            {
#if DEBUG
                if (string.IsNullOrEmpty(name))
                    return sql.SqlPage(selectorfield, gridModel.page, gridModel.rows)
                                .SqlWhere(m => m.MerchantGuid == CurrentManage.MerchantGuid)
                                .ToPageList();
                else
                    return sql.SqlPage(selectorfield, gridModel.page, gridModel.rows)
                                .SqlWhere(m => m.MemberNickName.SqlLike(name) && m.MerchantGuid == CurrentManage.MerchantGuid)
                                .ToPageList();

#else
                if (string.IsNullOrEmpty(name))
                    return sql.SqlPage(selectorfield, gridModel.page, gridModel.rows).SqlOrderBy(a => a.MemberGuid)
                              .SqlWhere(m => m.IsAccredited == true && m.MerchantGuid == CurrentManage.MerchantGuid)
                              .ToPageList();
                else
                    return sql.SqlPage(selectorfield, gridModel.page, gridModel.rows).SqlOrderBy(a => a.MemberGuid)
                         .SqlWhere(m => m.SqlLike(name) && m.IsAccredited == true && m.MerchantGuid == CurrentManage.MerchantGuid)
                         .ToPageList();
#endif
            }
        }

        public static List<R> GetMembersByGuid<R>(Guid[] membersGuid, Func<T_BAS_Member, R> selectorfield)
        {
            using (var sql = new SqlModel<T_BAS_Member>())
            {
                return sql.SqlSelect(selectorfield)
                          .SqlWhere(m => m.IsAccredited == true && m.MerchantGuid == CurrentManage.MerchantGuid)
                          .ToList();
            }
        }

        #endregion



        #region 测试充值 (临时修改使用 Bing)
        /// <summary>
        /// 测试充值 (临时修改使用 Bing)
        /// </summary>
        /// <param name="memberName"></param>
        /// <returns></returns>
        public static Result RechBalanceTest(string memberName, decimal money)
        {
            using (var tran = new SqlRTransaction())
            {
                var que = SQLModelFactory.CreateSqlModel<T_BAS_Member>(tran);
                try
                {
                    que.SqlUpdate(c => new object[]{
                        c.Balance== money,
                        //c.Amount== money
                }, c => c.MemberName.SqlLike(memberName) /*&& c.SMerchantGuid == CurrentManage.MerchantGuid*/);
                    return new Result(true);
                }
                catch (Exception ex)
                {
                    return new Result(false, string.Format("测试充值-失败：{0}", ex.Message));
                }
            }
        }

        #endregion

        public static Result DelRel(Guid id)
        {
            using (var tran = new SqlRTransaction())
            {
                var querymem = Factory.CreateT_BAS_Member(tran);
                var mem = querymem.GetFirstData(a => a.MemberGuid == id);
                if (mem != null)
                {
                    tran.BeginTransaction();
                    querymem.Update(a => new object[] { a.DID == null }, b => b.MemberGuid == mem.MemberGuid);
                    MemberBindMerchantManage.DeleteRel(CurrentManage.MerchantUserID, mem.MemberOpenID);
                    tran.Commit();
                }
            }
            return new Result(true);
        }

    }

}
