﻿using RFrameGenerate.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using RFramework.SQLServer;

namespace RFrameGenerate.BLL
{
    public class MenuManage
    {
        public static T_WX_WeChatMenu GetCurrentMenu()
        {
            using (var tran = new SqlRTransaction())
            {
                var query = Factory.CreateT_WX_WeChatMenu(tran);
                var queryZMer = Factory.CreateT_BAS_Merchants(tran);
                var mer = queryZMer.GetFirstData(a => a.MerchantGuid == RFrameGenerate.Common.CurrentManage.MerchantGuid);
                if (mer.WeChatMenuGuid != null)
                    return query.GetFirstData(a => a.WeChatMenuGuid == mer.WeChatMenuGuid, false);
                else
                    return new T_WX_WeChatMenu() { WeChatMenuGuid = Guid.NewGuid() };
            }
        }
        public static void UpdateMenu(T_WX_WeChatMenu menu)
        {
            using (var tran=new SqlRTransaction())
            {
                var query = Factory.CreateT_WX_WeChatMenu(tran);
                var menudb = query.GetFirstData(a => a.WeChatMenuGuid == menu.WeChatMenuGuid);
                var queryZMer = Factory.CreateT_BAS_Merchants(tran);
                tran.BeginTransaction();
                if (menudb == null)
                {                   
                    menu.WeChatMenuGuid = Guid.NewGuid();
                    query.Add(menu);

                    queryZMer.Update(a => new object[] { a.WeChatMenuGuid == menu.WeChatMenuGuid }, b => b.MerchantGuid == RFrameGenerate.Common.CurrentManage.MerchantGuid);
                }
                else
                {
                    menu.WeChatMenuGuid = menudb.WeChatMenuGuid;
                    query.Update(menu);
                }
                tran.Commit();
            }
        }
    }
}
