﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using RFrameGenerate.Model;
using RFrameGenerate.DAL;
using RFramework.SQLServer;
using RFrameGenerate.DAL.Enums;

namespace RFrameGenerate.BLL
{
    public class NoticeManage
    {
        public static List<T_ST_Notice> GetPageList(GridModel gridModel)
        {
            using (var query = Factory.CreateT_ST_Notice())
            {
                return query.GetPageList(gridModel,null,false,b=>b.CreateDate,OrderMethods.DESC);
            }
        }

        public static Result Save(Guid? noticeGuid, string title, string content, bool isenable)
        {
            using (var query = Factory.CreateT_ST_Notice())
            {
                if (isenable == true)
                    query.Update(a => new object[] { a.IsEnable == false }, b => b.MerchantGuid == RFrameGenerate.Common.CurrentManage.MerchantGuid);

                if (noticeGuid == null)
                {
                    query.Add(new T_ST_Notice() { IsEnable = isenable, CreateDate = DateTime.Now, Content = content, Title = title, NoticeGuid = Guid.NewGuid(), MerchantGuid = RFrameGenerate.Common.CurrentManage.MerchantGuid });
                }
                else
                {
                    query.Update(a => new object[] { a.Title == title, a.Content == content, a.IsEnable == isenable }, b => b.NoticeGuid == noticeGuid);
                }
                return new Result(true);
            }
        }
        public static Result Del(Guid noticeGuid)
        {
            using (var query = Factory.CreateT_ST_Notice())
            {
                query.Delete(a => a.NoticeGuid == noticeGuid);
                return new Result(true);
            }
        }
        public static Result EnableChange(Guid noticeGuid, bool isenable)
        {
            using (var query = Factory.CreateT_ST_Notice())
            {
                if (isenable == true)
                    query.Update(a => new object[] { a.IsEnable == false }, b => b.MerchantGuid == RFrameGenerate.Common.CurrentManage.MerchantGuid);

                query.Update(a => new object[] { a.IsEnable == isenable }, b => b.NoticeGuid == noticeGuid);
                return new Result(true);
            }
        }

        /// <summary>
        /// 获取公告信息
        /// </summary>
        /// <returns></returns>
        public static NoticeInfo GetNoticeText()
        {
            using (var query = Factory.CreateT_ST_Notice())
            {
                var model = query.GetFirstData(a => a.MerchantGuid == RFrameGenerate.Common.CurrentManage.MerchantGuid && a.IsEnable == true);
                if (model != null)
                    return new NoticeInfo() { Content = model.Content, IsEnable=true };
                else
                    return new NoticeInfo() { IsEnable = false };
            }
        }
    }

    public class NoticeInfo
    {
        public bool IsEnable { get; set; }
        public string Content { get; set; }
    }
}
