﻿using RFrameGenerate.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace RFrameGenerate.BLL
{
    public class OrderDetailsManage
    {
        /// <summary>
        /// 根据订单GUID获取订单明细
        /// </summary>
        /// <param name="guid"></param>
        /// <returns></returns>
        public static List<T_BAS_OrderDetails> GetListByOrder(Guid guid)
        {
            using (var query = Factory.CreateT_BAS_OrderDetails())
            {
                return query.GetList(a=>a.OrderGuid==guid,isFilterMerchant:false);
            }
        }

        /// <summary>
        /// 根据订单GUID获取订单明细、佣金
        /// </summary>
        /// <param name="guid"></param>
        /// <returns></returns>
        public static Result GetListByOrder(Guid guid, ref List<T_BAS_OrderDetails> list)
        {
            using (var query = Factory.CreateT_BAS_OrderDetails())
            {
                list= query.GetList(a => a.OrderGuid == guid);
                if (list.Count > 0)
                {
                    return new Result(true);
                }
                else
                    return new Result(false);
            }
        }

        public static T_BAS_OrderDetails GetEntity(Guid orderDetailGuid)
        {
            using (var query = Factory.CreateT_BAS_OrderDetails())
            {
                return query.GetDataByGuid(orderDetailGuid);
            } 
        }
    }
}
