﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using RFrameGenerate.BLL.Config;
using RFrameGenerate.Common;
using RFrameGenerate.DAL;
using RFrameGenerate.DAL.Enums;
using RFramework.SQLQuery;

namespace RFrameGenerate.BLL
{
    public class AutoCodeBLL
    {
        public static string GetAutoRoleCode()
        {
            var rule = WebConfig.ReadConfig(WebConfig.AutoCodeFormat.RoleCode.GetRemarkValue());
            string lastCode = string.Empty;
            using (var query = Factory.CreateT_ST_Role())
            {
                var front = AutoCodeGenerate.GetAutoCodeCondition(new List<KeyValuePair<string, string>>(), rule);
                var user = query.GetFirstData(s => s.RoleCode.SqlLike(front), true, s => s.RoleCode, OrderMethods.DESC);
                if (user != null)
                    lastCode = user.RoleCode;
            }
            return AutoCodeGenerate.GetNewAutoCode(lastCode, rule);
        }


        public static string GetAutoMemeberCode()
        {
            var rule = WebConfig.ReadConfig(WebConfig.AutoCodeFormat.MemberCode.GetRemarkValue());
            string lastCode = string.Empty;
            using (var query = Factory.CreateT_BAS_Member())
            {
                var front = AutoCodeGenerate.GetAutoCodeCondition(new List<KeyValuePair<string, string>>(), rule);
                var user = query.GetFirstData(s => s.ID.SqlLike(front) && s.MerchantGuid == CurrentManage.MerchantGuid , true, s => s.ID, OrderMethods.DESC);
                if (user != null)
                    lastCode = user.ID;
            }
            return AutoCodeGenerate.GetNewAutoCode(lastCode, rule);
        }
    }
}
