﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace RFrameGenerate.BLL.Config
{
    public class AutoCodeGenerate
    {
        /// <summary>
        /// 获取自动编号
        /// </summary>
        /// <param name="lastCode">当前最大编号</param>
        /// <param name="autoCodeRule">自动编号规则<</param>
        /// <param name="parameterValueList">参数值</param>
        /// <returns>返回自动编号</returns>
        public static String GetNewAutoCode(string lastCode, string autoCodeRule, List<KeyValuePair<string, string>> parameterValueList)
        {
            string value = string.Empty;
            int startIndex = -1;
            int endIndex = -1;
            string fileString = string.Empty;
            while (autoCodeRule.Contains("[") == true)
            {
                startIndex = autoCodeRule.IndexOf("[");
                endIndex = autoCodeRule.IndexOf("]");
                fileString = autoCodeRule.Substring(startIndex + 1, endIndex - startIndex - 1);

                if (fileString.ToUpper() == "DATE")
                    value = DateTime.Now.ToString("yyyyMMdd");
                else if (fileString.ToUpper() == "TIME")
                    value = DateTime.Now.ToString("HHmmss");
                else if (fileString.ToUpper().Contains("SN:") == true)
                {
                    long maxID = 1;
                    int len = Convert.ToInt32(fileString.Replace("SN:", ""));
                    try
                    {
                        string fileValue = lastCode;
                        if (fileValue.Length > len)
                            maxID = Convert.ToInt64(fileValue.Substring(fileValue.Length - len)) + 1;
                        else
                            maxID = Convert.ToInt64(fileValue) + 1;
                    }
                    catch { maxID = 1; }
                    value = string.Format("{0:D" + len + "}", maxID);
                }
                else if (fileString.ToUpper().Contains("RN:") == true)
                {
                    int len = Convert.ToInt32(fileString.Replace("RN:", ""));
                    Random r = new Random();
                    value = string.Empty;
                    for (; len > 0; len--)
                        value += r.Next(9);
                }
                else
                {
                    if (fileString.Contains(":") != true)
                    {
                        try
                        {
                            value = parameterValueList.Where(p => p.Key == fileString).FirstOrDefault().Value.ToString();
                        }
                        catch { value = string.Empty; }
                    }
                    else
                    {
                        try
                        {
                            int index = fileString.IndexOf(":");
                            value = parameterValueList.Where(p => p.Key == fileString.Substring(0, index)).FirstOrDefault().Value.ToString();
                            string[] aa = fileString.Substring(index + 1).Split('-');
                            value = value.Substring(Convert.ToInt32(aa[0]) - 1, Convert.ToInt32(aa[1]) - Convert.ToInt32(aa[0]) + 1);
                        }
                        catch { value = string.Empty; }
                    }
                }
                autoCodeRule = autoCodeRule.Substring(0, startIndex) + value + autoCodeRule.Substring(endIndex + 1);
            }
            return autoCodeRule;
        }

        public static String GetNewAutoCode(string lastCode, string autoCodeRule)
        {
            return GetNewAutoCode(lastCode, autoCodeRule, null);
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="autoCodeRule"></param>
        /// <returns></returns>
        public static String GetAutoCodeCondition(string autoCodeRule)
        {
            return GetAutoCodeCondition(null, autoCodeRule);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="fileValue">字段值</param>
        /// <param name="autoCodeRule">自动编号规则</param>
        /// <returns></returns>
        public static String GetAutoCodeCondition(List<KeyValuePair<string, string>> allValue, string autoCodeRule)
        {
            string value = string.Empty;
            int startIndex = -1;
            int endIndex = -1;
            string fileString = string.Empty;
            while (autoCodeRule.Contains("[") == true)
            {
                startIndex = autoCodeRule.IndexOf("[");
                endIndex = autoCodeRule.IndexOf("]");
                fileString = autoCodeRule.Substring(startIndex + 1, endIndex - startIndex - 1);

                if (fileString.ToUpper() == "DATE")
                    value = DateTime.Now.ToString("yyyyMMdd");
                else if (fileString.ToUpper() == "TIME")
                    value = "______";
                else if (fileString.ToUpper().Contains("SN:") == true || fileString.ToUpper().Contains("RN:") == true)
                {
                    int len = Convert.ToInt32(fileString.Replace("SN:", "").Replace("RN:", ""));
                    value = string.Empty;
                    for (; len > 0; len--)
                        value += "_";
                }
                else
                {
                    if (fileString.Contains(":") != true)
                    {
                        value = allValue.Where(p => p.Key == fileString).FirstOrDefault().Value.ToString();
                    }
                    else
                    {
                        try
                        {
                            int index = fileString.IndexOf(":");
                            string[] aa = fileString.Substring(index + 1).Split('-');
                            int len = Convert.ToInt32(aa[1]) - Convert.ToInt32(aa[0]) + 1;
                            value = allValue.Where(p => p.Key == fileString.Substring(0, index)).FirstOrDefault().Value.ToString();
                            value = value.Substring(Convert.ToInt32(aa[0]) - 1, Convert.ToInt32(aa[1]) - Convert.ToInt32(aa[0]) + 1);
                        }
                        catch { value = string.Empty; }
                    }
                }
                autoCodeRule = autoCodeRule.Substring(0, startIndex) + value + autoCodeRule.Substring(endIndex + 1);
            }
            return autoCodeRule;
        }
    }
}
