﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
/*
 *权限码使用说明,PCode下const字段和嵌套类为父级权限,嵌套类中的const字段为子级权限
 * 只能包含const字段和嵌套类,且必须添加Remark属性
 */
namespace System
{
    /// <summary>
    /// 权限码
    /// </summary>
    public class PCode
    {
        /// <summary>
        /// 无权限限制
        /// </summary>
        [Remark("无权限制")]
        public const string NoPermission = "1";
        /// <summary>
        /// 系统管理
        /// </summary>
        [Remark("系统管理", "100")]
        public class SystemManage
        {
            /// <summary>
            /// 用户角色管理
            /// </summary>
            [Remark("用户角色管理")]
            public const string UserRole = "100101";
            /// <summary>
            /// 角色权限管理
            /// </summary>
            [Remark("角色权限管理")]
            public const string RolePermission = "100102";
        }

        /// <summary>
        /// 首页
        /// </summary>
        [Remark("首页")]
        public const string IndexPage = "2";

        /// <summary>
        /// 商品管理
        /// </summary>
        [Remark("商品管理", "200")]
        public class ProductManage
        {
            /// <summary>
            /// 商品管理
            /// </summary>
            [Remark("商品管理")]
            public const string ProductIndex = "200101";
            /// <summary>
            /// 商品分类
            /// </summary>
            [Remark("商品分类")]
            public const string ProductCategorys = "200102";
            /// <summary>
            /// 商品类型
            /// </summary>
            [Remark("商品类型")]
            public const string ProductType = "200103";
        }

        /// <summary>
        /// 供货管理
        /// </summary>
        [Remark("供货管理", "300")]
        public class SupplyManage
        {
            /// <summary>
            /// 下级商品库
            /// </summary>
            [Remark("下级商品库")]
            public const string SupplyIndex = "300101";
            /// <summary>
            /// 代理分组
            /// </summary>
            [Remark("代理分组")]
            public const string LowerAgentList = "300102";
            /// <summary>
            /// 下级代理
            /// </summary>
            [Remark("下级代理")]
            public const string AgentGroupList = "300103";

            /// <summary>
            /// 代理规则
            /// </summary>
            [Remark("代理规则")]
            public const string AgentRuleIndex = "300104";

            /// <summary>
            /// 代理升级规则
            /// </summary>
            [Remark("代理升级规则")]
            public const string AgentComUpRule = "300105";

            /// <summary>
            /// 代理商申请
            /// </summary>
            [Remark("代理商申请")]
            public const string AgentApply = "300106";

            /// <summary>
            /// 代理商审核
            /// </summary>
            [Remark("代理商审核")]
            public const string AgentAudit = "300107";

            /// <summary>
            /// 代理佣金
            /// </summary>
            [Remark("代理佣金")]
            public const string AgentCommission = "300108";

            /// <summary>
            /// 代理佣金(总部)
            /// </summary>
            [Remark("代理佣金")]
            public const string AgentCommissionHq = "300109";

            /// <summary>
            /// 代理提现
            /// </summary>
            [Remark("代理提现")]
            public const string AgentWithDraw = "300110";

            /// <summary>
            /// 代理商佣金审核提现(总部)
            /// </summary>
            [Remark("代理商佣金审核提现")]
            public const string AgentWithDrawHq = "300111";

            /// <summary>
            /// 代理商订单利润明细
            /// </summary>
            [Remark("代理商订单利润明细")]
            public const string AgentTradingProfit = "300112";

            /// <summary>
            /// 代理商分组商品列表(总部)
            /// </summary>
            [Remark("代理分组商品列表")]
            public const string AgentGroupProducts= "300113";

            /// <summary>
            /// 分组商品列表 
            /// </summary>
            [Remark("分组商品列表")]
            public const string AgentGroupProductHq = "300114";

            /// <summary>
            /// 代理分组商品列表 
            /// </summary>
            [Remark("代理分组商品列表")]
            public const string AgentGroupProductSub = "300115";

             /// <summary>
            /// 代理预存流水 
            /// </summary>
            [Remark("代理预存流水")]
            public const string AgentAccount = "300116";

            
        }

        /// <summary>
        /// 交易管理
        /// </summary>
        [Remark("交易管理", "400")]
        public class TradeManage
        {
            /// <summary>
            /// 订单列表
            /// </summary>
            [Remark("订单列表")]
            public const string TradeIndex = "400101";
            /// <summary>
            /// 退款申请
            /// </summary>
            [Remark("退款申请")]
            public const string RefundApplys = "400102";
            /// <summary>
            /// 余额提现
            /// </summary>
            [Remark("余额提现")]
            public const string Balance = "400103";
        }
        /// <summary>
        /// 分销管理
        /// </summary>
        [Remark("分销管理", "500")]
        public class DistributionManage
        {
            /// <summary>
            /// 分销设置
            /// </summary>
            [Remark("分销设置")]
            public const string DistributionSet = "500101";
            /// <summary>
            /// 分销订单
            /// </summary>
            [Remark("分销订单")]
            public const string DistributionOrder = "500102";
            /// <summary>
            /// 分销会员
            /// </summary>
            [Remark("分销会员")]
            public const string DistributionMember = "500103";
            /// <summary>
            /// 分销销售排行
            /// </summary>
            [Remark("分销销售排行")]
            public const string DistributionSort = "500104";
            /// <summary>
            /// 佣金设置
            /// </summary>
            [Remark("佣金设置")]
            public const string CommissionSet = "500105";
            /// <summary>
            /// 提现管理
            /// </summary>
            [Remark("提现管理")]
            public const string WithdrawalMge = "500106";
            /// <summary>
            /// 分销贡献榜
            /// </summary>
            [Remark("分销贡献榜")]
            public const string Contribution = "500107";
        }
        /// <summary>
        /// 销售活动设置
        /// </summary>
        [Remark("销售活动设置", "600")]
        public class MarketingManage
        {
            /// <summary>
            /// 营销活动设置
            /// </summary>
            [Remark("营销活动设置")]
            public const string MarketingSet = "600101";
            /// <summary>
            /// 店铺优惠券
            /// </summary>
            [Remark("店铺优惠券")]
            public const string Coupon = "600102";
            /// <summary>
            /// 一元夺宝
            /// </summary>
            [Remark("一元夺宝", "600103")]
            public class CrowdfundingManage
            {
                /// <summary>
                /// 商品管理
                /// </summary>
                [Remark("商品管理")]
                public const string ProductCrowdProduct = "600103101";
                /// <summary>
                /// 首页幻灯片
                /// </summary>
                [Remark("首页幻灯片")]
                public const string ProductCrowdSlide = "600103102";
                /// <summary>
                /// 中奖管理
                /// </summary>
                [Remark("中奖管理")]
                public const string ProductCrowdWinning = "600103103";
            }

            /// <summary>
            /// 会员等级
            /// </summary>
            [Remark("会员等级", "600104")]
            public const string MemberLevel = "600104";

            /// <summary>
            /// 会员折扣
            /// </summary>
            [Remark("会员折扣", "600105")]
            public const string ProductDiscount = "600105";
        }
        /// <summary>
        /// 物流管理
        /// </summary>
        [Remark("物流管理", "700")]
        public class LogisticsManage
        {
            /// <summary>
            /// 运费模板管理
            /// </summary>
            [Remark("运费模板管理")]
            public const string LogisticsTemplate = "700101";
        }
        /// <summary>
        /// 店铺装修
        /// </summary>
        [Remark("店铺装修", "800")]
        public class DIVShopManage
        {
            /// <summary>
            /// 页面管理
            /// </summary>
            [Remark("页面管理")]
            public const string Index = "800101";
            [Remark("分销定义")]
            public const string Distribution = "800102";
        }
        /// <summary>
        /// 微信设置
        /// </summary>
        [Remark("微信设置", "900")]
        public class WeiXinManage
        {
            /// <summary>
            /// 微信授权
            /// </summary>
            [Remark("微信授权")]
            public const string Authorization = "900101";
            /// <summary>
            /// 消息模板设置
            /// </summary>
            [Remark("消息模板设置")]
            public const string MessageTemplate = "900102";
            /// <summary>
            /// 关注时欢迎消息
            /// </summary>
            [Remark("关注时欢迎消息")]
            public const string WelcomeMsg = "900103";
            /// <summary>
            /// 默认回复
            /// </summary>
            [Remark("默认回复")]
            public const string DefaultReply = "900104";
            /// <summary>
            /// 关键词回复
            /// </summary>
            [Remark("关键词回复")]
            public const string KeywordReply = "900105";
            /// <summary>
            /// 素材管理
            /// </summary>
            [Remark("素材管理")]
            public const string MaterialsMge = "900106";
            /// <summary>
            /// 微信分享设置
            /// </summary>
            [Remark("微信分享设置")]
            public const string ShareDesc = "900107";
            /// <summary>
            /// 自定义菜单
            /// </summary>
            [Remark("自定义菜单")]
            public const string Menu = "900108";
        }
        /// <summary>
        /// 系统设置
        /// </summary>
        [Remark("系统设置", "1000")]
        public class SystemStoreManage
        {
            /// <summary>
            /// 店铺设置
            /// </summary>
            [Remark("店铺设置")]
            public const string StoreSetting = "1000101";
            /// <summary>
            /// 公告管理
            /// </summary>
            [Remark("公告管理")]
            public const string Notice = "1000102";
            /// <summary>
            /// 客服系统
            /// </summary>
            [Remark("客服系统")]
            public const string CustomerServices = "1000103";
            /// <summary>
            /// 支付方式
            /// </summary>
            [Remark("支付方式")]
            public const string PayWays = "1000104";
            /// <summary>
            /// 发货地址管理
            /// </summary>
            [Remark("发货地址管理")]
            public const string Address = "1000105";
            /// <summary>
            /// 参数管理
            /// </summary>
            [Remark("参数管理")]
            public const string ParameterSetting = "1000106";
            /// <summary>
            /// 绑定云平台
            /// </summary>
            [Remark("绑定云平台")]
            public const string WeiXinHai = "1000107";
        }

        /// <summary>
        /// 会员管理
        /// </summary>
        [Remark("会员管理", "1100")]
        public class MemberManage
        {
            /// <summary>
            /// 会员管理
            /// </summary>
            [Remark("会员管理")]
            public const string MemberIndex = "1100101";
        }
        /// <summary>
        /// 分销类目
        /// </summary>
        [Remark("分销类目", "1200")]
        public class CategoryManage
        {
            /// <summary>
            /// 类目管理
            /// </summary>
            [Remark("类目管理")]
            public const string Category = "1200101";
        }
    }
}