﻿using RFrameGenerate.BLL.SystemParameters;
using RFrameGenerate.DAL;
using RFrameGenerate.DAL.Interface;
using RFrameGenerate.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace RFrameGenerate.BLL
{
    /// <summary>
    /// 参数管理类/有缓存
    /// </summary>
    public sealed class ParameterMagage : ParameterConst
    {
        private ParameterMagage()
        {
            Refresh();
        }
        /// <summary>
        /// 刷新参数
        /// </summary>
        public void Refresh()
        {
            using (IQuery<T_SYS_Parameter> query = Factory.CreateT_SYS_Parameter())
            {
                ListParameter = query.GetList();
            }
        }
        public List<T_SYS_Parameter> ListParameter;
        /// <summary>
        /// 当前参数管理
        /// </summary>
        public static ParameterMagage Current = new ParameterMagage();
        /// <summary>
        /// 根据参数名获取参数
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="parameterName"></param>
        /// <returns></returns>
        public T GetParameter<T>(string parameterName)
        {
            T_SYS_Parameter parameter = GetParameter(parameterName);
            if (parameter != null)
            {
                if (parameter.ParameterValue == null)
                {
                    return default(T);
                    //throw new Exception(string.Format("参数名为{0}的值为null", parameterName));
                }

                return (T)Convert.ChangeType(parameter.ParameterValue, typeof(T));
            }
            else
            {
                if (typeof(T) == typeof(string))
                    return (T)Convert.ChangeType("", typeof(T));
                else
                    return default(T);
                //throw new Exception(string.Format("不存在参数{0}", parameterName));
            }
        }
        /// <summary>
        /// 根据参数名获取参数
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="parameterName"></param>
        /// <returns></returns>
        public T_SYS_Parameter GetParameter(string parameterName)
        {
            if (ListParameter == null)
                Refresh();

            return ListParameter.Where(a => a.ParameterName == parameterName && a.MerchantGuid == Common.CurrentManage.MerchantGuid).FirstOrDefault();

        }
        /// <summary>
        /// 在缓存中修改参数
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="parameterName"></param>
        /// <param name="value"></param>
        public void UpdateParameter<T>(string parameterName, T value)
        {
            if (ListParameter == null)
                Refresh();

            T_SYS_Parameter parameter = ListParameter.Where(a => a.ParameterName == parameterName).FirstOrDefault();
            if (parameter != null)
            {
                parameter.ParameterValue = value == null ? string.Empty : value.ToString();
                parameter.EntityState = EntityStates.ToBeUpdated;
            }
            else
            {
                parameter = new T_SYS_Parameter()
                {
                    ParameterGuid = Guid.NewGuid(),
                    EntityState = EntityStates.ToBeAdd,
                    ParameterName = parameterName,
                    ParameterValue = value == null ? string.Empty : value.ToString(),
                    ParameterDescription = "",
                    ParameterType = 1
                };
                ListParameter.Add(parameter);
            }
        }
        /// <summary>
        /// 保存参数到数据库
        /// </summary>
        public bool Save()
        {
            if (ListParameter == null)
            {
                Refresh();
                return false;
            }
            else
            {
                using (IQuery<T_SYS_Parameter> query = Factory.CreateT_SYS_Parameter())
                {
                    query.UpdateList(ListParameter);
                }
                return true;
            }
        }


        #region 自动回复参数管理
        public static string GetTxt1()
        {
            using (var query = Factory.CreateT_SYS_Parameter())
            {
                var para = query.GetFirstData(a => a.ParameterName == AutoReplyRule.ConstRuleName.AutoReply1 && a.MerchantGuid == RFrameGenerate.Common.CurrentManage.MerchantGuid);
                if (para == null)
                {
                    return string.Empty;
                }
                return para.ParameterValue;
            }
        }
        public static void SetTxt1(string txt)
        {
            using (var query = Factory.CreateT_SYS_Parameter())
            {
                if (query.IsExist(a => a.MerchantGuid == RFrameGenerate.Common.CurrentManage.MerchantGuid && a.ParameterName == AutoReplyRule.ConstRuleName.AutoReply1) == true)
                    query.Update(a => new object[] { a.ParameterValue == txt }, b => b.ParameterName == RFrameGenerate.BLL.AutoReplyRule.ConstRuleName.AutoReply1 && b.MerchantGuid == RFrameGenerate.Common.CurrentManage.MerchantGuid);
                else
                    query.Add(new T_SYS_Parameter()
                    {
                        ParameterName = AutoReplyRule.ConstRuleName.AutoReply1,
                        MerchantGuid = RFrameGenerate.Common.CurrentManage.MerchantGuid,
                        ParameterValue = txt,
                        ParameterDescription = "自动回复规则",
                        ParameterGuid = Guid.NewGuid(),
                        ParameterType = 1,
                    }
);
            }
        }
        public static string GetTxt2()
        {
            using (var query = Factory.CreateT_SYS_Parameter())
            {
                var para = query.GetFirstData(a => a.ParameterName == AutoReplyRule.ConstRuleName.AutoReply2 && a.MerchantGuid == RFrameGenerate.Common.CurrentManage.MerchantGuid);
                if (para == null)
                {
                    return string.Empty;
                }
                return para.ParameterValue;
            }
        }
        public static void SetTxt2(string txt)
        {
            using (var query = Factory.CreateT_SYS_Parameter())
            {
                if (query.IsExist(a => a.MerchantGuid == RFrameGenerate.Common.CurrentManage.MerchantGuid && a.ParameterName == AutoReplyRule.ConstRuleName.AutoReply2) == true)
                    query.Update(a => new object[] { a.ParameterValue == txt }, b => b.ParameterName == RFrameGenerate.BLL.AutoReplyRule.ConstRuleName.AutoReply2 && b.MerchantGuid == RFrameGenerate.Common.CurrentManage.MerchantGuid);
                else
                    query.Add(new T_SYS_Parameter()
                    {
                        ParameterName = AutoReplyRule.ConstRuleName.AutoReply2,
                        MerchantGuid = RFrameGenerate.Common.CurrentManage.MerchantGuid,
                        ParameterValue = txt,
                        ParameterDescription = "自动回复规则",
                        ParameterGuid = Guid.NewGuid(),
                        ParameterType = 1,
                    }
);
            }
        }
        public static string GetTxt3()
        {
            using (var query = Factory.CreateT_SYS_Parameter())
            {
                var para = query.GetFirstData(a => a.ParameterName == AutoReplyRule.ConstRuleName.AutoReply3 && a.MerchantGuid == RFrameGenerate.Common.CurrentManage.MerchantGuid);
                if (para == null)
                {
                    return string.Empty;
                }
                return para.ParameterValue;
            }
        }
        public static void SetTxt3(string txt)
        {
            using (var query = Factory.CreateT_SYS_Parameter())
            {
                if (query.IsExist(a => a.MerchantGuid == RFrameGenerate.Common.CurrentManage.MerchantGuid && a.ParameterName == AutoReplyRule.ConstRuleName.AutoReply3) == true)
                    query.Update(a => new object[] { a.ParameterValue == txt }, b => b.ParameterName == RFrameGenerate.BLL.AutoReplyRule.ConstRuleName.AutoReply3 && b.MerchantGuid == RFrameGenerate.Common.CurrentManage.MerchantGuid);
                else
                    query.Add(new T_SYS_Parameter()
                    {
                        ParameterName = AutoReplyRule.ConstRuleName.AutoReply3,
                        MerchantGuid = RFrameGenerate.Common.CurrentManage.MerchantGuid,
                        ParameterValue = txt,
                        ParameterDescription = "自动回复规则",
                        ParameterGuid = Guid.NewGuid(),
                        ParameterType = 1,
                    }
);
            }
        }
        public static string GetTxt4()
        {
            using (var query = Factory.CreateT_SYS_Parameter())
            {
                var para = query.GetFirstData(a => a.ParameterName == AutoReplyRule.ConstRuleName.AutoReply4 && a.MerchantGuid == RFrameGenerate.Common.CurrentManage.MerchantGuid);
                if (para == null)
                {
                    return string.Empty;
                }
                return para.ParameterValue;
            }
        }
        public static void SetTxt4(string txt)
        {
            using (var query = Factory.CreateT_SYS_Parameter())
            {
                if (query.IsExist(a => a.MerchantGuid == RFrameGenerate.Common.CurrentManage.MerchantGuid && a.ParameterName == AutoReplyRule.ConstRuleName.AutoReply4) == true)
                    query.Update(a => new object[] { a.ParameterValue == txt }, b => b.ParameterName == RFrameGenerate.BLL.AutoReplyRule.ConstRuleName.AutoReply4 && b.MerchantGuid == RFrameGenerate.Common.CurrentManage.MerchantGuid);
                else
                    query.Add(new T_SYS_Parameter()
                    {
                        ParameterName = AutoReplyRule.ConstRuleName.AutoReply4,
                        MerchantGuid = RFrameGenerate.Common.CurrentManage.MerchantGuid,
                        ParameterValue = txt,
                        ParameterDescription = "自动回复规则",
                        ParameterGuid = Guid.NewGuid(),
                        ParameterType = 1,
                    }
);
            }
        }
        #endregion

        #region 分销背景图片类型
        /// <summary>
        /// 获取分销背景图片类型
        /// </summary>
        /// <returns></returns>
        public static int GetImageType()
        {
            using (var query = Factory.CreateT_SYS_Parameter())
            {
                var para = query.GetFirstData(a => a.ParameterName == RFrameGenerate.BLL.ParameterName.ImageDistributionType.Name && a.MerchantGuid == RFrameGenerate.Common.CurrentManage.MerchantGuid);
                if (para == null)
                {
                    SetImageType(DictionaryConst.ImageDistributionType.Default);
                    return DictionaryConst.ImageDistributionType.Default;
                }
                else
                    return int.Parse(para.ParameterValue);
            }
        }
        /// <summary>
        /// 设置分销背景图片类型
        /// </summary>
        /// <param name="imgType"></param>
        public static void SetImageType(int imgType)
        {
            using (var query = Factory.CreateT_SYS_Parameter())
            {
                if (query.IsExist(a => a.ParameterName == RFrameGenerate.BLL.ParameterName.ImageDistributionType.Name && a.MerchantGuid == RFrameGenerate.Common.CurrentManage.MerchantGuid) == true)
                    query.Update(a => new object[] { a.ParameterValue == imgType.ToString() }, b => b.ParameterName == RFrameGenerate.BLL.ParameterName.ImageDistributionType.Name && b.MerchantGuid == RFrameGenerate.Common.CurrentManage.MerchantGuid);
                else
                    query.Add(new T_SYS_Parameter()
                    {
                        ParameterName = RFrameGenerate.BLL.ParameterName.ImageDistributionType.Name,
                        MerchantGuid = RFrameGenerate.Common.CurrentManage.MerchantGuid,
                        ParameterValue = imgType.ToString(),
                        ParameterDescription = "图片分销类型",
                        ParameterGuid = Guid.NewGuid(),
                        ParameterType = 1,
                    });
            }
        }
        #endregion

        /// <summary>
        /// 获取店铺分享类型
        /// </summary>
        /// <returns></returns>
        public static int GetStoreShareType()
        {
            using (var query = Factory.CreateT_SYS_Parameter())
            {
                var para = query.GetFirstData(a => a.ParameterName == RFrameGenerate.BLL.ParameterName.DistributionMemeber.StoreShareType && a.MerchantGuid == RFrameGenerate.Common.CurrentManage.MerchantGuid);
                if (para == null)
                {
                    return DictionaryConst.StoreShareType.Store;
                }
                else
                    return int.Parse(para.ParameterValue);
            }
        }
        /// <summary>
        /// 获取分销关系类型
        /// </summary>
        /// <returns></returns>
        public static int GetDistributionLockRelation()
        {
            using (var query = Factory.CreateT_SYS_Parameter())
            {
                var para = query.GetFirstData(a => a.ParameterName == RFrameGenerate.BLL.ParameterName.DistributionMemeber.DistributionLockRelation && a.MerchantGuid == RFrameGenerate.Common.CurrentManage.MerchantGuid);
                if (para == null)
                {
                    return DictionaryConst.DistributionLockRelation.First;
                }
                else
                    return int.Parse(para.ParameterValue);
            }
        }
        /// <summary>
        /// 保存会员绑定商家的关系
        /// </summary>
        /// <param name="type"></param>
        /// <returns></returns>
        public static Result SaveMemberBindMerchant(string type)
        {
            using (var query = Factory.CreateT_SYS_Parameter())
            {
                if (query.IsExist(a => a.ParameterName == ParameterName.MemberBindMerchant && a.MerchantGuid == RFrameGenerate.Common.CurrentManage.MerchantGuid) == true)
                {
                    query.Update(a => new object[] { a.ParameterValue == type }, b => b.MerchantGuid == RFrameGenerate.Common.CurrentManage.MerchantGuid && b.ParameterName == ParameterName.MemberBindMerchant);
                }
                else
                {
                    query.Add(new T_SYS_Parameter()
                    {
                        MerchantGuid = RFrameGenerate.Common.CurrentManage.MerchantGuid,
                        ParameterName = ParameterName.MemberBindMerchant,
                        ParameterDescription = "会员绑定商家",
                        ParameterValue = type,
                        ParameterGuid = Guid.NewGuid(),
                        ParameterType = 1,
                    });
                }
                return new Result(true);
            }
        }
        /// <summary>
        /// 获取会员绑定商家的关系
        /// </summary>
        /// <returns></returns>
        public static string GetMemberBindMerchant(Guid? merchGuid = null)
        {
            if (merchGuid == null) merchGuid = RFrameGenerate.Common.CurrentManage.MerchantGuid;

           merchGuid = HeadPay.GetPayMerchantGuid(merchGuid.Value);

            using (var query = Factory.CreateT_SYS_Parameter())
            {
                var para = query.GetFirstData(a => a.ParameterName == ParameterName.MemberBindMerchant && a.MerchantGuid == merchGuid);
                if (para == null)
                    return RFrameGenerate.BLL.DictionaryConst.MemberMerchant.First;
                else
                    return para.ParameterValue;
            }
        }
    }
}
