﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace RFrameGenerate.BLL
{
    /// <summary>
    /// 参数名
    /// </summary>
    public class ParameterName
    {
        public const string WeiXinShareSeting = "WeiXinShareSeting";
        #region 微信配置
        /// <summary>
        /// 微信配置url
        /// </summary>
        public const string WeiXinUrl = "WeiXinUrl";
        /// <summary>
        /// 微信Token
        /// </summary>
        public const string WeiXinToken = "WeiXinToken";


        /// <summary>
        /// 微信名
        /// </summary>
        public const string WeiXinName = "WeiXinName";
        /// <summary>
        /// 微信原始id
        /// </summary>
        public const string WeiXinOpenID = "WeiXinOpenID";
        /// <summary>
        /// 微信号
        /// </summary>
        public const string WeiXinNo = "WeiXinNo";
        /// <summary>
        /// 微信WeiXinAppID
        /// </summary>
        public const string WeiXinAppID = "WeiXinAppID";
        /// <summary>
        /// 微信AppsecretID
        /// </summary>
        public const string AppsecretID = "AppsecretID";
        /// <summary>
        /// 是否认证
        /// </summary>
        public const string IsApprove = "IsApprove";
        /// <summary>
        /// 定订阅号引导关注的链接
        /// </summary>
        public const string GuanZhuLink = "GuanZhuLink";



        /// <summary>
        /// 定订阅号引导关注的链接
        /// </summary>
        public const string ActivityRule = "ActivityRule";

        /// <summary>
        /// 微信用户同步出错时的openid
        /// </summary>
        public const string System_WeiXinUserSyncLastOpenID = "System_WeiXinUserSyncLastOpenID";

        #endregion
        /// <summary>
        /// 会员管理相关参数名
        /// </summary>
        public class MemberManage
        {
            /// <summary>
            /// 等级条件
            /// </summary>
            public const string LevelConditions = "levelConditions";
            /// <summary>
            /// 是否启用会员折扣
            /// </summary>
            public const string OpenMemberDiscounts = "openMemberDiscounts";
        }
        /// <summary>
        /// 交易订单相关参数名
        /// </summary>
        public class Order
        {
            /// <summary>
            /// 未付款订单系统自动过期时间
            /// </summary>
            public const string AutoExpirationTime = "autoExpirationTime";
            /// <summary>
            /// 系统自动收货确认
            /// </summary>
            public const string AutomaticWrite = "automaticWrite";
            /// <summary>
            /// 用户可延长收货时间
            /// </summary>
            public const string ExtendedReceipt = "extendedReceipt";
        }
        /// <summary>
        /// 交易退款相关参数名
        /// </summary>
        public class Refund
        {
            /// <summary>
            /// 是否启用退款/退货服务
            /// </summary>
            public const string OpenRefundService = "openRefundService";
            /// <summary>
            /// 退款服务
            /// </summary>
            public const string RefundService = "refundService";
            /// <summary>
            /// 买家支付后，商家未发货前
            /// </summary>
            public const string RefundService_paid = "refundService_paid";
            /// <summary>
            /// 商家发货后，买家没有收到货
            /// </summary>
            public const string RefundService_delivery = "refundService_delivery";
            /// <summary>
            /// 收货确认后
            /// </summary>
            public const string RefundService_completed = "refundService_completed";
            /// <summary>
            /// 有效期
            /// </summary>
            public const string RefundService_validity = "refundService_validity";

        }
        /// <summary>
        /// 交易余额提现相关参数名
        /// </summary>
        public class Withdraw
        {
            /// <summary>
            /// 选择支持的支付方式
            /// </summary>
            public const string Payments = "payments";
            /// <summary>
            /// 最低提现金额
            /// </summary>
            public const string MinAmount = "minAmount";
            /// <summary>
            /// 提现次数限制
            /// </summary>
            public const string ExtNumber = "extNumber";
        }
        /// <summary>
        /// 会员绑定商家关系
        /// </summary>
        public const string MemberBindMerchant = "MemberBindMerchant";

        /// <summary>
        /// 分销会员相关参数
        /// </summary>
        public class DistributionMemeber
        {
            /// <summary>
            /// 分销商关系设置
            /// </summary>
            public const string DistributorRelations = "distributorRelations";
            /// <summary>
            /// 启用分销排行版
            /// </summary>
            public const string Distributionchart = "distributionchart";
            /// <summary>
            /// 显示TOP数量
            /// </summary>
            public const string TopNumber = "topNumber";
            /// <summary>
            /// 分销商申请审核方式
            /// </summary>
            public const string AuditApproachNew = "auditApproach";
            /// <summary>
            /// 系统自动审核条件
            /// </summary>
            public const string BaseAmount = "baseAmount";
            /// <summary>
            /// 店铺分享类型
            /// </summary>
            public const string StoreShareType = "storeShareType";
            /// <summary>
            /// 分销锁定关系
            /// </summary>
            public const string DistributionLockRelation = "distributionLockRelation";
            /// <summary>
            /// 关闭发送给朋友，朋友圈
            /// </summary>
            public const string EnableShareFriends = "EnableShareFriends";
            /// <summary>
            /// 修改分销商店铺信息
            /// </summary>
            public const string DistributionStoreInfo = "DistributionStoreInfo";
            /// <summary>
            /// 分销订单显示上级分销商信息
            /// </summary>
            public const string DistributionVisible = "distributionVisible";
        }
        /// <summary>
        /// 分销佣金设置提现
        /// </summary>
        public class CommissionMember
        {
            /// <summary>
            /// 一级佣金(销售佣金)
            /// </summary>
            public const string FirstCommission = "firstCommission";
            /// <summary>
            /// 二级佣金(上级佣金)
            /// </summary>
            public const string SecondCommission = "secondCommission";
            /// <summary>
            /// 三级佣金(上上级佣金)
            /// </summary>
            public const string ThirdCommission = "thirdCommission";
            /// <summary>
            /// 佣金结算时间限制
            /// </summary>
            public const string CommissionSettlementTime = "commissionSettlementTime";
        }
        /// <summary>
        /// 分销佣金提现相关参数
        /// </summary>
        public class Distribution
        {
            /// <summary>
            /// 提现金额限制
            /// </summary>
            public const string WithdrawalAmountLimits = "withdrawalAmountLimits";
            /// <summary>
            /// 每月提现次数限制
            /// </summary>
            public const string WithdrawalNumberLimits = "withdrawalNumberLimits";
            /// <summary>
            /// 提现审核金额限制
            /// </summary>
            public const string AmountLimit = "amountLimit";
        }

        /// <summary>
        /// 系统设置相关参数名
        /// </summary>
        public class SystemSet
        {
            /// <summary>
            /// 店铺状态
            /// </summary>
            public const string ShowState = "showState";
            /// <summary>
            /// 关闭原因
            /// </summary>
            public const string CloseReason = "closeReason";
        }

        public class AddressInfo
        {
            /// <summary>
            /// 国家
            /// </summary>
            public const string Country = "Country";
            /// <summary>
            /// 省份
            /// </summary>
            public const string Province = "Province";
            /// <summary>
            /// 城市
            /// </summary>
            public const string City = "City";
            /// <summary>
            /// 地区
            /// </summary>
            public const string Area = "Area";
        }

        /// <summary>
        /// 店铺信息相关参数名
        /// </summary>
        public class ShopInfo
        {
            /// <summary>
            /// 店铺名称
            /// </summary>
            public const string StoreName = "storeName";
            /// <summary>
            /// 店铺LOGO
            /// </summary>
            public const string ShopLOGO = "shopLOGO";
            /// <summary>
            /// 分销商背景图
            /// </summary>
            public const string DistributorBackground = "distributorBackground";
            /// <summary>
            /// 商家介绍图
            /// </summary>
            public const string BusinessDescription = "businessDescription";
            /// <summary>
            /// 二级域名
            /// </summary>
            public const string DomainNames = "domainNames";
            /// <summary>
            /// 国家
            /// </summary>
            public const string Country = "country";
            /// <summary>
            /// 省份
            /// </summary>
            public const string Province = "province";
            /// <summary>
            /// 城市
            /// </summary>
            public const string Town = "town";
            /// <summary>
            /// 地区
            /// </summary>
            public const string Area = "area";
            /// <summary>
            /// 详细地址
            /// </summary>
            public const string Address = "address";
            /// <summary>
            /// 邮政编码
            /// </summary>
            public const string ZipCode = "zipCode";
            /// <summary>
            /// 联系人
            /// </summary>
            public const string Contacts = "contacts";
            /// <summary>
            /// 联系电话
            /// </summary>
            public const string TelPhone = "telPhone";
            /// <summary>
            /// 客服姓名
            /// </summary>
            public const string CustomerName = "customerName";
            /// <summary>
            /// 客服电话
            /// </summary>
            public const string ServicePhone = "servicePhone";
            /// <summary>
            /// E-Mail
            /// </summary>
            public const string EMail = "eMail";
            /// <summary>
            /// 价格标签
            /// </summary>
            public const string PriceTag = "priceTag";
            /// <summary>
            /// 店铺描述
            /// </summary>
            public const string ShopDescription = "shopDescription";
        }

        /// <summary>
        /// 图片分销类型
        /// </summary>
        public class ImageDistributionType
        {
            public const string Name = "ImageDistributionType";
            /// <summary>
            /// 分销背景图片保存时间
            /// </summary>
            public const string UpdateImageName = "ImageTypeUpdateName";
        }
        /// <summary>
        /// 营销活动
        /// </summary>
        public class MarketingName
        {
            /// <summary>
            /// 优惠券
            /// </summary>
            public const string Coupon = "CouponName";
            /// <summary>
            /// 一元购
            /// </summary>
            public const string Crowdfunding = "CrowdfundingName";

            /// <summary>
            /// 积分
            /// </summary>
            public const string IntegralEnable = "IntegralEnableName";
            /// <summary>
            /// 会员等级
            /// </summary>
            public const string MemberLevel = "marketing_MemberLevel";

        }

        /// <summary>
        /// 商家自定义积分规则
        /// </summary>
        public class IntegralRulesName
        {
            public class MaxUseIntegralType
            {
                /// <summary>
                /// 百分数
                /// </summary>
                public const int MaxUseIntegralTypeA = 1;
                /// <summary>
                /// 固定金额
                /// </summary>
                public const int MaxUseIntegralTypeB = 2;
            }
        }

        /// <summary>
        /// 分销自定义
        /// </summary>
        public class DiyDistributionName
        {
            public const string BottomNav = "diy_distribution_bottom_nav";
            public const string BottomNavLink = "diy_distribution_bottom_nav_link";
            public const string FirstCommission = "diy_distribution_first_commission";
            public const string SecondCommission = "diy_distribution_second_commission";
            public const string ThirdCommission = "diy_distribution_third_commission";
            public const string SecondGroup = "diy_distribution_second_group";
            public const string ThirdGroup = "diy_distribution_third_group";
            public const string FirstOrder = "diy_distribution_first_order";
            public const string SecondOrder = "diy_distribution_second_order";
            public const string ThirdOrder = "diy_distribution_third_order";
            public const string BecomeReseller = "diy_distribution_become_reseller";
            public const string BecomeResellerButton = "diy_distribution_become_reseller_button";
            public const string DistributionPrivilege = "diy_distribution_distribution_privilege";
        }

        /// <summary>
        /// 分销贡献榜
        /// </summary>
        public class DistributeContribute
        {
            /// <summary>
            /// 是否开启
            /// </summary>
            public const string Active = "distribute_contribute_active";
            /// <summary>
            /// 显示数量
            /// </summary>
            public const string TopNum = "distribute_contribute_top_num";
            /// <summary>
            /// 是否指定分销商
            /// </summary>
            public const string Designated = "distribute_contribute_designated";
        }

        public class LogisticsTemplate
        {
            /// <summary>
            /// 取最大值
            /// </summary>
            public const string LogisticsSum = "logisticstemplate_logisticssum";

        }
    }
}
