﻿using RFrameGenerate.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using RFramework.SQLServer;

namespace RFrameGenerate.BLL
{
    public class PayWaysManage
    {
        public static List<PT_BAS_MerchantByPayWay> GetMerchantByPayWayList()
        {
            using (var query = Factory.CreateProcedure())
            {
                return query.GetMerchantByPayWayList();
            }
        }
        public static Result Save(Guid PayWayGuid, string jsondata, bool IsEnable)
        {
            try
            {
                using (var tran = new SqlRTransaction())
                {
                    var queryMerchPay = Factory.CreateT_BAS_MerchantsPayWay(tran);
                    if (queryMerchPay.IsExist(a => a.MerchantGuid == RFrameGenerate.Common.CurrentManage.MerchantGuid && a.PayWayGuid == PayWayGuid))
                    {
                        queryMerchPay.Update(a => new object[]
                        {
                           a.IsEnable==IsEnable,
                           a.Prop==jsondata,
                        }, a => a.MerchantGuid == RFrameGenerate.Common.CurrentManage.MerchantGuid && a.PayWayGuid == PayWayGuid);
                    }
                    else
                    {
                        queryMerchPay.Add(new T_BAS_MerchantsPayWay()
                        {
                            PayWayGuid = PayWayGuid,
                            Prop = jsondata,
                            IsEnable = IsEnable,
                            MerchantGuid = RFrameGenerate.Common.CurrentManage.MerchantGuid,
                            MerchantPayWayGuid = Guid.NewGuid(),
                        });
                    }
                }
                return new Result(true);
            }
            catch (Exception ex)
            {
                return new Result(false, ex.Message);
            }
        }

    }
}
