﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using RFrameGenerate.Model;

namespace RFrameGenerate.BLL
{
    public class ProductAntiFakeManage
    {
        public static List<T_BAS_ProductAntiFake> GetAntiFakesList(string securityCode, Guid productGuid)
        {
            using (var query = Factory.CreateT_BAS_ProductAntiFake())
            {
                return query.GetList(c => c.ProductGuid == productGuid && c.Code == securityCode);
            }
        }

        public static Result SetCheckSecurity(string securityCode, Guid productGuid)
        {
            using (var query = Factory.CreateT_BAS_ProductAntiFake())
            {
                query.Update(a =>new object[]
                {
                    a.CheckNum ==1,
                    a.CreateDate==DateTime.Now
                },c=>c.ProductGuid == productGuid && c.Code == securityCode);
            }
            return new Result(true);
        }
        public static Result AddSecurityCode(List<T_BAS_ProductAntiFake> list)
        {
            using (var query = Factory.CreateT_BAS_ProductAntiFake())
            {
                query.AddList(list);
                return new Result(true);
            }
        }
    }
}
