﻿using RFrameGenerate.Model;
using RFramework.SQLServer;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using RFramework.SQLQuery;
namespace RFrameGenerate.BLL.Products
{
    public class ProductCategorysManage
    {
        /// <summary>
        ///获取商品店内分类列表
        /// </summary>
        /// <returns></returns>
        public static List<T_BAS_ProductCategorys> GetList()
        {
            using (var query = Factory.CreateT_BAS_ProductCategorys())
            {
                var list = query.GetList(c => c.MerchantGuid == RFrameGenerate.Common.CurrentManage.MerchantGuid, false, a => a.Sort, DAL.Enums.OrderMethods.DESC,RFramework.SQLServer.Enums.LockType.Default,false);
                return list.OrderBy(a => a.Sort).OrderBy(a => a.Levels).ToList();
            }
        }
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public static List<T_BAS_ProductCategorys> GetCategoryList()
        {
            using (var query = Factory.CreateT_BAS_ProductCategorys())
            {
                return query.GetList(c => c.MerchantGuid == RFrameGenerate.Common.CurrentManage.MerchantGuid,false,a=>a.Sort,DAL.Enums.OrderMethods.DESC);
            }
        }
        /// <summary>
        /// 分类排序（按已使用的分类进行排序）
        /// </summary>
        /// <returns></returns>
        public static List<T_BAS_ProductCategorys> GetProductCategory()
        {
            var query = Factory.CreateT_BAS_Products();
            try
            {
                List<T_BAS_ProductCategorys> list = LoadData();
                if (list.Count == 0) return new List<T_BAS_ProductCategorys>();
                return list.Where(a=>a.Flag==true).ToList();
            }
            catch
            {
                return new List<T_BAS_ProductCategorys>(); 
            }
            finally
            {
                query.Dispose();
            }
        }

        public static List<T_BAS_ProductCategorys> GetProductCategoryByOrder(List<T_BAS_ProductCategorys> list)
        {
            var relList = new List<T_BAS_ProductCategorys>();
            if (list != null && list.Count > 0)
            {
                foreach (var item in list)
                {
                    if (relList.Exists(m => m.ProductCategoryGuid == item.ProductCategoryGuid)) continue;

                    relList.Add(item);

                    GetSubList(item, ref list, ref relList);
                }
            }
            return relList;
        }
        public static void GetSubList(T_BAS_ProductCategorys entity, ref List<T_BAS_ProductCategorys> list, ref List<T_BAS_ProductCategorys> relList)
        {
            if (entity == null) return;

            foreach (var item in list.Where(m => m.ParentGuid == entity.ProductCategoryGuid).OrderBy(a => a.Sort))
            {
                if (relList.Exists(m => m.ProductCategoryGuid == item.ProductCategoryGuid)) continue;

                relList.Add(item);

                if (list.Exists(m => m.ParentGuid == item.ProductCategoryGuid))
                    GetSubList(item, ref list, ref relList);
            }
        }

        /// <summary>
        /// 加载分类列表
        /// </summary>
        /// <param name="gridModel"></param>
        /// <returns></returns>
        public static List<T_BAS_ProductCategorys> LoadData(GridModel gridModel)
        {
            using (var tran=new SqlRTransaction())
            {
                var query = Factory.CreateT_BAS_ProductCategorys(tran);
                var query_product = Factory.CreateT_BAS_Products(tran);
                var list=query.GetPageList(gridModel, a => a.MerchantGuid == RFrameGenerate.Common.CurrentManage.MerchantGuid, false,null, DAL.Enums.OrderMethods.ASC,RFramework.SQLServer.Enums.LockType.Default,false);
                foreach (var item in list)
                {
                    item.Flag = query_product.IsExist(c => c.ProductCategoryGuid == item.ProductCategoryGuid);
                }
                if (list.Count > 0)
                    return list.OrderBy(a => a.Levels).ThenBy(a => a.Sort).ToList();
                return new List<T_BAS_ProductCategorys>();
            }
        }

        /// <summary>
        /// 加载分类列表
        /// </summary>
        /// <returns></returns>
        public static List<T_BAS_ProductCategorys> LoadData()
        {
            using (var tran = new SqlRTransaction())
            {
                var query = Factory.CreateT_BAS_ProductCategorys(tran);
                var query_product = Factory.CreateT_BAS_Products(tran);
                var list = query.GetList(a => a.MerchantGuid == RFrameGenerate.Common.CurrentManage.MerchantGuid, false, null, DAL.Enums.OrderMethods.ASC, RFramework.SQLServer.Enums.LockType.Default, false);
                foreach (var item in list)
                {
                    item.Flag = query_product.IsExist(c => c.ProductCategoryGuid == item.ProductCategoryGuid&&c.IsPutaway==true&&c.MerchantGuid==Common.CurrentManage.MerchantGuid);
                }
                if (list.Count > 0)
                {
                    return GetProductCategoryByOrder(list.OrderBy(a => a.Levels).ThenBy(a => a.Sort).ToList());
                }
                return null;
            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="entity"></param>
        /// <returns></returns>
        public static Result SaveChangeEntity(T_BAS_ProductCategorys entity)
        {
            try
            {
                using (var query = Factory.CreateT_BAS_ProductCategorys())
                {
                    var srcEntity = query.GetFirstData(p => p.ProductCategoryGuid == entity.ProductCategoryGuid&&p.MerchantGuid==Common.CurrentManage.MerchantGuid,false,null,DAL.Enums.OrderMethods.Default,RFramework.SQLServer.Enums.LockType.Default,false);
                    
                    if (srcEntity == null)
                    {
                        var list = query.GetList(a => a.CategoryName == entity.CategoryName && a.MerchantGuid == Common.CurrentManage.MerchantGuid, false, null, DAL.Enums.OrderMethods.Default, RFramework.SQLServer.Enums.LockType.Default, false);
                        if (list != null && list.Count > 0)
                        {
                            return new Result(false, "分类名称不能重复！");
                        }
                        query.Add(entity);
                    }
                    //更新
                    else
                    {
                        query.Update(a => new Object[] {
                            a.CategoryName==entity.CategoryName,
                            a.CategoryCode==entity.CategoryCode,
                            a.Url==entity.Url,
                            a.Levels==entity.Levels,
                            a.ParentGuid==entity.ParentGuid,
                            a.Sort==entity.Sort
                        }, a => a.MerchantGuid == Common.CurrentManage.MerchantGuid && a.ProductCategoryGuid==entity.ProductCategoryGuid, false);
                    }
                }
                return new Result(true);
            }
            catch (Exception ex)
            {
                return new Result(false, ex.Message);
            }
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="guid"></param>
        /// <param name="relList"></param>
        /// <returns></returns>
        public static Result DeleteEntity(Guid guid, ref List<T_BAS_ProductCategorys> relList)
        {
            if (guid == Guid.Empty) return new Result(false, "没有数据删除！");

            using (var query = Factory.CreateT_BAS_ProductCategorys())
            {
                var model = query.GetFirstData(p => p.ProductCategoryGuid == guid,false,null,DAL.Enums.OrderMethods.Default,RFramework.SQLServer.Enums.LockType.Default,false);

                if (model == null) return new Result(false, "没有数据删除！");

                //获取子节点
                relList = query.GetList(p => p.ParentGuid == model.ProductCategoryGuid,false,null,DAL.Enums.OrderMethods.Default,RFramework.SQLServer.Enums.LockType.Default,false);

                model.EntityState = EntityStates.ToBeDelete;

                relList.Add(model);

                query.DeleteList(relList,false);
            }
            return new Result(true);
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="top"></param>
        /// <returns></returns>
        public static T_BAS_ProductCategorys GetTopModel(int top)
        {
            using (var query = Factory.CreateProcedure())
            {
                return query.GetProductCategorys(top);
            }
        }
    }
}
