﻿using RFrameGenerate.Model;
using RFrameGenerate.Model.PageModel;
using RFramework.SQLServer;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace RFrameGenerate.BLL.Recharge
{
    public class RechargeRecordManage
    {
        public static List<T_BAS_RechargeRecord> GetPageList(GridModel gridModel, int? type)
        {
            using (var query = Factory.CreateT_BAS_RechargeRecord())
            {
                if (type == null || type <= 0)
                    return query.GetPageList(gridModel, m => m.MerchantGuid == Common.CurrentManage.MerchantGuid && m.MemberGuid == Common.CurrentUser.GetCurrUserGuid(), false, v => v.OperateTime, DAL.Enums.OrderMethods.DESC, RFramework.SQLServer.Enums.LockType.Default, false);
                else
                    return query.GetPageList(gridModel, m => m.Type == type && m.MerchantGuid == Common.CurrentManage.MerchantGuid && m.MemberGuid == Common.CurrentUser.GetCurrUserGuid(), false, v => v.OperateTime, DAL.Enums.OrderMethods.DESC, RFramework.SQLServer.Enums.LockType.Default, false);
            }
        }
        public static Result AddConsume(string orderNo, Guid orderGuid, Guid memberGuid, decimal tradeAmount, decimal srcAmount, decimal srcBalance, string tempProName, decimal memBalance,SqlRTransaction tran)
        {
            var query = Factory.CreateT_BAS_RechargeRecord(tran);
            //tran.BeginTransaction();
            //try
            //{ 
            query.Add(new T_BAS_RechargeRecord()
            {
                RechargeRecordGuid = Guid.NewGuid(),
                TradeAmount = tradeAmount,
                SrcMemberAmount = srcAmount,
                SrcMemberBalance = srcBalance,
                MemberAmount = srcAmount - tradeAmount,
                MemberBalance = srcBalance - tradeAmount,
                MemberGuid = memberGuid,
                OrderNo = orderNo,
                MerchantGuid = Common.CurrentManage.MerchantGuid,
                OperateTime = DateTime.Now,
                Type = DictionaryConst.RechargeType.Consume,
            });

            //添加会员账户记录 Bing 160423
            MemberAccountManage.AddMemberAccount(memberGuid, MemberAccountConst.TradingType.消费_购买商品, orderGuid, -tradeAmount, tran, memBalance, Common.CurrentManage.MerchantGuid, tempProName);

            //tran.Commit();
            return new Result(true);

            //}
            //catch (Exception ex)
            //{
            //tran.Rollback();
            //return new Result(false, ex.Message);
            //}
            //}

        }

        public static Result AddRefund(string orderNo, Guid memberGuid, decimal tradeAmount, decimal srcAmount, decimal srcBalance, Guid? merGuid = null)
        {
            using (var query = Factory.CreateT_BAS_RechargeRecord())
            {
                if (merGuid == null)
                {
                    merGuid = Common.CurrentManage.MerchantGuid;
                }

                query.Add(new T_BAS_RechargeRecord()
                {
                    RechargeRecordGuid = Guid.NewGuid(),
                    TradeAmount = tradeAmount,
                    SrcMemberAmount = srcAmount,
                    SrcMemberBalance = srcBalance,
                    MemberAmount = srcAmount + tradeAmount,
                    MemberBalance = srcBalance + tradeAmount,
                    MemberGuid = memberGuid,
                    OrderNo = orderNo,
                    MerchantGuid = Common.CurrentManage.MerchantGuid,
                    OperateTime = DateTime.Now,
                    Type = DictionaryConst.RechargeType.Refund,
                    SMerchantGuid = merGuid
                });
            }
            return new Result(true);
        }
    }
}
