﻿using RFrameGenerate.Model;
using RFramework.SQLServer;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace RFrameGenerate.BLL
{
    public class RecieverAddressManage
    {
        /// <summary>
        /// 根据会员Guid获取收货地址信息
        /// </summary>
        /// <param name="guid"></param>
        /// <returns></returns>
        public static T_BAS_RecieverAddress GetDefaultAddress(Guid memberGuid)
        {
            using (var query = Factory.CreateT_BAS_RecieverAddress())
            {
                return query.GetFirstData(a => a.MemberGuid == memberGuid && a.IsDefualt == true);
            }
        }

        /// <summary>
        /// 当前用户是否有默认地址
        /// </summary>
        /// <returns></returns>
        public static bool CurrentUserHasDefault()
        {
            using (var query = Factory.CreateT_BAS_RecieverAddress())
            {
                return query.IsExist(a => a.MemberGuid == RFrameGenerate.Common.CurrentUser.GetCurrUserGuid() && a.IsDefualt == true);
            }
        }

        public static T_BAS_RecieverAddress GetSelectAddress(Guid addressGuid)
        {
            using (var query = Factory.CreateT_BAS_RecieverAddress())
            {
                return query.GetFirstData(a => a.RecieverAddressGuid == addressGuid);
            }
        }

        public static T_BAS_RecieverAddress GetEntityByGuid(Guid RecieverAddressGuid)
        {
            using (var query = Factory.CreateT_BAS_RecieverAddress())
            {
                return query.GetFirstData(a => a.RecieverAddressGuid == RecieverAddressGuid,isFilterMerchant:false);
            }
        }

        public static T_BAS_RecieverAddress GetREcieverAdddressByGuid(Guid addressGuid)
        {
            using (var query = Factory.CreateT_BAS_RecieverAddress())
            {
                return query.GetFirstData(a => a.RecieverAddressGuid == addressGuid);
            }
        }

        public static List<T_BAS_RecieverAddress> GetRecieverAddrList(Guid memberGuid)
        {
            using (var query = Factory.CreateT_BAS_RecieverAddress())
            {
                return query.GetList(a => a.MemberGuid == memberGuid);
            }
        }

        public static Result Add(T_BAS_RecieverAddress address)
        {
            try
            {

                using (var query = Factory.CreateT_BAS_RecieverAddress())
                {
                    address.MemberGuid = RFrameGenerate.Common.CurrentUser.GetCurrUserGuid();
                    address.RecieverAddressGuid = Guid.NewGuid();
                    query.Add(address);
                }
                return new Result(true);
            }
            catch (Exception ex)
            {
                return new Result(false, ex.Message);
            }
        }

        public static Result Update(T_BAS_RecieverAddress address)
        {
            try
            {
                using (var query = Factory.CreateT_BAS_RecieverAddress())
                {
                    query.Update(a => new object[]
                    {
                        a.Address==address.Address,
                        a.Area==address.Area,
                        a.City==address.City,
                        a.Province==address.Province,
                        a.Reciever==address.Reciever,
                        a.Zip==address.Zip,
                        a.Telephone==address.Telephone
                    }, b => b.RecieverAddressGuid == address.RecieverAddressGuid);
                }
                return new Result(true);
            }
            catch (Exception ex)
            {
                return new Result(false, ex.Message);
            }
        }

        public static Result DefaultAddress(Guid addressGuid)
        {
            try
            {
                using (var tran = new SqlRTransaction())
                {
                    var query = Factory.CreateT_BAS_RecieverAddress(tran);
                    tran.BeginTransaction();
                    query.Update(a => new object[]
                    {
                        a.IsDefualt==false
                    }, b => b.MemberGuid == RFrameGenerate.Common.CurrentUser.GetCurrUserGuid());
                    query.Update(a => new object[]
                    {
                        a.IsDefualt==true
                    }, b => b.RecieverAddressGuid == addressGuid);
                    tran.Commit();
                }
                return new Result(true);
            }
            catch (Exception ex)
            {
                return new Result(false, ex.Message);
            }
        }

        public static Result Delete(Guid id)
        {
            try
            {
                using (var tran = new SqlRTransaction())
                {
                    var query = Factory.CreateT_BAS_RecieverAddress(tran);
                    var queryOrder = Factory.CreateT_BAS_Orders(tran);
                    if (queryOrder.IsExist(a => a.RecieverAddressGuid == id) == true)
                    {
                        return new Result(false, "订单中已使用该地址无法删除该地址");
                    }
                    else
                    {
                        var querywin = Factory.CreateT_CR_CrowdWinning(tran);
                        if (querywin.IsExist(a => a.RecieverAddressGuid == id) == true)
                        {
                            return new Result(false, "一元购订单中已使用该地址无法删除该地址");
                        }

                        query.Delete(id);
                    }
                }

                return new Result(true);
            }
            catch (Exception ex)
            {
                return new Result(false, ex.Message);
            }
        }

        public static Result ApiAdd(out Guid RecieverAddressGuid, string openid, string username, string telNumber, string addressPostalCode, string proviceFirstStageName, string addressCitySecondStageName, string addressCountiesThirdStageName, string addressDetailInfo, string nationalCode)
        {
            RecieverAddressGuid = Guid.NewGuid();
            try
            {
                using (var tran = new SqlRTransaction())
                {
                    var query = Factory.CreateT_BAS_RecieverAddress(tran);
                    var queryMember = Factory.CreateT_BAS_Member(tran);

                    var member = queryMember.GetFirstData(a => a.MemberOpenID == openid, isFilterMerchant: false);
                    if (member != null)
                    {
                        RFrameGenerate.Common.CurrentUser.SetMerchantGuid(member.MerchantGuid.Value);
                        RFrameGenerate.Common.CurrentUser.SetSMerchantGuid(member.MerchantGuid.Value);
                        RFrameGenerate.Common.CurrentUser.SetCurrUser(member.MemberNickName, member.MemberGuid);
                        var add = query.GetFirstData(a => a.Telephone == telNumber && a.Reciever == username && a.MemberGuid == member.MemberGuid && a.Address == addressDetailInfo, isFilterMerchant: false);
                        if (add == null)
                        {
                            if (proviceFirstStageName.EndsWith("市") == true)
                            {
                                addressCitySecondStageName = proviceFirstStageName;
                            }

                            var isdefualt = query.GetCount(a => a.MemberGuid == member.MemberGuid && a.IsDefualt == true, false) == 0 ? true : false;
                            query.Add(new T_BAS_RecieverAddress()
                            {
                                MemberGuid = member.MemberGuid,
                                RecieverAddressGuid = RecieverAddressGuid,
                                Address = addressDetailInfo,
                                Area = addressCountiesThirdStageName,
                                City = addressCitySecondStageName,
                                Reciever = username,
                                IsDefualt = isdefualt,
                                Province = proviceFirstStageName,
                                Telephone = telNumber,
                                Zip = addressPostalCode
                            });
                            return new Result(true);
                        }
                        else
                        {
                            RecieverAddressGuid = add.RecieverAddressGuid;
                            return new Result(true);
                        }
                    }
                    else
                    {
                        return new Result(false, "会员不存在!");
                    }
                }
            }
            catch (Exception ex)
            {

                return new Result(false, ex.Message);
            }
        }
    }
}
