﻿using RFrameGenerate.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace RFrameGenerate.BLL
{
    public class RefundOrderDetailsManage
    {
        /// <summary>
        /// 根据退款单Guid获取明细
        /// </summary>
        /// <param name="entityGuid"></param>
        /// <returns></returns>
        public static List<T_BAS_RefundOrderDetails> GetList(Guid entityGuid)
        {
            using (var query = Factory.CreateT_BAS_RefundOrderDetails())
            {
                return query.GetList(a => a.RefundApplyGuid == entityGuid, isFilterMerchant: false);
            }
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="orderDetailGuid"></param>
        /// <returns></returns>
        public static T_BAS_RefundOrderDetails GetEntity(Guid orderDetailGuid)
        {
            using (var query = Factory.CreateT_BAS_RefundOrderDetails())
            {
                return query.GetFirstData(a => a.OrderDetailGuid == orderDetailGuid);
            }
        }
    }
}
