﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using RFrameGenerate.Common;
using RFrameGenerate.Model;
using RFramework.SQLQuery;
using RFramework.SQLServer;

namespace RFrameGenerate.BLL
{
    public class ShipAddressManage
    {
        #region List<T_BAS_ShipAddress> GetShipAddressPageList
        /// <summary>
        /// get list data
        /// </summary>
        /// <param name="gridModel"></param>
        /// <param name="name"></param>
        /// <returns></returns>
        public static List<T_BAS_ShipAddress> GetShipAddressPageList(GridModel gridModel, string name)
        {
            using (var query = Factory.CreateT_BAS_ShipAddress())
            {
                return query.GetPageList(gridModel, c => c.ContantName.SqlLike(name), true);
            }
        } 
        #endregion

        #region Result AddAddress
        /// <summary>
        /// add address
        /// </summary>
        /// <param name="entity"></param>
        /// <returns></returns>
        public static Result AddAddress(T_BAS_ShipAddress entity)
        {
            using (var tran = new SqlRTransaction())
            {
                tran.BeginTransaction();
                var query = Factory.CreateT_BAS_ShipAddress(tran);
                entity.ShipAddressGuid=Guid.NewGuid();
                entity.MerchantGuid = CurrentManage.MerchantGuid;
                query.Add(entity);
                tran.Commit();
            }
            return new Result(true);
        } 
        #endregion

        #region Result UpdateAddress
        /// <summary>
        /// update list
        /// </summary>
        /// <param name="entity"></param>
        /// <returns></returns>
        public static Result UpdateAddress(T_BAS_ShipAddress entity)
        {
            using (var query = Factory.CreateT_BAS_ShipAddress())
            {
                query.Update(a => new object[]
                {
                    a.ContantName==entity.ContantName,
                    a.AddressName==entity.AddressName,
                    a.Address==entity.Address,
                    a.Country==entity.Country,
                    a.City==entity.City,
                    a.Area==entity.Area,
                    a.Province==entity.Province,
                    a.Zip==entity.Zip,
                    a.Company==entity.Company,
                    a.Telephone==entity.Telephone
                    
                }, c => c.ShipAddressGuid == entity.ShipAddressGuid);
            }
            return new Result(true);
        } 
        #endregion

        #region Result RemoveAddress
        /// <summary>
        /// remove address list
        /// </summary>
        /// <param name="shipAddressGuid"></param>
        /// <returns></returns>
        public static Result RemoveAddress(Guid shipAddressGuid)
        {
            using (var query = Factory.CreateT_BAS_ShipAddress())
            {
                query.Delete(c => c.ShipAddressGuid == shipAddressGuid);
            }
            return new Result(true);
        }
        /// <summary>
        /// 根据商家guid获取地址列表
        /// </summary>
        /// <param name="guid"></param>
        /// <returns></returns>
        public static List<T_BAS_ShipAddress> GetList(Guid guid)
        {
            using (var query = Factory.CreateT_BAS_ShipAddress()) 
            {
                return  query.GetList(a => a.MerchantGuid == guid);
            }
        }
        /// <summary>
        /// 根据发货Guid获取地址
        /// </summary>
        /// <param name="guid"></param>
        /// <returns></returns>
        public static T_BAS_ShipAddress GetEntity(Guid guid)
        {
            using (var query = Factory.CreateT_BAS_ShipAddress())
            {
                return query.GetFirstData(a => a.ShipAddressGuid == guid);
            }
        }
        #endregion

        public static T_BAS_ShipAddress GetEntityByMerchantGuid(Guid guid)
        {
            using (var query = Factory.CreateT_BAS_ShipAddress())
            {
                return query.GetFirstData(a => a.MerchantGuid == guid);
            }
        }
    }
}
